/*
 * Decompiled with CFR 0.152.
 */
package ml.luxinfine.hooks.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import team.luxinfine.helper.26_10_2024__16_37_46.dtk;
import team.luxinfine.helper.26_10_2024__16_37_46.uc\u0443;
import team.luxinfine.helper.26_10_2024__16_37_46.x\u043er;

class WeakIdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_SIZE = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final ReferenceQueue<K> referenceQueue;
    private int elementCount;
    private Entry<K, V>[] elementData;
    private final int loadFactor;
    private int threshold;
    private volatile int modCount;
    private Set<K> keySet;
    private Collection<V> valuesCollection;

    private static <K, V> Entry<K, V>[] newEntryArray(int n) {
        return new Entry[n];
    }

    public WeakIdentityHashMap() {
        weakIdentityHashMap(16);
        WeakIdentityHashMap<K, V> weakIdentityHashMap;
    }

    public WeakIdentityHashMap(int n) {
         (n, 0.75f);
    }

    public WeakIdentityHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException(dtk."l sf" + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(x\u043er." qsb" + f);
        }
         .elementCount = 0;
         .elementData = WeakIdentityHashMap.newEntryArray(n == 0 ? 1 : n);
         .loadFactor = (int)(f * 10000.0f);
         .computeMaxSize();
         .referenceQueue = new ReferenceQueue();
    }

    public WeakIdentityHashMap(Map<? extends K, ? extends V> map) {
         (map.size() * 2);
         .putAll(map);
    }

    @Override
    public void clear() {
        WeakIdentityHashMap weakIdentityHashMap;
        if (weakIdentityHashMap.elementCount > 0) {
            weakIdentityHashMap.elementCount = 0;
            Arrays.fill(weakIdentityHashMap.elementData, null);
            ++weakIdentityHashMap.modCount;
            while (weakIdentityHashMap.referenceQueue.poll() != null) {
            }
        }
    }

    private void computeMaxSize() {
        WeakIdentityHashMap weakIdentityHashMap;
        weakIdentityHashMap.threshold = (int)((long)weakIdentityHashMap.elementData.length * (long)weakIdentityHashMap.loadFactor / 10000L);
    }

    @Override
    public boolean containsKey(Object object) {
        return  .getEntry(object) != null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        WeakIdentityHashMap weakIdentityHashMap;
        weakIdentityHashMap.poll();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                1 ;
                return 
                .WeakIdentityHashMap.this.size();
            }

            @Override
            public void clear() {
                1  ;
                 .WeakIdentityHashMap.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                if ( .contains(object)) {
                     .WeakIdentityHashMap.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Map.Entry && (\u000a
                 = \u000a
                .WeakIdentityHashMap.this.getEntry(((Map.Entry)object).getKey())) != null && ((\u000a
                 = \u000a
                .get()) != null || \u000a
                .isNull)) {
                    return object.equals(\u000a
                    );
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                1 \u000a;
                return new HashIterator(new Entry.Type<Map.Entry<K, V>, K, V>(){

                    @Override
                    public Map.Entry<K, V> get(Map.Entry<K, V> entry) {
                        return entry;
                    }
                });
            }
        };
    }

    @Override
    public Set<K> keySet() {
        WeakIdentityHashMap weakIdentityHashMap;
        weakIdentityHashMap.poll();
        if (weakIdentityHashMap.keySet == null) {
            weakIdentityHashMap.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object $) {
                    2 $2;
                    return $2.WeakIdentityHashMap.this.containsKey($);
                }

                @Override
                public int size() {
                    2  ;
                    return  .WeakIdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    2  ;
                     .WeakIdentityHashMap.this.clear();
                }

                @Override
                public boolean remove(Object object) {
                    if ( .WeakIdentityHashMap.this.containsKey(object)) {
                         .WeakIdentityHashMap.this.remove(object);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<K> iterator() {
                    2 \u000a\u000a\u000a;
                    return new HashIterator(new Entry.Type<K, K, V>(){

                        @Override
                        public K get(Map.Entry<K, V> $) {
                            return $.getKey();
                        }
                    });
                }
            };
        }
        return weakIdentityHashMap.keySet;
    }

    @Override
    public Collection<V> values() {
        WeakIdentityHashMap weakIdentityHashMap;
        weakIdentityHashMap.poll();
        if (weakIdentityHashMap.valuesCollection == null) {
            weakIdentityHashMap.valuesCollection = new AbstractCollection<V>(){

                @Override
                public int size() {
                    3  \u000a;
                    return  \u000a
                    .WeakIdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    3  ;
                     .WeakIdentityHashMap.this.clear();
                }

                @Override
                public boolean contains(Object $) {
                    3 $2;
                    return $2.WeakIdentityHashMap.this.containsValue($);
                }

                @Override
                public Iterator<V> iterator() {
                    3 \u000a\u000a\u000a\u000a;
                    return new HashIterator(new Entry.Type<V, K, V>(){

                        @Override
                        public V get(Map.Entry<K, V> entry) {
                            return entry.getValue();
                        }
                    });
                }
            };
        }
        return weakIdentityHashMap.valuesCollection;
    }

    @Override
    public V get(Object object) {
        Entry<K, V> entry =  .getEntry(object);
        return entry != null ? (V)entry.value : null;
    }

    private Entry<K, V> getEntry(Object object) {
        \u000a
        .poll();
        if (object != null) {
            int n = (System.identityHashCode(object) & Integer.MAX_VALUE) % \u000a
            .elementData.length;
            Entry<K, V> \u000a\u000a2 = \u000a
            .elementData[n];
            while (\u000a\u000a2 != null) {
                if (object == \u000a\u000a2.get()) {
                    return \u000a\u000a2;
                }
                \u000a\u000a2 = \u000a\u000a2.next;
            }
            return null;
        }
        Entry<K, V> entry = \u000a
        .elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsValue(Object object) {
         .poll();
        if (object != null) {
            int n =  .elementData.length;
            while (--n >= 0) {
                Entry<K, V>  2 =  .elementData[n];
                while ( 2 != null) {
                    Object t =  2.get();
                    if ((t != null ||  2.isNull) && object.equals( 2.value)) {
                        return true;
                    }
                     2 =  2.next;
                }
            }
        } else {
            int n =  .elementData.length;
            while (--n >= 0) {
                Entry<K, V>  3 =  .elementData[n];
                while ( 3 != null) {
                    Object t =  3.get();
                    if ((t != null ||  3.isNull) &&  3.value == null) {
                        return true;
                    }
                     3 =  3.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        WeakIdentityHashMap weakIdentityHashMap;
        return weakIdentityHashMap.size() == 0;
    }

    private void poll() {
        Entry entry;
        while ((entry = (Entry) .referenceQueue.poll()) != null) {
             .removeEntry(entry);
        }
    }

    private void removeEntry(Entry<K, V> entry) {
        entry2 = null;
        int n = (entry.hash & Integer.MAX_VALUE) %  .elementData.length;
        Entry<K, V>  2 =  .elementData[n];
        while ( 2 != null) {
            if (entry ==  2) {
                ++ .modCount;
                if (entry2 == null) {
                     .elementData[n] =  2.next;
                } else {
                    entry2.next =  2.next;
                }
                -- .elementCount;
                break;
            }
            Entry<K, V> entry2 =  2;
             2 =  2.next;
        }
    }

    @Override
    public V put(K $, V $2) {
        Entry<K, V> $3;
        WeakIdentityHashMap $4;
        $4.poll();
        int $5 = 0;
        if ($ != null) {
            $5 = (System.identityHashCode($) & Integer.MAX_VALUE) % $4.elementData.length;
            $3 = $4.elementData[$5];
            while ($3 != null && $ != $3.get()) {
                $3 = $3.next;
            }
        } else {
            $3 = $4.elementData[0];
            while ($3 != null && !$3.isNull) {
                $3 = $3.next;
            }
        }
        if ($3 == null) {
            ++$4.modCount;
            if (++$4.elementCount > $4.threshold) {
                $4.rehash();
                $5 = $ == null ? 0 : (System.identityHashCode($) & Integer.MAX_VALUE) % $4.elementData.length;
            }
            $3 = new Entry<K, V>($, $2, $4.referenceQueue);
            $3.next = $4.elementData[$5];
            $4.elementData[$5] = $3;
            return null;
        }
        Object $6 = $3.value;
        $3.value = $2;
        return $6;
    }

    private void rehash() {
        WeakIdentityHashMap $;
        assert ($.elementData.length > 0);
        int $2 = $.elementData.length * 2;
        Entry<K, V>[] $3 = WeakIdentityHashMap.newEntryArray($2);
        for (Entry<K, V> $4 : $.elementData) {
            while ($4 != null) {
                int $5 = $4.isNull ? 0 : ($4.hash & Integer.MAX_VALUE) % $2;
                Entry $6 = $4.next;
                $4.next = $3[$5];
                $3[$5] = $4;
                $4 = $6;
            }
        }
        $.elementData = $3;
        $.computeMaxSize();
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> \u000a\u000a\u000a\u000a3;
        weakIdentityHashMap.poll();
        int n = 0;
        Entry<K, V> \u000a\u000a\u000a\u000a2 = null;
        if (object != null) {
            n = (System.identityHashCode(object) & Integer.MAX_VALUE) % weakIdentityHashMap.elementData.length;
            \u000a\u000a\u000a\u000a3 = weakIdentityHashMap.elementData[n];
            while (\u000a\u000a\u000a\u000a3 != null && object != \u000a\u000a\u000a\u000a3.get()) {
                \u000a\u000a\u000a\u000a2 = \u000a\u000a\u000a\u000a3;
                \u000a\u000a\u000a\u000a3 = \u000a\u000a\u000a\u000a3.next;
            }
        } else {
            WeakIdentityHashMap weakIdentityHashMap;
            \u000a\u000a\u000a\u000a3 = weakIdentityHashMap.elementData[0];
            while (\u000a\u000a\u000a\u000a3 != null && !\u000a\u000a\u000a\u000a3.isNull) {
                \u000a\u000a\u000a\u000a2 = \u000a\u000a\u000a\u000a3;
                \u000a\u000a\u000a\u000a3 = \u000a\u000a\u000a\u000a3.next;
            }
        }
        if (\u000a\u000a\u000a\u000a3 != null) {
            ++weakIdentityHashMap.modCount;
            if (\u000a\u000a\u000a\u000a2 == null) {
                weakIdentityHashMap.elementData[n] = \u000a\u000a\u000a\u000a3.next;
            } else {
                \u000a\u000a\u000a\u000a2.next = \u000a\u000a\u000a\u000a3.next;
            }
            --weakIdentityHashMap.elementCount;
            return \u000a\u000a\u000a\u000a3.value;
        }
        return null;
    }

    @Override
    public int size() {
        WeakIdentityHashMap weakIdentityHashMap;
        weakIdentityHashMap.poll();
        return weakIdentityHashMap.elementCount;
    }

    private class HashIterator<R>
    implements Iterator<R> {
        private int position = 0;
        private int expectedModCount;
        private Entry<K, V> currentEntry;
        private Entry<K, V> nextEntry;
        private K nextKey;
        private final Entry.Type<R, K, V> type;

        HashIterator(Entry.Type<R, K, V> type) {
             .type = type;
             .expectedModCount =  .WeakIdentityHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            HashIterator hashIterator;
            if (hashIterator.nextEntry != null && (hashIterator.nextKey != null || hashIterator.nextEntry.isNull)) {
                return true;
            }
            while (true) {
                if (hashIterator.nextEntry == null) {
                    while (hashIterator.position < hashIterator.WeakIdentityHashMap.this.elementData.length && (hashIterator.nextEntry = hashIterator.WeakIdentityHashMap.this.elementData[hashIterator.position++]) == null) {
                    }
                    if (hashIterator.nextEntry == null) {
                        return false;
                    }
                }
                hashIterator.nextKey = hashIterator.nextEntry.get();
                if (hashIterator.nextKey != null || hashIterator.nextEntry.isNull) {
                    return true;
                }
                hashIterator.nextEntry = hashIterator.nextEntry.next;
            }
        }

        @Override
        public R next() {
            HashIterator hashIterator;
            if (hashIterator.expectedModCount == hashIterator.WeakIdentityHashMap.this.modCount) {
                if (hashIterator.hasNext()) {
                    hashIterator.currentEntry = hashIterator.nextEntry;
                    hashIterator.nextEntry = hashIterator.currentEntry.next;
                    R r = hashIterator.type.get(hashIterator.currentEntry);
                    hashIterator.nextKey = null;
                    return r;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            HashIterator hashIterator;
            if (hashIterator.expectedModCount != hashIterator.WeakIdentityHashMap.this.modCount) throw new ConcurrentModificationException();
            if (hashIterator.currentEntry == null) throw new IllegalStateException();
            hashIterator.WeakIdentityHashMap.this.removeEntry(hashIterator.currentEntry);
            hashIterator.currentEntry = null;
            ++hashIterator.expectedModCount;
        }
    }

    private static final class Entry<K, V>
    extends WeakReference<K>
    implements Map.Entry<K, V> {
        final int hash;
        boolean isNull;
        V value;
        Entry<K, V> next;

        Entry(K k, V v, ReferenceQueue<K> referenceQueue) {
            super(k, referenceQueue);
             .isNull = k == null;
             .hash =  .isNull ? 0 : System.identityHashCode(k);
             .value = v;
        }

        @Override
        public K getKey() {
            Entry entry;
            return (K)super.get();
        }

        @Override
        public V getValue() {
            Entry $;
            return $.value;
        }

        @Override
        public V setValue(V v) {
              =  .value;
             .value = v;
            return  ;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object $ 2 = super.get();
            return $ 2 == entry.getKey() && ($ .value == null ? $ .value == entry.getValue() : $ .value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            Entry entry;
            return entry.hash + (entry.value == null ? 0 : entry.value.hashCode());
        }

        public String toString() {
            Entry entry;
            return super.get() + uc\u0443." u\u0445r" + entry.value;
        }

        static interface Type<R, K, V> {
            public R get(Map.Entry<K, V> var1);
        }
    }
}

