/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.nei.ItemPanels;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public abstract class ShortcutInputHandler {
    public static boolean handleKeyEvent(ItemStack stackover) {
        if (NEIClientConfig.isKeyHashDown("gui.overlay_hide")) {
            return ShortcutInputHandler.hideOverlayRecipe();
        }
        if (stackover == null) {
            return false;
        }
        stackover = stackover.func_77946_l();
        if (NEIClientConfig.isKeyHashDown("gui.overlay")) {
            return ShortcutInputHandler.openOverlayRecipe(stackover, false);
        }
        if (NEIClientConfig.isKeyHashDown("gui.overlay_use")) {
            return ShortcutInputHandler.openOverlayRecipe(stackover, true);
        }
        if (NEIClientConfig.isKeyHashDown("gui.recipe")) {
            return GuiCraftingRecipe.openRecipeGui("item", stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.usage")) {
            return GuiUsageRecipe.openRecipeGui("item", stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.bookmark")) {
            return ShortcutInputHandler.saveRecipeInBookmark(stackover, false, false);
        }
        if (NEIClientConfig.isKeyHashDown("gui.bookmark_recipe")) {
            return ShortcutInputHandler.saveRecipeInBookmark(stackover, true, false);
        }
        if (NEIClientConfig.isKeyHashDown("gui.bookmark_count")) {
            return ShortcutInputHandler.saveRecipeInBookmark(stackover, false, true);
        }
        if (NEIClientConfig.isKeyHashDown("gui.bookmark_recipe_count")) {
            return ShortcutInputHandler.saveRecipeInBookmark(stackover, true, true);
        }
        return false;
    }

    public static boolean handleMouseClick(ItemStack stackover) {
        if (stackover != null) {
            int button = Mouse.getEventButton();
            stackover = stackover.func_77946_l();
            if (button == 0) {
                return GuiCraftingRecipe.openRecipeGui("item", stackover);
            }
            if (button == 1) {
                return GuiUsageRecipe.openRecipeGui("item", stackover);
            }
        }
        return false;
    }

    private static boolean hideOverlayRecipe() {
        if (LayoutManager.overlayRenderer != null) {
            LayoutManager.overlayRenderer = null;
            return true;
        }
        return false;
    }

    private static boolean openOverlayRecipe(ItemStack stack, boolean shift) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        if (gui == null || gui instanceof GuiRecipe) {
            return false;
        }
        return GuiCraftingRecipe.openRecipeGui("item", true, shift, stack);
    }

    private static boolean saveRecipeInBookmark(ItemStack stack, boolean saveIngredients, boolean saveStackSize) {
        if (stack != null) {
            GuiContainer gui = NEIClientUtils.getGuiContainer();
            List<PositionedStack> ingredients = null;
            String handlerName = "";
            if (gui instanceof GuiRecipe) {
                ingredients = ((GuiRecipe)gui).getFocusedRecipeIngredients();
                handlerName = ((GuiRecipe)gui).getHandlerName();
                stack.field_77994_a = ((GuiRecipe)gui).prepareFocusedRecipeResultStackSize(stack);
            }
            ItemPanels.bookmarkPanel.addOrRemoveItem(stack, handlerName, ingredients, saveIngredients, saveStackSize);
            return true;
        }
        return false;
    }
}

