package ru.vizzi.warps.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;
import ru.vizzi.warps.api.data.WarpClient;
import ru.vizzi.warps.api.data.WarpType;

@SerializerMark(
    packetClass = ru.vizzi.warps.packet.CPacketAddWarp.class
)
public class CPacketAddWarpSerializer implements ISerializer<CPacketAddWarp> {
  public void serialize(CPacketAddWarp value, ByteBuf acc) {
    serialize_CPacketAddWarp_Generic(value, acc);
  }

  public CPacketAddWarp unserialize(ByteBuf buf) {
    return unserialize_CPacketAddWarp_Generic(buf);
  }

  void serialize_WarpClient_Generic(WarpClient value, ByteBuf acc) {
    serialize_WarpClient_Concretic(value, acc);
  }

  WarpClient unserialize_WarpClient_Generic(ByteBuf buf) {
    return unserialize_WarpClient_Concretic(buf);
  }

  void serialize_WarpClient_Concretic(WarpClient value, ByteBuf acc) {
    serialize_String_Generic(value.getName(), acc);
    serialize_WarpType_Generic(value.getWarpType(), acc);
    serialize_Boolean_Generic(value.isAccess(), acc);
  }

  WarpClient unserialize_WarpClient_Concretic(ByteBuf buf) {
    WarpClient value = new WarpClient();
    value.setName(unserialize_String_Generic(buf));
    value.setWarpType(unserialize_WarpType_Generic(buf));
    value.setAccess(unserialize_Boolean_Generic(buf));
    return value;
  }

  void serialize_WarpType_Generic(WarpType value, ByteBuf acc) {
    acc.writeByte(value.ordinal());
  }

  WarpType unserialize_WarpType_Generic(ByteBuf buf) {
    return WarpType.values()[buf.readByte()];
  }

  void serialize_CPacketAddWarp_Generic(CPacketAddWarp value, ByteBuf acc) {
    serialize_CPacketAddWarp_Concretic(value, acc);
  }

  CPacketAddWarp unserialize_CPacketAddWarp_Generic(ByteBuf buf) {
    return unserialize_CPacketAddWarp_Concretic(buf);
  }

  void serialize_CPacketAddWarp_Concretic(CPacketAddWarp value, ByteBuf acc) {
    serialize_WarpClient_Generic(value.getWarpClient(), acc);
  }

  CPacketAddWarp unserialize_CPacketAddWarp_Concretic(ByteBuf buf) {
    CPacketAddWarp value = new CPacketAddWarp(unserialize_WarpClient_Generic(buf));
    return value;
  }
}
