package ru.vizzi.warps.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import ru.vizzi.warps.api.data.WarpClient;
import ru.vizzi.warps.api.data.WarpType;

@SerializerMark(
    packetClass = ru.vizzi.warps.packet.CPacketSyncAll.class
)
public class CPacketSyncAllSerializer implements ISerializer<CPacketSyncAll> {
  public void serialize(CPacketSyncAll value, ByteBuf acc) {
    serialize_CPacketSyncAll_Generic(value, acc);
  }

  public CPacketSyncAll unserialize(ByteBuf buf) {
    return unserialize_CPacketSyncAll_Generic(buf);
  }

  void serialize_ArrayList_of_WarpClient_Generic(ArrayList<WarpClient> value, ByteBuf acc) {
    acc.writeInt(value.size());
    for (WarpClient e :value) {
      serialize_WarpClient_Generic(e,acc);
    }
  }

  ArrayList<WarpClient> unserialize_ArrayList_of_WarpClient_Generic(ByteBuf buf) {
    int size = buf.readInt();
    java.util.ArrayList value = new java.util.ArrayList();
    for (int i=0;i<size;i++) {
      WarpClient e = unserialize_WarpClient_Generic(buf);
      value.add(e);
    }
    return value;
  }

  void serialize_WarpClient_Generic(WarpClient value, ByteBuf acc) {
    serialize_WarpClient_Concretic(value, acc);
  }

  WarpClient unserialize_WarpClient_Generic(ByteBuf buf) {
    return unserialize_WarpClient_Concretic(buf);
  }

  void serialize_WarpClient_Concretic(WarpClient value, ByteBuf acc) {
    serialize_String_Generic(value.getName(), acc);
    serialize_WarpType_Generic(value.getWarpType(), acc);
    serialize_Boolean_Generic(value.isAccess(), acc);
  }

  WarpClient unserialize_WarpClient_Concretic(ByteBuf buf) {
    WarpClient value = new WarpClient();
    value.setName(unserialize_String_Generic(buf));
    value.setWarpType(unserialize_WarpType_Generic(buf));
    value.setAccess(unserialize_Boolean_Generic(buf));
    return value;
  }

  void serialize_WarpType_Generic(WarpType value, ByteBuf acc) {
    acc.writeByte(value.ordinal());
  }

  WarpType unserialize_WarpType_Generic(ByteBuf buf) {
    return WarpType.values()[buf.readByte()];
  }

  void serialize_CPacketSyncAll_Generic(CPacketSyncAll value, ByteBuf acc) {
    serialize_CPacketSyncAll_Concretic(value, acc);
  }

  CPacketSyncAll unserialize_CPacketSyncAll_Generic(ByteBuf buf) {
    return unserialize_CPacketSyncAll_Concretic(buf);
  }

  void serialize_CPacketSyncAll_Concretic(CPacketSyncAll value, ByteBuf acc) {
    serialize_ArrayList_of_WarpClient_Generic(value.getWarps(), acc);
  }

  CPacketSyncAll unserialize_CPacketSyncAll_Concretic(ByteBuf buf) {
    CPacketSyncAll value = new CPacketSyncAll(unserialize_ArrayList_of_WarpClient_Generic(buf));
    return value;
  }
}
