package ru.vizzi.warps.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;
import ru.vizzi.warps.api.data.WarpType;

@SerializerMark(
    packetClass = ru.vizzi.warps.packet.CPacketUpdate.class
)
public class CPacketUpdateSerializer implements ISerializer<CPacketUpdate> {
  public void serialize(CPacketUpdate value, ByteBuf acc) {
    serialize_CPacketUpdate_Generic(value, acc);
  }

  public CPacketUpdate unserialize(ByteBuf buf) {
    return unserialize_CPacketUpdate_Generic(buf);
  }

  void serialize_WarpType_Generic(WarpType value, ByteBuf acc) {
    acc.writeByte(value.ordinal());
  }

  WarpType unserialize_WarpType_Generic(ByteBuf buf) {
    return WarpType.values()[buf.readByte()];
  }

  void serialize_CPacketUpdate_Generic(CPacketUpdate value, ByteBuf acc) {
    serialize_CPacketUpdate_Concretic(value, acc);
  }

  CPacketUpdate unserialize_CPacketUpdate_Generic(ByteBuf buf) {
    return unserialize_CPacketUpdate_Concretic(buf);
  }

  void serialize_CPacketUpdate_Concretic(CPacketUpdate value, ByteBuf acc) {
    serialize_String_Generic(value.getOldName(), acc);
    serialize_String_Generic(value.getNewName(), acc);
    serialize_WarpType_Generic(value.getNewType(), acc);
  }

  CPacketUpdate unserialize_CPacketUpdate_Concretic(ByteBuf buf) {
    CPacketUpdate value = new CPacketUpdate(unserialize_String_Generic(buf), unserialize_String_Generic(buf), unserialize_WarpType_Generic(buf));
    return value;
  }
}
