package ru.vizzi.warps.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;
import ru.vizzi.warps.api.data.WarpType;

@SerializerMark(
    packetClass = ru.vizzi.warps.packet.SPacketCreateWarp.class
)
public class SPacketCreateWarpSerializer implements ISerializer<SPacketCreateWarp> {
  public void serialize(SPacketCreateWarp value, ByteBuf acc) {
    serialize_SPacketCreateWarp_Generic(value, acc);
  }

  public SPacketCreateWarp unserialize(ByteBuf buf) {
    return unserialize_SPacketCreateWarp_Generic(buf);
  }

  void serialize_WarpType_Generic(WarpType value, ByteBuf acc) {
    acc.writeByte(value.ordinal());
  }

  WarpType unserialize_WarpType_Generic(ByteBuf buf) {
    return WarpType.values()[buf.readByte()];
  }

  void serialize_SPacketCreateWarp_Generic(SPacketCreateWarp value, ByteBuf acc) {
    serialize_SPacketCreateWarp_Concretic(value, acc);
  }

  SPacketCreateWarp unserialize_SPacketCreateWarp_Generic(ByteBuf buf) {
    return unserialize_SPacketCreateWarp_Concretic(buf);
  }

  void serialize_SPacketCreateWarp_Concretic(SPacketCreateWarp value, ByteBuf acc) {
    serialize_String_Generic(value.name, acc);
    serialize_WarpType_Generic(value.warpType, acc);
  }

  SPacketCreateWarp unserialize_SPacketCreateWarp_Concretic(ByteBuf buf) {
    SPacketCreateWarp value = new SPacketCreateWarp(unserialize_String_Generic(buf), unserialize_WarpType_Generic(buf));
    return value;
  }
}
