package ru.vizzi.warps.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;
import ru.vizzi.warps.api.data.WarpType;

@SerializerMark(
    packetClass = ru.vizzi.warps.packet.SPacketUpdateWarp.class
)
public class SPacketUpdateWarpSerializer implements ISerializer<SPacketUpdateWarp> {
  public void serialize(SPacketUpdateWarp value, ByteBuf acc) {
    serialize_SPacketUpdateWarp_Generic(value, acc);
  }

  public SPacketUpdateWarp unserialize(ByteBuf buf) {
    return unserialize_SPacketUpdateWarp_Generic(buf);
  }

  void serialize_WarpType_Generic(WarpType value, ByteBuf acc) {
    acc.writeByte(value.ordinal());
  }

  WarpType unserialize_WarpType_Generic(ByteBuf buf) {
    return WarpType.values()[buf.readByte()];
  }

  void serialize_SPacketUpdateWarp_Generic(SPacketUpdateWarp value, ByteBuf acc) {
    serialize_SPacketUpdateWarp_Concretic(value, acc);
  }

  SPacketUpdateWarp unserialize_SPacketUpdateWarp_Generic(ByteBuf buf) {
    return unserialize_SPacketUpdateWarp_Concretic(buf);
  }

  void serialize_SPacketUpdateWarp_Concretic(SPacketUpdateWarp value, ByteBuf acc) {
    serialize_String_Generic(value.getNameOld(), acc);
    serialize_String_Generic(value.getNameNew(), acc);
    serialize_WarpType_Generic(value.getType(), acc);
  }

  SPacketUpdateWarp unserialize_SPacketUpdateWarp_Concretic(ByteBuf buf) {
    SPacketUpdateWarp value = new SPacketUpdateWarp(unserialize_String_Generic(buf), unserialize_String_Generic(buf), unserialize_WarpType_Generic(buf));
    return value;
  }
}
