/*
 * Decompiled with CFR 0.152.
 */
package climateControl;

import climateControl.DimensionManager;
import climateControl.api.BiomePackageRegistry;
import climateControl.api.BiomeSettings;
import climateControl.api.CCDimensionSettings;
import climateControl.api.ClimateControlSettings;
import climateControl.api.DimensionalSettingsRegistry;
import climateControl.biomeSettings.ArsMagicaPackage;
import climateControl.biomeSettings.BopPackage;
import climateControl.biomeSettings.EBPackage;
import climateControl.biomeSettings.EBXLController;
import climateControl.biomeSettings.ExternalBiomePackage;
import climateControl.biomeSettings.GrowthcraftPackage;
import climateControl.biomeSettings.HighlandsPackage;
import climateControl.biomeSettings.ReikasPackage;
import climateControl.biomeSettings.ThaumcraftPackage;
import climateControl.biomeSettings.VampirismPackage;
import climateControl.customGenLayer.GenLayerRiverMixWrapper;
import climateControl.utils.ConfigManager;
import climateControl.utils.Named;
import climateControl.utils.PropertyManager;
import climateControl.utils.TaggedConfigManager;
import climateControl.utils.Zeno410Logger;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.event.world.WorldEvent;

@Mod(modid="climatecontrol", name="Climate Control", version="0.8.1", acceptableRemoteVersions="*")
public class ClimateControl {
    public static Logger logger = new Zeno410Logger("ClimateControl").logger();
    public static boolean testing = true;
    private Configuration config;
    private ClimateControlSettings newSettings;
    private ConfigManager<ClimateControlSettings> configManager;
    private TaggedConfigManager addonConfigManager;
    private CCDimensionSettings dimensionSettings;
    private HashMap<Integer, WorldServer> servedWorlds = new HashMap();
    private GenLayerRiverMixWrapper riverLayerWrapper = new GenLayerRiverMixWrapper(0L);
    private File configDirectory;
    private File suggestedConfigFile;
    private ExternalBiomePackage externalBiomesPackage;
    private DimensionManager dimensionManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.addonConfigManager = new TaggedConfigManager("climatecontrol.cfg", "ClimateControl");
        BiomePackageRegistry.instance = new BiomePackageRegistry(event.getSuggestedConfigurationFile().getParentFile(), this.addonConfigManager);
        this.externalBiomesPackage = new ExternalBiomePackage();
        DimensionalSettingsRegistry.instance = new DimensionalSettingsRegistry();
        this.newSettings = new ClimateControlSettings();
        this.suggestedConfigFile = event.getSuggestedConfigurationFile();
        this.config = new Configuration(this.suggestedConfigFile);
        this.config.load();
        this.setupRegistry();
        this.newSettings.readFrom(this.config);
        this.configDirectory = event.getSuggestedConfigurationFile().getParentFile();
        this.newSettings.setDefaults(this.configDirectory);
        logger.info(this.configDirectory.getAbsolutePath());
        this.dimensionSettings = new CCDimensionSettings();
        this.configManager = new ConfigManager<ClimateControlSettings>(this.config, this.newSettings, event.getSuggestedConfigurationFile());
        this.config.save();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws Exception {
        this.newSettings.setDefaults(this.configDirectory);
        this.newSettings.copyTo(this.config);
        this.config.save();
        logger.info("biome setting count: " + BiomePackageRegistry.instance.biomeSettings().size());
        for (Named<BiomeSettings> addonSetting : BiomePackageRegistry.instance.biomeSettings()) {
            this.addonConfigManager.initializeConfig(addonSetting, this.configDirectory);
        }
        this.addonConfigManager.initializeConfig(this.dimensionSettings.named(), this.configDirectory);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load event) {
        DimensionalSettingsRegistry.instance.onWorldLoad(event);
        if (this.dimensionManager == null && MinecraftServer.func_71276_C() != null) {
            this.dimensionManager = new DimensionManager(this.newSettings, this.dimensionSettings, MinecraftServer.func_71276_C());
        }
        if (this.dimensionManager != null) {
            this.dimensionManager.onWorldLoad(event.world);
        }
    }

    @SubscribeEvent
    public void onCreateSpawn(WorldEvent.CreateSpawnPosition event) {
        if (this.dimensionManager == null && MinecraftServer.func_71276_C() != null) {
            this.dimensionManager = new DimensionManager(this.newSettings, this.dimensionSettings, MinecraftServer.func_71276_C());
        }
        if (this.dimensionManager != null) {
            this.dimensionManager.onCreateSpawn(event);
        }
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload event) {
        DimensionalSettingsRegistry.instance.unloadWorld(event);
        if (event.world instanceof WorldServer) {
            this.servedWorlds.remove(event.world.field_73011_w.field_76574_g);
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        this.newSettings.setDefaults(this.configDirectory);
        this.newSettings.copyTo(this.config);
        DimensionalSettingsRegistry.instance.serverStarted(event);
        File worldSaveDirectory = null;
        String worldName = MinecraftServer.func_71276_C().func_71270_I();
        if (MinecraftServer.func_71276_C().func_71264_H()) {
            File saveDirectory = MinecraftServer.func_71276_C().func_71209_f("saves");
            worldSaveDirectory = new File(saveDirectory, worldName);
        } else {
            PropertyManager settings = new PropertyManager(MinecraftServer.func_71276_C().func_71209_f("server.properties"));
            worldName = settings.getProperty("level-name", worldName);
            worldSaveDirectory = MinecraftServer.func_71276_C().func_71209_f(worldName);
        }
        File worldConfigDirectory = new File(worldSaveDirectory, "worldSpecificConfig");
        this.addonConfigManager.updateConfig(this.dimensionSettings.named(), this.configDirectory, worldConfigDirectory);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        this.riverLayerWrapper = new GenLayerRiverMixWrapper(0L);
        this.configManager.clearWorldFile();
        for (Named<BiomeSettings> addonSetting : BiomePackageRegistry.instance.biomeSettings()) {
            this.addonConfigManager.initializeConfig(addonSetting, this.configDirectory);
        }
        this.addonConfigManager.initializeConfig(this.dimensionSettings.named(), this.configDirectory);
        DimensionalSettingsRegistry.instance.serverStopped(event);
        this.dimensionManager = null;
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        int dimension = world.field_73011_w.field_76574_g;
        if (dimension != 0) {
            return;
        }
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        File directory = event.getServer().func_71218_a(0).getChunkSaveLocation();
        directory = new File(directory, "worldSpecificConfig");
        directory.mkdir();
        if (this.dimensionManager == null && event.getServer() != null) {
            this.dimensionManager = new DimensionManager(this.newSettings, this.dimensionSettings, event.getServer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBiomeGenInit(WorldTypeEvent.InitBiomeGens event) {
        if (this.dimensionManager == null && MinecraftServer.func_71276_C() != null) {
            this.dimensionManager = new DimensionManager(this.newSettings, this.dimensionSettings, MinecraftServer.func_71276_C());
        }
        if (this.dimensionManager != null) {
            this.dimensionManager.onBiomeGenInit(event);
        }
    }

    public void earlyOnBiomeGenInit(WorldTypeEvent.InitBiomeGens event) {
        if (this.dimensionManager == null && MinecraftServer.func_71276_C() != null) {
            this.dimensionManager = new DimensionManager(this.newSettings, this.dimensionSettings, MinecraftServer.func_71276_C());
        }
        if (this.dimensionManager != null) {
            this.dimensionManager.onBiomeGenInit(event);
        }
    }

    public void setupRegistry() {
        try {
            BiomePackageRegistry.instance.register(new HighlandsPackage());
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            BiomePackageRegistry.instance.register(new BopPackage());
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            BiomePackageRegistry.instance.register(new EBPackage());
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            BiomePackageRegistry.instance.register(new ThaumcraftPackage());
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            BiomePackageRegistry.instance.register(new EBXLController());
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            BiomePackageRegistry.instance.register(new ReikasPackage());
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            BiomePackageRegistry.instance.register(new ArsMagicaPackage());
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            BiomePackageRegistry.instance.register(new GrowthcraftPackage());
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            BiomePackageRegistry.instance.register(new VampirismPackage());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void logBiomes() {
        BiomeGenBase[] biomes;
        for (BiomeGenBase biome : biomes = BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            logger.info(biome.field_76791_y + " " + biome.field_76756_M + " temp " + biome.func_150561_m().toString() + " " + biome.func_150564_a(0, 64, 0) + " rain " + biome.func_76727_i());
        }
    }
}

