/*
 * Decompiled with CFR 0.152.
 */
package climateControl;

import climateControl.ClimateControl;
import climateControl.LockGenLayer;
import climateControl.api.ClimateControlSettings;
import climateControl.customGenLayer.GenLayerBiomeByClimate;
import climateControl.customGenLayer.GenLayerBiomeByTaggedClimate;
import climateControl.customGenLayer.GenLayerRandomBiomes;
import climateControl.customGenLayer.GenLayerSmoothClimate;
import climateControl.genLayerPack.GenLayerHillsOneSix;
import climateControl.genLayerPack.GenLayerOneSixBiome;
import climateControl.genLayerPack.GenLayerPack;
import climateControl.utils.Acceptor;
import climateControl.utils.Accessor;
import climateControl.utils.ChunkLister;
import climateControl.utils.Filter;
import climateControl.utils.PlaneLocation;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraft.world.gen.layer.IntCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockGenLayers {
    private HashSet<LockGenLayer> toGenerateFor = new HashSet();
    public static final int LOCATIONS_BEFORE_RESET = 1;
    LockGenLayer biomeLock = new LockGenLayer("Biomes", this.isBiomeLayer(), Acceptor.to(this.toGenerateFor));
    LockGenLayer subBiomeLock = new LockGenLayer("SubBiomes", this.isSubBiomeLayer(), Acceptor.to(this.toGenerateFor));
    private Accessor<GenLayer, GenLayer> genLayerParent = new Accessor("field_75909_a");

    public void showGenLayers(GenLayer top) {
        LockGenLayer.showGenLayers(top);
    }

    public void lock(GenLayer top, int dimension, World world, ClimateControlSettings settings) {
        LockGenLayer climateLock;
        boolean found;
        ClimateControl.logger.info("locking generation on " + top.toString());
        if (settings.climateRingsNotSaved.value() > -1 && !settings.oneSixCompatibility.value().booleanValue() && !(found = (climateLock = new LockGenLayer("Climate", this.smoothClimateParent(), Acceptor.to(this.toGenerateFor))).lock(top, dimension, world, settings.climateRingsNotSaved.value(), false))) {
            climateLock = new LockGenLayer("Climate", this.mushroomIslandParent(), Acceptor.to(this.toGenerateFor));
            climateLock.lock(top, dimension, world, settings.climateRingsNotSaved.value(), false);
        }
        if (settings.biomeRingsNotSaved.value() > -1) {
            this.biomeLock.lock(top, dimension, world, settings.biomeRingsNotSaved.value(), false);
        }
        if (settings.subBiomeRingsNotSaved.value() > -1) {
            this.subBiomeLock.lock(top, dimension, world, settings.subBiomeRingsNotSaved.value(), false);
        }
        if (!(world instanceof WorldServer)) {
            return;
        }
        if (this.toGenerateFor.size() > 0) {
            ArrayList<PlaneLocation> existingChunks = new ChunkLister().savedChunks(this.levelSavePath((WorldServer)world));
            LockGenLayer.logger.info("chunk count" + existingChunks.size());
            boolean fixed = false;
            int sinceLastReset = 0;
            for (PlaneLocation chunkLocation : existingChunks) {
                if (++sinceLastReset > 1) {
                    IntCache.func_76446_a();
                    sinceLastReset = 0;
                }
                int[] stored = top.func_75904_a(chunkLocation.x() << 2, chunkLocation.z() << 2, 4, 4);
            }
            IntCache.func_76446_a();
        }
    }

    private String levelSavePath(WorldServer world) {
        String result = "";
        result = world.getChunkSaveLocation().getAbsolutePath();
        return result;
    }

    private Filter<GenLayer> isBiomeLayer() {
        return new Filter<GenLayer>(){

            @Override
            public boolean accepts(GenLayer tested) {
                if (tested == null) {
                    return false;
                }
                if (tested instanceof GenLayerBiome) {
                    return true;
                }
                if (tested instanceof GenLayerBiomeByClimate) {
                    return true;
                }
                if (tested instanceof GenLayerBiomeByTaggedClimate) {
                    return true;
                }
                if (tested instanceof GenLayerRandomBiomes) {
                    return true;
                }
                if (tested instanceof GenLayerOneSixBiome) {
                    return true;
                }
                if (tested.getClass().getCanonicalName().contains("BiomeLayerBiomes")) {
                    return true;
                }
                if (tested.getClass().getCanonicalName().contains("GenLayerBiomeEdgeHL")) {
                    return true;
                }
                return tested.getClass().getCanonicalName().contains("GenLayerBiomeByTaggedClimate");
            }
        };
    }

    private Filter<GenLayer> isSubBiomeLayer() {
        return new Filter<GenLayer>(){

            @Override
            public boolean accepts(GenLayer tested) {
                if (tested == null) {
                    return false;
                }
                if (tested.getClass().getCanonicalName().contains("GenLayerRareBiome")) {
                    return true;
                }
                if (tested.getClass().getCanonicalName().contains("BiomeLayerSub")) {
                    return true;
                }
                return tested instanceof GenLayerHillsOneSix;
            }
        };
    }

    private Filter<GenLayer> smoothClimateParent() {
        return new Filter<GenLayer>(){
            private GenLayer smoothClimateLayer = null;

            @Override
            public boolean accepts(GenLayer tested) {
                if (tested == null) {
                    return false;
                }
                if (tested instanceof GenLayerSmoothClimate || tested instanceof GenLayerBiomeByTaggedClimate) {
                    this.smoothClimateLayer = tested;
                    return false;
                }
                if (this.smoothClimateLayer == null) {
                    return false;
                }
                return tested.equals(LockGenLayers.this.parent(this.smoothClimateLayer));
            }
        };
    }

    private Filter<GenLayer> mushroomIslandParent() {
        return new Filter<GenLayer>(){
            private GenLayer mushroomIslandLayer = null;

            @Override
            public boolean accepts(GenLayer tested) {
                if (tested == null) {
                    return false;
                }
                if (tested.getClass().getName().contains("GenLayerAddMushroomIsland")) {
                    this.mushroomIslandLayer = tested;
                    return false;
                }
                if (this.mushroomIslandLayer == null) {
                    return false;
                }
                return tested.equals(LockGenLayers.this.parent(this.mushroomIslandLayer));
            }
        };
    }

    public GenLayer parent(GenLayer child) {
        if (child instanceof GenLayerPack) {
            return ((GenLayerPack)child).getParent();
        }
        return this.genLayerParent.get(child);
    }
}

