/*
 * Decompiled with CFR 0.152.
 */
package climateControl;

import climateControl.DimensionManager;
import climateControl.customGenLayer.GenLayerRiverMixWrapper;
import climateControl.utils.Accessor;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.symbol.symbols.SymbolBiomeControllerNative;
import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import java.util.List;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;

public class Myst10GenLayerUpdater {
    private Accessor<WorldProviderMyst, AgeController> ageControllerAccess = new Accessor("controller");
    private Accessor<AgeController, IBiomeController> biomeControllerAccess = new Accessor("biomeController");
    private Accessor<SymbolBiomeControllerNative, GenLayer> genLayerAccess = new Accessor("genBiomes");
    private Accessor<SymbolBiomeControllerNative, GenLayer> biomeIndexAccess = new Accessor("biomeIndexLayer");

    public void update(GenLayerRiverMixWrapper riverMix, WorldProvider provider) {
        DimensionManager.logger.info(" provider " + provider.toString());
        if (provider instanceof WorldProviderMyst) {
            WorldProviderMyst mystProvider = (WorldProviderMyst)provider;
            AgeController controller = this.ageControllerAccess.get(mystProvider);
            BiomeController newController = new BiomeController(provider.field_76578_c);
            IBiomeController biomeController = this.biomeControllerAccess.get(controller);
            this.biomeControllerAccess.setField(controller, newController);
            if (biomeController instanceof SymbolBiomeControllerNative) {
                DimensionManager.logger.info(" SymbolbiomeController " + biomeController.toString());
                SymbolBiomeControllerNative standardController = (SymbolBiomeControllerNative)biomeController;
                this.genLayerAccess.setField(standardController, (GenLayer)riverMix);
                this.biomeIndexAccess.setField(standardController, riverMix.voronoi());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BiomeController
    implements IBiomeController {
        private WorldChunkManager manager;

        protected BiomeController(WorldChunkManager manager) {
            this.manager = manager;
        }

        public List<BiomeGenBase> getValidSpawnBiomes() {
            return this.manager.func_76932_a();
        }

        public BiomeGenBase getBiomeAtCoords(int par1, int par2) {
            return this.manager.func_76935_a(par1, par2);
        }

        public float[] getRainfallField(float[] afloat, int x, int z, int width, int length) {
            return this.manager.func_76936_a(afloat, x, z, width, length);
        }

        public BiomeGenBase[] getBiomesFromGenerationField(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
            return this.manager.func_76937_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5);
        }

        public BiomeGenBase[] getBiomesAtCoords(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5, boolean par6) {
            return this.manager.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, par6);
        }

        public void cleanupCache() {
            this.manager.func_76938_b();
        }

        public BiomeGenBase[] getBiomesForGeneration(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
            return this.manager.func_76937_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5);
        }
    }
}

