/*
 * Decompiled with CFR 0.152.
 */
package climateControl;

import climateControl.Default;
import climateControl.DimensionalDataStorage;
import climateControl.utils.Acceptor;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverworldDataStorage<DataType extends WorldSavedData> {
    DataType dataToStore;
    Default<DataType> defaultData;
    Acceptor<DataType> target;
    String baseFileName;

    public OverworldDataStorage(String baseFileName, DataType dataToStore, Default<DataType> defaultData, Acceptor<DataType> target) {
        this.baseFileName = baseFileName;
        this.dataToStore = dataToStore;
        this.defaultData = defaultData;
        this.target = target;
        baseFileName.toString();
        dataToStore.toString();
        defaultData.toString();
    }

    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        int dimension = world.field_73011_w.field_76574_g;
        if (dimension != 0) {
            return;
        }
        DimensionalDataStorage<WorldSavedData> storage = new DimensionalDataStorage<WorldSavedData>(world.func_72860_G(), this.baseFileName, (WorldSavedData)this.dataToStore);
        WorldSavedData data = storage.load(0, (WorldSavedData)this.defaultData.item());
        this.target.accept(data);
    }

    public void onWorldSave(WorldEvent.Save event, DataType toStore) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        int dimension = world.field_73011_w.field_76574_g;
        if (dimension != 0) {
            return;
        }
        this.dataToStore = toStore;
        DimensionalDataStorage<DataType> storage = new DimensionalDataStorage<DataType>(world.func_72860_G(), this.baseFileName, this.dataToStore);
        storage.save(this.dataToStore, 0);
    }
}

