/*
 * Decompiled with CFR 0.152.
 */
package climateControl;

import climateControl.api.BiomeRandomizer;
import climateControl.api.Climate;
import climateControl.api.ClimateControlSettings;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.world.biome.BiomeGenBase;

public class SettingsTester {
    public void test(ClimateControlSettings tested) {
        if (tested.biomeSettings().size() < 2) {
            ArrayList<String> messages = new ArrayList<String>();
            messages.add("There are no land biomes groups");
            messages.add("Vanilla biomes are off but no mod biomes are on");
            messages.add("Running will almost certainly crash the system");
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft != null) {
                for (int i = 1; i < 4; ++i) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(SettingsTester.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else {
                throw new RuntimeException("Climate Control: Vanilla biomes are inactive but no mod biomes are on");
            }
        }
        if (!tested.randomBiomes.value().booleanValue()) {
            int i;
            Climate[] climates = new Climate[5];
            climates[1] = Climate.HOT;
            climates[2] = Climate.WARM;
            climates[3] = Climate.COOL;
            climates[4] = Climate.SNOWY;
            boolean[] active = new boolean[5];
            if (tested.hotIncidence.value() < 0) {
                throw new RuntimeException("Climate Incidences must all be positive");
            }
            if (tested.warmIncidence.value() < 0) {
                throw new RuntimeException("Climate Incidences must all be positive");
            }
            if (tested.coolIncidence.value() < 0) {
                throw new RuntimeException("Climate Incidences must all be positive");
            }
            if (tested.snowyIncidence.value() < 0) {
                throw new RuntimeException("Climate Incidences must all be positive");
            }
            active[1] = tested.hotIncidence.value() > 0;
            active[2] = tested.warmIncidence.value() > 0;
            active[3] = tested.coolIncidence.value() > 0;
            active[4] = tested.snowyIncidence.value() > 0;
            int highestActive = -1;
            for (i = 1; i < 5; ++i) {
                if (!active[i]) continue;
                highestActive = i;
            }
            if (highestActive == -1) {
                throw new RuntimeException("Climate Control: All Climate incidences set to 0. At least one much be positive");
            }
            for (i = 0; i < highestActive; ++i) {
                if (!active[i]) continue;
                for (int j = i + 1; j < highestActive; ++j) {
                    active[j] = true;
                }
            }
            BiomeRandomizer.PickByClimate testClimatePicker = new BiomeRandomizer(tested.biomeSettings()).pickByClimate();
            String activeWithoutBiomes = "";
            if (!testClimatePicker.hasBiomes(0)) {
                activeWithoutBiomes = activeWithoutBiomes.concat(Climate.OCEAN.name + " ");
            }
            if (!testClimatePicker.hasBiomes(BiomeGenBase.field_150575_M.field_76756_M)) {
                activeWithoutBiomes = activeWithoutBiomes.concat(Climate.DEEP_OCEAN.name + " ");
            }
            for (int i2 = 1; i2 < 5; ++i2) {
                if (!active[i2] || testClimatePicker.hasBiomes(i2)) continue;
                activeWithoutBiomes = activeWithoutBiomes.concat(climates[i2].name + " ");
            }
            if (activeWithoutBiomes.length() > 0) {
                throw new RuntimeException("Climate Control: No Biomes present for climates " + activeWithoutBiomes);
            }
        }
    }
}

