/*
 * Decompiled with CFR 0.152.
 */
package climateControl.api;

import climateControl.api.BiomePackage;
import climateControl.api.BiomeSettings;
import climateControl.utils.Named;
import climateControl.utils.TaggedConfigManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiomePackageRegistry {
    public static BiomePackageRegistry instance;
    private HashMap<String, BiomePackage> namedPackages = new HashMap();
    private ArrayList<BiomePackage> orderedPackages = new ArrayList();
    private ArrayList<Named<BiomeSettings>> settings = new ArrayList();
    private final File configDirectory;
    private final TaggedConfigManager taggedConfigManager;

    public BiomePackageRegistry(File configDirectory, TaggedConfigManager taggedConfigManager) {
        this.configDirectory = configDirectory;
        this.taggedConfigManager = taggedConfigManager;
    }

    public final void register(BiomePackage biomePackage) {
        if (this.namedPackages.containsKey(new String(biomePackage.configFileName()))) {
            return;
        }
        this.namedPackages.put(biomePackage.configFileName(), biomePackage);
        this.orderedPackages.add(biomePackage);
        Named<BiomeSettings> namedSettings = biomePackage.namedBiomeSetting();
        this.taggedConfigManager.initializeConfig(namedSettings, this.configDirectory);
        this.settings.add(namedSettings);
    }

    public final Collection<Named<BiomeSettings>> biomeSettings() {
        return this.settings;
    }

    public final Collection<Named<BiomeSettings>> freshBiomeSettings() {
        ArrayList<Named<BiomeSettings>> result = new ArrayList<Named<BiomeSettings>>();
        for (BiomePackage biomePackage : this.orderedPackages) {
            result.add(biomePackage.namedBiomeSetting());
        }
        return result;
    }

    public static class BiomePackageAlreadyRegistered
    extends RuntimeException {
        private final String name;

        public BiomePackageAlreadyRegistered(String name) {
            super("config file name " + name + " is already registered with Climate Control");
            this.name = name;
        }
    }
}

