/*
 * Decompiled with CFR 0.152.
 */
package climateControl.api;

import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import climateControl.api.ClimateDistribution;
import climateControl.api.IncidenceModifier;
import climateControl.utils.IntRandomizer;
import climateControl.utils.Numbered;
import climateControl.utils.Zeno410Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import net.minecraft.world.biome.BiomeGenBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiomeRandomizer {
    public static Logger logger = new Zeno410Logger("BiomeRandomizer").logger();
    public BiomeList global;
    private BiomeList hot;
    private BiomeList warm;
    private BiomeList cool;
    private BiomeList snowy;
    private BiomeList ocean;
    private BiomeList deepOcean;

    private BiomeRandomizer() {
    }

    public BiomeRandomizer(Collection<BiomeSettings> settings) {
        this.global = new BiomeList();
        this.hot = new BiomeList();
        this.warm = new BiomeList();
        this.cool = new BiomeList();
        this.snowy = new BiomeList();
        this.ocean = new BiomeList();
        this.deepOcean = new BiomeList();
        for (BiomeSettings setting : settings) {
            if (!setting.biomesAreActive()) continue;
            for (ClimateDistribution.Incidence incidence : setting.incidences()) {
                this.add(incidence);
            }
        }
    }

    private BiomeList randomizer(Climate climate) {
        if (climate == Climate.DEEP_OCEAN) {
            return this.deepOcean;
        }
        if (climate == Climate.SNOWY) {
            return this.snowy;
        }
        if (climate == Climate.COOL) {
            return this.cool;
        }
        if (climate == Climate.WARM) {
            return this.warm;
        }
        if (climate == Climate.HOT) {
            return this.hot;
        }
        if (climate == Climate.OCEAN) {
            return this.ocean;
        }
        throw new RuntimeException("No such climate");
    }

    public int size() {
        return this.hot.biomes.length + this.ocean.biomes.length + this.deepOcean.biomes.length + this.snowy.biomes.length + this.cool.biomes.length + this.warm.biomes.length;
    }

    private void add(ClimateDistribution.Incidence incidence) {
        if (incidence.climate != Climate.DEEP_OCEAN && incidence.climate != Climate.OCEAN) {
            this.global.append(incidence.incidence, BiomeGenBase.func_150565_n()[incidence.biome]);
        }
        this.randomizer(incidence.climate).append(incidence.incidence, BiomeGenBase.func_150565_n()[incidence.biome]);
    }

    public PickByClimate pickByClimate() {
        return new PickByClimate();
    }

    private BiomeRandomizer modifiedBy(IncidenceModifier modifier) {
        if (this.ocean.biomes.length < 1) {
            throw new RuntimeException();
        }
        BiomeRandomizer result = new BiomeRandomizer();
        result.cool = this.cool.modifiedSubRandomizer(modifier);
        result.deepOcean = this.deepOcean.modifiedSubRandomizer(modifier);
        result.hot = this.hot.modifiedSubRandomizer(modifier);
        result.ocean = this.ocean.modifiedSubRandomizer(modifier);
        result.snowy = this.snowy.modifiedSubRandomizer(modifier);
        result.warm = this.warm.modifiedSubRandomizer(modifier);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BiomeList {
        private BiomeGenBase[] biomes = new BiomeGenBase[0];
        private int nextIndex = 0;

        private void append(int count, BiomeGenBase biome) {
            int lastIndex = this.nextIndex;
            BiomeGenBase[] newArray = new BiomeGenBase[this.nextIndex + count];
            for (int i = 0; i < lastIndex; ++i) {
                newArray[i] = this.biomes[i];
            }
            this.biomes = newArray;
            this.nextIndex = lastIndex;
            while (this.nextIndex < lastIndex + count) {
                this.biomes[this.nextIndex] = biome;
                ++this.nextIndex;
            }
        }

        public BiomeGenBase choose(IntRandomizer source) {
            return this.biomes[source.nextInt(this.biomes.length)];
        }

        private BiomeList modifiedSubRandomizer(IncidenceModifier modifier) {
            BiomeList result = new BiomeList();
            for (Numbered<BiomeGenBase> oldIncidence : this.incidences()) {
                int newIncidence = modifier.modifiedIncidence(oldIncidence);
                logger.info(oldIncidence.item().field_76791_y + " " + oldIncidence.count() + " to " + newIncidence);
                if (newIncidence <= 0) continue;
                result.append(newIncidence, oldIncidence.item());
            }
            return result;
        }

        private ArrayList<Numbered<BiomeGenBase>> incidences() {
            ArrayList<Numbered<BiomeGenBase>> result = new ArrayList<Numbered<BiomeGenBase>>();
            BiomeGenBase current = null;
            int occurances = 0;
            for (BiomeGenBase biome : this.biomes) {
                if (biome == current) {
                    ++occurances;
                    continue;
                }
                if (occurances > 0) {
                    result.add(Numbered.from(occurances, current));
                    current = biome;
                    occurances = 1;
                }
                current = biome;
            }
            result.add(Numbered.from(occurances, current));
            logger.info("" + this.biomes.length + " biomes " + result.size() + " incidencese ");
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PickByClimate {
        public int biome(int climate, IntRandomizer source) {
            if (climate == 0) {
                return ((BiomeRandomizer)BiomeRandomizer.this).ocean.choose((IntRandomizer)source).field_76756_M;
            }
            if (climate == 1) {
                return ((BiomeRandomizer)BiomeRandomizer.this).hot.choose((IntRandomizer)source).field_76756_M;
            }
            if (climate == 2) {
                return ((BiomeRandomizer)BiomeRandomizer.this).warm.choose((IntRandomizer)source).field_76756_M;
            }
            if (climate == 3) {
                return ((BiomeRandomizer)BiomeRandomizer.this).cool.choose((IntRandomizer)source).field_76756_M;
            }
            if (climate == 4) {
                return ((BiomeRandomizer)BiomeRandomizer.this).snowy.choose((IntRandomizer)source).field_76756_M;
            }
            if (climate == BiomeGenBase.field_150575_M.field_76756_M) {
                return ((BiomeRandomizer)BiomeRandomizer.this).deepOcean.choose((IntRandomizer)source).field_76756_M;
            }
            if (climate == BiomeGenBase.field_76789_p.field_76756_M) {
                return climate;
            }
            return 0;
        }

        public boolean hasBiomes(int climate) {
            if (climate == 0) {
                return BiomeRandomizer.this.ocean.biomes.length > 0;
            }
            if (climate == 1) {
                return BiomeRandomizer.this.hot.biomes.length > 0;
            }
            if (climate == 2) {
                return BiomeRandomizer.this.warm.biomes.length > 0;
            }
            if (climate == 3) {
                return BiomeRandomizer.this.cool.biomes.length > 0;
            }
            if (climate == 4) {
                return BiomeRandomizer.this.snowy.biomes.length > 0;
            }
            if (climate == BiomeGenBase.field_150575_M.field_76756_M) {
                return BiomeRandomizer.this.deepOcean.biomes.length > 0;
            }
            return false;
        }

        public HashMap<IncidenceModifier, PickByClimate> modifiedDistributions(ArrayList<IncidenceModifier> comprehensiveModifiers) {
            HashMap<IncidenceModifier, PickByClimate> result = new HashMap<IncidenceModifier, PickByClimate>();
            ArrayList<BiomeRandomizer> randomizers = new ArrayList<BiomeRandomizer>();
            for (IncidenceModifier modifier : comprehensiveModifiers) {
                logger.info(modifier.toString());
                BiomeRandomizer randomizer = BiomeRandomizer.this.modifiedBy(modifier);
                result.put(modifier, randomizer.pickByClimate());
                randomizers.add(randomizer);
            }
            for (BiomeRandomizer randomizer : randomizers) {
                if (randomizer.ocean.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.ocean = BiomeRandomizer.this.ocean;
                    }
                }
                if (randomizer.cool.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.cool = BiomeRandomizer.this.cool;
                    }
                }
                if (randomizer.deepOcean.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.deepOcean = BiomeRandomizer.this.deepOcean;
                    }
                }
                if (randomizer.hot.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.hot = BiomeRandomizer.this.hot;
                    }
                }
                if (randomizer.snowy.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.snowy = BiomeRandomizer.this.snowy;
                    }
                }
                if (randomizer.warm.biomes.length != 0) continue;
                for (BiomeRandomizer changed : randomizers) {
                    changed.warm = BiomeRandomizer.this.warm;
                }
            }
            return result;
        }
    }
}

