/*
 * Decompiled with CFR 0.152.
 */
package climateControl.api;

import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateDistribution;
import climateControl.biomeSettings.BiomeReplacer;
import climateControl.generator.BiomeSwapper;
import climateControl.generator.SubBiomeChooser;
import climateControl.utils.Mutable;
import climateControl.utils.Settings;
import climateControl.utils.Zeno410Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BiomeSettings
extends Settings {
    public static final Logger logger = new Zeno410Logger("BiomeSettings").logger();
    private final ArrayList<Element> elements = new ArrayList();
    private final ArrayList<ID> ids = new ArrayList();
    private final Settings.Category idCategory;
    private final Settings.Category incidenceCategory;
    private final Settings.Category villagesCategory;
    private final Settings.Category climateCategory;
    public final Settings.Category climateControlCategory = this.category("Assorted Parameters");

    public BiomeSettings(String categoryName) {
        this.idCategory = this.category(categoryName + "IDs");
        this.incidenceCategory = this.category(categoryName + "Incidences");
        this.villagesCategory = this.category(categoryName + "Villages");
        this.climateCategory = this.category(categoryName + "Climates", "Climate Types are: SNOWY,COOL,WARM,HOT,OCEAN,DEEP_OCEANMEDIUM,PLAINS,LAND.  MEDIUM is COOL and WARM, PLAINS is COOL and WARM and HOT, LAND is all four land");
    }

    public ArrayList<Element> elements() {
        return this.elements;
    }

    protected ID M(ID original, String name) {
        ID result = new ID(name, original.biomeID().value() + 128);
        original.setMBiome(result);
        return result;
    }

    protected ID M(ID original) {
        return this.M(original, original.name + " M");
    }

    public ArrayList<ClimateDistribution.Incidence> incidences() {
        ArrayList<ClimateDistribution.Incidence> result = new ArrayList<ClimateDistribution.Incidence>();
        for (Element element : this.elements) {
            if (!element.active()) continue;
            try {
                result.addAll(element.distribution().incidences(element));
            }
            catch (NoTempSetting e) {}
        }
        return result;
    }

    private ClimateDistribution climateDistribution(Element element) {
        return element.distribution();
    }

    public void update(SubBiomeChooser subBiomeChooser) {
        for (ID id : this.ids) {
            if (!id.active()) continue;
            subBiomeChooser.set(id.biomeID().value(), id.subBiomeChooser);
        }
    }

    public void updateMBiomes(BiomeSwapper mBiomes) {
        for (ID id : this.ids) {
            if (id.MBiome == null) continue;
            mBiomes.set(id.biomeID().value(), id.MBiome.biomeID().value());
        }
    }

    protected ID externalBiome(String name, int biomeID) {
        return new ID(name, new Mutable.Concrete<Integer>(biomeID));
    }

    private void stripCategory(Settings.Category category, Configuration config) {
        ConfigCategory toRemove = config.getCategory(category.name.toLowerCase());
        config.removeCategory(toRemove);
        if (config.hasCategory(category.name.toLowerCase())) {
            throw new RuntimeException();
        }
    }

    private void stripFrom(Configuration config) {
        this.stripCategory(this.idCategory, config);
        this.stripCategory(this.incidenceCategory, config);
        this.stripCategory(this.villagesCategory, config);
        this.stripCategory(this.climateControlCategory, config);
        this.stripCategory(this.climateCategory, config);
    }

    public void stripIDsFrom(Configuration config) {
        this.stripCategory(this.idCategory, config);
    }

    @Override
    public void readForeignConfigs(File generalConfigDirectory) {
        this.setNativeBiomeIDs(generalConfigDirectory);
    }

    public abstract void setRules(ClimateControlRules var1);

    public abstract void setNativeBiomeIDs(File var1);

    public abstract void onNewWorld();

    public String startBiomesName(String configName) {
        return configName + "InNewDimensons";
    }

    public void setVillages(ClimateControlRules rules) {
        for (ID id : this.ids) {
            if (!((Boolean)id.hasVillages.value()).booleanValue()) continue;
            rules.allowVillages((Integer)id.biomeID.value());
        }
    }

    public final boolean equalsByIdentity(BiomeSettings compared) {
        return super.equals(compared);
    }

    public abstract boolean biomesAreActive();

    public void report() {
    }

    public void nameDefaultClimates() {
        for (ID element : this.ids) {
            int biomeID;
            if (!element.climate.value().equalsIgnoreCase("DEFAULT") || (biomeID = element.biomeID().value().intValue()) < 0 || biomeID > 255) continue;
            BiomeGenBase biome = BiomeGenBase.func_150565_n()[biomeID];
            try {
                ClimateDistribution distribution = element.defaultDistribution();
                element.setDistribution(distribution);
            }
            catch (NoTempSetting e) {}
        }
    }

    public class NoTempSetting
    extends RuntimeException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Element
    extends ID {
        private Mutable<Integer> biomeIncidence;

        public Element(String name, int ID2, int incidence, boolean hasVillages, String climate) {
            super(name, ID2, hasVillages, climate);
            this.biomeIncidence = BiomeSettings.this.incidenceCategory.intSetting(name + " Incidence", incidence);
            this.biomeIncidence.set(incidence);
            BiomeSettings.this.elements.add(this);
        }

        public Element(String name, int ID2, int incidence, boolean hasVillages) {
            this(name, ID2, incidence, hasVillages, "DEFAULT");
        }

        public Element(String name, int ID2, int incidence, String climate) {
            this(name, ID2, incidence, false, climate);
        }

        public Element(String name, int ID2, int incidence) {
            this(name, ID2, incidence, false);
        }

        public Element(String name, int ID2) {
            this(name, ID2, 10, false);
        }

        public Element(String name, int ID2, String climate) {
            this(name, ID2, 10, false, climate);
        }

        public Element(String name, int ID2, boolean hasVillages) {
            this(name, ID2, 10, false);
        }

        public Element(String name, int ID2, boolean hasVillages, String climate) {
            this(name, ID2, 10, false, climate);
        }

        public Mutable<Integer> biomeIncidences() {
            return this.biomeIncidence;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ID {
        private Mutable<Integer> biomeID;
        private Mutable<Boolean> hasVillages;
        protected final Mutable<String> climate;
        public final String name;
        private ID MBiome = null;
        private BiomeReplacer subBiomeChooser = BiomeReplacer.noChange;
        private ClimateDistribution distribution;

        public ID(String name, int ID2, boolean hasVillages, String climate) {
            this(name, biomeSettings.idCategory.intSetting(name + " ID", ID2), hasVillages, climate);
        }

        public ID(String name, int ID2, boolean hasVillages) {
            this(name, ID2, hasVillages, "DEFAULT");
        }

        public ID(String name, int ID2) {
            this(name, ID2, false);
        }

        public ID(String name, Mutable<Integer> ID2, boolean hasVillages, String climate) {
            this.name = name;
            this.biomeID = ID2;
            this.hasVillages = BiomeSettings.this.villagesCategory.booleanSetting(name + " hasVillages", hasVillages);
            this.climate = BiomeSettings.this.climateCategory.stringSetting(name + " climate", climate);
            BiomeSettings.this.ids.add(this);
            this.distribution = null;
        }

        public ID(String name, Mutable<Integer> ID2) {
            this(name, ID2, false, "DEFAULT");
        }

        public Mutable<Integer> biomeID() {
            return this.biomeID;
        }

        public void setMBiome(ID MBiome) {
            if (this.MBiome != null) {
                throw new RuntimeException("accidental reset of M Biome for " + this.name);
            }
            this.MBiome = MBiome;
        }

        public void setIDFrom(BiomeGenBase biome) {
            try {
                if (BiomeGenBase.func_150565_n()[biome.field_76756_M].equals(biome)) {
                    this.biomeID().set(biome.field_76756_M);
                } else {
                    this.biomeID().set(-1);
                }
            }
            catch (NullPointerException e) {
                this.biomeID().set(-1);
            }
        }

        public boolean active() {
            if (this.biomeID.value() < 0) {
                return false;
            }
            if (BiomeGenBase.func_150565_n()[this.biomeID.value()] == null) {
                return false;
            }
            int oldID = BiomeGenBase.func_150565_n()[this.biomeID.value().intValue()].field_76756_M;
            if (oldID != this.biomeID.value()) {
                String text = " Attempted to use biome " + this.name + " at ID + " + this.biomeID.value() + " but that biome is assigned to " + oldID;
                throw new RuntimeException(text);
            }
            return true;
        }

        public void setSubBiomeChooser(BiomeReplacer subBiomeChooser) {
            this.subBiomeChooser = subBiomeChooser;
        }

        public void setSubBiome(ID subBiome) {
            this.subBiomeChooser = new BiomeReplacer.Fixed(subBiome.biomeID.value());
        }

        private ClimateDistribution defaultDistribution() {
            BiomeGenBase.TempCategory temp = null;
            try {
                temp = BiomeGenBase.func_150565_n()[this.biomeID().value()].func_150561_m();
                if (temp == BiomeGenBase.TempCategory.COLD) {
                    return ClimateDistribution.SNOWY;
                }
                if (temp == BiomeGenBase.TempCategory.MEDIUM) {
                    return ClimateDistribution.MEDIUM;
                }
                if (temp == BiomeGenBase.TempCategory.WARM) {
                    return ClimateDistribution.HOT;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NoTempSetting();
        }

        public void setDistribution(ClimateDistribution newDistribution) {
            this.distribution = newDistribution;
            this.climate.set(newDistribution.name());
        }

        public ClimateDistribution distribution() {
            if (this.distribution != null) {
                return this.distribution;
            }
            return this.configDistribution();
        }

        public ClimateDistribution configDistribution() {
            if (this.climate.value().equalsIgnoreCase("DEFAULT")) {
                return this.defaultDistribution();
            }
            if (this.climate.value().equalsIgnoreCase("")) {
                return this.defaultDistribution();
            }
            for (ClimateDistribution testedDistribution : ClimateDistribution.list) {
                if (!this.climate.value().equalsIgnoreCase(testedDistribution.name())) continue;
                return testedDistribution;
            }
            throw new RuntimeException("Climate " + this.climate.value() + " not recognized");
        }
    }
}

