/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import am2.api.ArsMagicaApi;
import climateControl.api.BiomePackage;
import climateControl.api.BiomeSettings;
import climateControl.api.ClimateControlRules;
import climateControl.utils.Mutable;
import climateControl.utils.Settings;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ArsMagicaPackage
extends BiomePackage {
    public ArsMagicaPackage() {
        super("ArsMagicaInCC.cfg");
        Class<ArsMagicaApi> apiClass = ArsMagicaApi.class;
    }

    public BiomeSettings freshBiomeSetting() {
        return new ArsMagicaBiomeSettings();
    }

    public static class ArsMagicaBiomeSettings
    extends BiomeSettings {
        public static final String biomeCategory = "ArsMagicaBiome";
        public static final String arsMagicaCategory = "ArsMagicaSettings";
        public final Settings.Category arsMagicaSettings = new Settings.Category(this, "ArsMagicaSettings");
        public final BiomeSettings.Element witchwoodForest = (BiomeSettings)this.new BiomeSettings.Element("Witchwood Forest", 100, "LAND");
        static final String biomesOnName = "ArsMagicaBiomesOn";
        public final Mutable<Boolean> biomesFromConfig = this.climateControlCategory.booleanSetting("ArsMagicaBiomesOn", "", false);
        static final String configName = "ArsMagica";
        public final Mutable<Boolean> biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName("ArsMagica"), "Use biome in new worlds and dimensions", true);

        public ArsMagicaBiomeSettings() {
            super(biomeCategory);
        }

        public void setRules(ClimateControlRules rules) {
        }

        public void setNativeBiomeIDs(File configDirectory) {
            NativeArsMagicaSettings result = new NativeArsMagicaSettings();
            File arsMagicaDirectory = new File(configDirectory, "AM2");
            File configFile = new File(arsMagicaDirectory, "AM2.cfg");
            result.readFrom(new Configuration(configFile));
            this.witchwoodForest.biomeID().set(result.witchwoodForestID.value());
        }

        public void onNewWorld() {
            this.biomesFromConfig.set(this.biomesInNewWorlds);
        }

        public boolean biomesAreActive() {
            return this.biomesFromConfig.value();
        }

        private class NativeArsMagicaSettings
        extends Settings {
            public static final String biomeIDName = "general";
            public final Settings.Category biomeIDs = new Settings.Category(this, "general");
            Mutable<Integer> witchwoodForestID = this.biomeIDs.intSetting("WitchwoodForestBiomeID", 100);

            private NativeArsMagicaSettings() {
            }
        }
    }
}

