/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateDistribution;
import climateControl.biomeSettings.BiomeReplacer;
import climateControl.generator.SubBiomeChooser;
import climateControl.utils.Mutable;
import climateControl.utils.Settings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBBiomeSettings
extends BiomeSettings {
    public static final String biomeCategory = "EBBiomes";
    public static final String EBCategory = "EBSettings";
    public final Settings.Category EBSettings = new Settings.Category(this, "EBSettings");
    NativeSettings settings = new NativeSettings();
    public final BiomeSettings.Element AlpineMountains;
    public final BiomeSettings.Element AlpineMountainsEdge;
    public final BiomeSettings.Element AlpineMountainsM;
    public final BiomeSettings.Element AlpineTundra;
    public final BiomeSettings.Element AspenForest;
    public final BiomeSettings.Element AspenHills;
    public final BiomeSettings.Element Badlands;
    public final BiomeSettings.Element Basin;
    public final BiomeSettings.Element BlossomHills;
    public final BiomeSettings.Element BlossomWoods;
    public final BiomeSettings.Element BorealArchipelago;
    public final BiomeSettings.Element BorealForest;
    public final BiomeSettings.Element BorealPlateau;
    public final BiomeSettings.Element BorealPlateauM;
    public final BiomeSettings.Element Carr;
    public final BiomeSettings.Element ClayHills;
    public final BiomeSettings.Element Clearing;
    public final BiomeSettings.Element ColdBorealForest;
    public final BiomeSettings.Element ColdCypressForest;
    public final BiomeSettings.Element ColdFirForest;
    public final BiomeSettings.Element ColdPineForest;
    public final BiomeSettings.Element CreekBed;
    public final BiomeSettings.Element CypressForest;
    public final BiomeSettings.Element DesertArchipelago;
    public final BiomeSettings.Element EphemeralLake;
    public final BiomeSettings.Element EphemeralLakeEdge;
    public final BiomeSettings.Element Fens;
    public final BiomeSettings.Element FirForest;
    public final BiomeSettings.Element FloweryArchipelago;
    public final BiomeSettings.Element ForestedArchipelago;
    public final BiomeSettings.Element ForestedMountains;
    public final BiomeSettings.Element ForestedValley;
    public final BiomeSettings.Element FrozenArchipelago;
    public final BiomeSettings.Element Glacier;
    public final BiomeSettings.Element GrassyArchipelago;
    public final BiomeSettings.Element IceSheet;
    public final BiomeSettings.Element Kakadu;
    public final BiomeSettings.Element Lake;
    public final BiomeSettings.Element LowHills;
    public final BiomeSettings.Element Mangroves;
    public final BiomeSettings.Element Marsh;
    public final BiomeSettings.Element Meadow;
    public final BiomeSettings.Element MeadowM;
    public final BiomeSettings.Element MountainousArchipelago;
    public final BiomeSettings.Element Mountains;
    public final BiomeSettings.Element MountainsEdge;
    public final BiomeSettings.Element OakForest;
    public final BiomeSettings.Element Oasis;
    public final BiomeSettings.Element PineForest;
    public final BiomeSettings.Element PineForestArchipelago;
    public final BiomeSettings.Element Plateau;
    public final BiomeSettings.Element PolarDesert;
    public final BiomeSettings.Element Prairie;
    public final BiomeSettings.Element Rainforest;
    public final BiomeSettings.Element RainforestValley;
    public final BiomeSettings.Element RedDesert;
    public final BiomeSettings.Element RiparianZone;
    public final BiomeSettings.Element RockyDesert;
    public final BiomeSettings.Element RockyHills;
    public final BiomeSettings.Element RoofedShrublands;
    public final BiomeSettings.Element Sahara;
    public final BiomeSettings.Element SandstoneCanyon;
    public final BiomeSettings.Element SandstoneCanyons;
    public final BiomeSettings.Element SandstoneRanges;
    public final BiomeSettings.Element SandstoneRangesM;
    public final BiomeSettings.Element Scree;
    public final BiomeSettings.Element Scrub;
    public final BiomeSettings.Element Shield;
    public final BiomeSettings.Element Shrublands;
    public final BiomeSettings.Element SilverPineForest;
    public final BiomeSettings.Element SilverPineHills;
    public final BiomeSettings.Element SnowyDesert;
    public final BiomeSettings.Element SnowyPlateau;
    public final BiomeSettings.Element SnowyRanges;
    public final BiomeSettings.Element SnowyWastelands;
    public final BiomeSettings.Element Steppe;
    public final BiomeSettings.Element StoneCanyon;
    public final BiomeSettings.Element StoneCanyons;
    public final BiomeSettings.Element TropicalArchipelago;
    public final BiomeSettings.Element Tundra;
    public final BiomeSettings.Element Volcano;
    public final BiomeSettings.Element VolcanoM;
    public final BiomeSettings.Element Wastelands;
    public final BiomeSettings.Element WoodlandField;
    public final BiomeSettings.Element WoodlandHills;
    public final BiomeSettings.Element WoodlandLake;
    public final BiomeSettings.Element WoodlandLakeEdge;
    public final BiomeSettings.Element Woodlands;
    public final BiomeSettings.Element XericSavannah;
    public final BiomeSettings.Element XericShrubland;
    private HashMap<BiomeSettings.ID, BiomeReplacer.Variable> subBiomeSets;
    static final String biomesOnName = "EBBiomesOn";
    public final Mutable<Boolean> biomesFromConfig;
    static final String configName = "EB";
    public final Mutable<Boolean> biomesInNewWorlds;

    public EBBiomeSettings() {
        super(biomeCategory);
        this.AlpineMountains = (BiomeSettings)this.new BiomeSettings.Element("Alpine Mountains", 52, 10, Climate.SNOWY.name);
        this.AlpineMountainsEdge = (BiomeSettings)this.new BiomeSettings.Element("Alpine Mountains Edge", 86, 0, Climate.SNOWY.name);
        this.AlpineMountainsM = (BiomeSettings)this.new BiomeSettings.Element("Alpine Mountains M", 180, 0, Climate.SNOWY.name);
        this.AlpineTundra = (BiomeSettings)this.new BiomeSettings.Element("Alpine Tundra", 103, 10, Climate.SNOWY.name);
        this.AspenForest = (BiomeSettings)this.new BiomeSettings.Element("Aspen Forest", 97, 10, Climate.COOL.name);
        this.AspenHills = (BiomeSettings)this.new BiomeSettings.Element("Aspen Hills", 98, 0, Climate.COOL.name);
        this.Badlands = (BiomeSettings)this.new BiomeSettings.Element("Badlands", 71, 10, Climate.WARM.name);
        this.Basin = (BiomeSettings)this.new BiomeSettings.Element("Basin", 99, 0, Climate.COOL.name);
        this.BlossomHills = (BiomeSettings)this.new BiomeSettings.Element("Blossom Hills", 76, 0, Climate.WARM.name);
        this.BlossomWoods = (BiomeSettings)this.new BiomeSettings.Element("Blossom Woods", 75, 10, Climate.WARM.name);
        this.BorealArchipelago = (BiomeSettings)this.new BiomeSettings.Element("Boreal Archipelago", 169, 1, Climate.DEEP_OCEAN.name);
        this.BorealForest = (BiomeSettings)this.new BiomeSettings.Element("Boreal Forest", 46, 10, Climate.COOL.name);
        this.BorealPlateau = (BiomeSettings)this.new BiomeSettings.Element("Boreal Plateau", 60, 10, Climate.COOL.name);
        this.BorealPlateauM = (BiomeSettings)this.new BiomeSettings.Element("Boreal Plateau M", 188, 0, Climate.COOL.name);
        this.Carr = (BiomeSettings)this.new BiomeSettings.Element("Carr", 93, 10, Climate.WARM.name);
        this.ClayHills = (BiomeSettings)this.new BiomeSettings.Element("Clay Hills", 90, 10, Climate.WARM.name);
        this.Clearing = (BiomeSettings)this.new BiomeSettings.Element("Clearing", 101, 0, Climate.WARM.name);
        this.ColdBorealForest = (BiomeSettings)this.new BiomeSettings.Element("Cold Boreal Forest", 174, 0, Climate.SNOWY.name);
        this.ColdCypressForest = (BiomeSettings)this.new BiomeSettings.Element("Cold Cypress Forest", 173, 0, Climate.SNOWY.name);
        this.ColdFirForest = (BiomeSettings)this.new BiomeSettings.Element("Cold Fir Forest", 182, 0, Climate.SNOWY.name);
        this.ColdPineForest = (BiomeSettings)this.new BiomeSettings.Element("Cold Pine Forest", 189, 0, Climate.SNOWY.name);
        this.CreekBed = (BiomeSettings)this.new BiomeSettings.Element("Creek Bed", 69, 0, Climate.SNOWY.name);
        this.CypressForest = (BiomeSettings)this.new BiomeSettings.Element("Cypress Forest", 45, 10, Climate.WARM.name);
        this.DesertArchipelago = (BiomeSettings)this.new BiomeSettings.Element("Desert Archipelago", 63, 10, Climate.OCEAN.name);
        this.EphemeralLake = (BiomeSettings)this.new BiomeSettings.Element("Ephemeral Lake", 58, 10, Climate.WARM.name);
        this.EphemeralLakeEdge = (BiomeSettings)this.new BiomeSettings.Element("Ephemeral Lake Edge", 59, 0, Climate.WARM.name);
        this.Fens = (BiomeSettings)this.new BiomeSettings.Element("Fens", 92, 10, Climate.COOL.name);
        this.FirForest = (BiomeSettings)this.new BiomeSettings.Element("Fir Forest", 54, 10, Climate.COOL.name);
        this.FloweryArchipelago = (BiomeSettings)this.new BiomeSettings.Element("Flowery Archipelago", 168, 1, Climate.DEEP_OCEAN.name);
        this.ForestedArchipelago = (BiomeSettings)this.new BiomeSettings.Element("Forested Archipelago", 40, 1, Climate.DEEP_OCEAN.name);
        this.ForestedMountains = (BiomeSettings)this.new BiomeSettings.Element("Forested Mountains", 171, 0, Climate.WARM.name);
        this.ForestedValley = (BiomeSettings)this.new BiomeSettings.Element("Forested Valley", 172, 0, Climate.WARM.name);
        this.FrozenArchipelago = (BiomeSettings)this.new BiomeSettings.Element("Frozen Archipelago", 65, 1, Climate.DEEP_OCEAN.name);
        this.Glacier = (BiomeSettings)this.new BiomeSettings.Element("Glacier", 87, 0, Climate.SNOWY.name);
        this.GrassyArchipelago = (BiomeSettings)this.new BiomeSettings.Element("Grassy Archipelago", 66, 1, Climate.DEEP_OCEAN.name);
        this.IceSheet = (BiomeSettings)this.new BiomeSettings.Element("Ice Sheet", 170, 0, Climate.SNOWY.name);
        this.Kakadu = (BiomeSettings)this.new BiomeSettings.Element("Kakadu", 78, 10, Climate.WARM.name);
        this.Lake = (BiomeSettings)this.new BiomeSettings.Element("Lake", 100, 0, Climate.WARM.name);
        this.LowHills = (BiomeSettings)this.new BiomeSettings.Element("Low Hills", 85, 0, Climate.WARM.name);
        this.Mangroves = (BiomeSettings)this.new BiomeSettings.Element("Mangroves", 91, 5, Climate.OCEAN.name);
        this.Marsh = (BiomeSettings)this.new BiomeSettings.Element("Marsh", 102, 10, Climate.WARM.name);
        this.Meadow = (BiomeSettings)this.new BiomeSettings.Element("Meadow", 51, 10, Climate.COOL.name);
        this.MeadowM = (BiomeSettings)this.new BiomeSettings.Element("Meadow M", 179, 0, Climate.COOL.name);
        this.MountainousArchipelago = (BiomeSettings)this.new BiomeSettings.Element("Mountainous Archipelago", 62, 1, Climate.DEEP_OCEAN.name);
        this.Mountains = (BiomeSettings)this.new BiomeSettings.Element("Mountains", 79, 10, Climate.COOL.name);
        this.MountainsEdge = (BiomeSettings)this.new BiomeSettings.Element("Mountains Edge", 80, 0, Climate.COOL.name);
        this.OakForest = (BiomeSettings)this.new BiomeSettings.Element("Oak Forest", 77, 10, Climate.WARM.name);
        this.Oasis = (BiomeSettings)this.new BiomeSettings.Element("Oasis", 72, 0, Climate.HOT.name);
        this.PineForest = (BiomeSettings)this.new BiomeSettings.Element("Pine Forest", 61, 10, Climate.COOL.name);
        this.PineForestArchipelago = (BiomeSettings)this.new BiomeSettings.Element("Pine Forest Archipelago", 41, 1, Climate.DEEP_OCEAN.name);
        this.Plateau = (BiomeSettings)this.new BiomeSettings.Element("Plateau", 48, 10, Climate.WARM.name);
        this.PolarDesert = (BiomeSettings)this.new BiomeSettings.Element("Polar Desert", 42, 10, Climate.SNOWY.name);
        this.Prairie = (BiomeSettings)this.new BiomeSettings.Element("Prairie", 84, 10, Climate.COOL.name);
        this.Rainforest = (BiomeSettings)this.new BiomeSettings.Element("Rainforest", 73, 10, Climate.HOT.name);
        this.RainforestValley = (BiomeSettings)this.new BiomeSettings.Element("Rainforest Valley", 74, 0, Climate.HOT.name);
        this.RedDesert = (BiomeSettings)this.new BiomeSettings.Element("Red Desert", 105, 10, Climate.HOT.name);
        this.RiparianZone = (BiomeSettings)this.new BiomeSettings.Element("Riparian Zone", 135, 0, Climate.HOT.name);
        this.RockyDesert = (BiomeSettings)this.new BiomeSettings.Element("Rocky Desert", 67, 10, Climate.HOT.name);
        this.RockyHills = (BiomeSettings)this.new BiomeSettings.Element("Rocky Hills", 88, 10, Climate.HOT.name);
        this.RoofedShrublands = (BiomeSettings)this.new BiomeSettings.Element("Roofed Shrublands", 178, 0, Climate.WARM.name);
        this.Sahara = (BiomeSettings)this.new BiomeSettings.Element("Sahara", 70, 10, Climate.HOT.name);
        this.SandstoneCanyon = (BiomeSettings)this.new BiomeSettings.Element("Sandstone Canyon", 56, 10, Climate.HOT.name);
        this.SandstoneCanyons = (BiomeSettings)this.new BiomeSettings.Element("Sandstone Canyon 2", 57, 10, Climate.HOT.name);
        this.SandstoneRanges = (BiomeSettings)this.new BiomeSettings.Element("Sandstone Ranges", 49, 10, Climate.HOT.name);
        this.SandstoneRangesM = (BiomeSettings)this.new BiomeSettings.Element("Sandstone Ranges M", 177, 0, Climate.HOT.name);
        this.Scree = (BiomeSettings)this.new BiomeSettings.Element("Scree", 81, 0, Climate.COOL.name);
        this.Scrub = (BiomeSettings)this.new BiomeSettings.Element("Scrub", 68, 10, Climate.WARM.name);
        this.Shield = (BiomeSettings)this.new BiomeSettings.Element("Shield", 89, 10, Climate.COOL.name);
        this.Shrublands = (BiomeSettings)this.new BiomeSettings.Element("Shrublands", 50, 10, Climate.COOL.name);
        this.SilverPineForest = (BiomeSettings)this.new BiomeSettings.Element("Silver Pine Forest", 94, 10, Climate.COOL.name);
        this.SilverPineHills = (BiomeSettings)this.new BiomeSettings.Element("Silver Pine Hills", 95, 0, Climate.COOL.name);
        this.SnowyDesert = (BiomeSettings)this.new BiomeSettings.Element("Snowy Desert", 181, 0, Climate.SNOWY.name);
        this.SnowyPlateau = (BiomeSettings)this.new BiomeSettings.Element("Snowy Plateau", 176, 10, Climate.SNOWY.name);
        this.SnowyRanges = (BiomeSettings)this.new BiomeSettings.Element("Snowy Ranges", 104, 10, Climate.SNOWY.name);
        this.SnowyWastelands = (BiomeSettings)this.new BiomeSettings.Element("Snowy Wastelands", 183, 0, Climate.SNOWY.name);
        this.Steppe = (BiomeSettings)this.new BiomeSettings.Element("Steppe", 83, 10, Climate.COOL.name);
        this.StoneCanyon = (BiomeSettings)this.new BiomeSettings.Element("Stone Canyon", 184, 0, Climate.COOL.name);
        this.StoneCanyons = (BiomeSettings)this.new BiomeSettings.Element("Stone Canyons", 185, 0, Climate.COOL.name);
        this.TropicalArchipelago = (BiomeSettings)this.new BiomeSettings.Element("Tropical Archipelago", 64, 1, Climate.DEEP_OCEAN.name);
        this.Tundra = (BiomeSettings)this.new BiomeSettings.Element("Tundra", 53, 10, Climate.SNOWY.name);
        this.Volcano = (BiomeSettings)this.new BiomeSettings.Element("Volcano", 47, 0, Climate.WARM.name);
        this.VolcanoM = (BiomeSettings)this.new BiomeSettings.Element("Volcano M", 175, 0, Climate.WARM.name);
        this.Wastelands = (BiomeSettings)this.new BiomeSettings.Element("Wastelands", 55, 10, Climate.COOL.name);
        this.WoodlandField = (BiomeSettings)this.new BiomeSettings.Element("Woodland Field", 96, 10, Climate.WARM.name);
        this.WoodlandHills = (BiomeSettings)this.new BiomeSettings.Element("Woodland Hills", 44, 0, Climate.WARM.name);
        this.WoodlandLake = (BiomeSettings)this.new BiomeSettings.Element("Woodland Lake", 186, 0, Climate.WARM.name);
        this.WoodlandLakeEdge = (BiomeSettings)this.new BiomeSettings.Element("Woodland Lake Edge", 187, 0, Climate.WARM.name);
        this.Woodlands = (BiomeSettings)this.new BiomeSettings.Element("Woodlands", 43, 10, Climate.WARM.name);
        this.XericSavannah = (BiomeSettings)this.new BiomeSettings.Element("Xeric Savannah", 82, 10, Climate.HOT.name);
        this.XericShrubland = (BiomeSettings)this.new BiomeSettings.Element("Xeric Shrubland", 106, 10, Climate.HOT.name);
        this.biomesFromConfig = this.climateControlCategory.booleanSetting(biomesOnName, "", false);
        this.biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName(configName), "Use biomes in new worlds and dimensions", true);
        for (BiomeSettings.Element element : this.elements()) {
            for (BiomeSettings.Element possibleM : this.elements()) {
                if (element.biomeID().value() + 128 != possibleM.biomeID().value()) continue;
                element.setMBiome(possibleM);
            }
        }
    }

    @Override
    public ArrayList<ClimateDistribution.Incidence> incidences() {
        return super.incidences();
    }

    @Override
    public void setNativeBiomeIDs(File configDirectory) {
        File ebDirectory = new File(configDirectory, "Enhanced Biomes");
        if (!ebDirectory.exists()) {
            return;
        }
        File biomeFile = new File(ebDirectory, "Biomes.cfg");
        if (!biomeFile.exists()) {
            return;
        }
        NativeSettings nativeSettings = new NativeSettings();
        nativeSettings.setIDs(new Configuration(biomeFile));
    }

    @Override
    public void update(SubBiomeChooser subBiomeChooser) {
        this.setUpAllSubBiomes();
        super.update(subBiomeChooser);
    }

    private BiomeReplacer.Variable subBiomeSet(BiomeSettings.ID biome) {
        BiomeReplacer.Variable result = this.subBiomeSets.get(biome);
        if (result == null) {
            result = new BiomeReplacer.Variable();
            this.subBiomeSets.put(biome, result);
        }
        return result;
    }

    private void addSubBiome(BiomeSettings.ID biome, BiomeSettings.ID subBiome) {
        if (subBiome.active()) {
            this.subBiomeSet(biome).add(subBiome, 1);
            biome.setSubBiomeChooser(this.subBiomeSet(biome));
        }
    }

    public void setUpAllSubBiomes() {
        this.subBiomeSets = new HashMap();
        this.addSubBiome(this.AspenForest, this.AspenHills);
        this.addSubBiome(this.BlossomWoods, this.BlossomHills);
        this.addSubBiome(this.Rainforest, this.RainforestValley);
        this.addSubBiome(this.Shrublands, this.RoofedShrublands);
        this.addSubBiome(this.SilverPineForest, this.SilverPineHills);
        this.addSubBiome(this.Woodlands, this.WoodlandField);
        this.addSubBiome(this.Woodlands, this.WoodlandHills);
        this.addSubBiome(this.Woodlands, this.WoodlandLake);
        this.addSubBiome(this.StoneCanyon, this.StoneCanyons);
        this.addSubBiome(this.ForestedMountains, this.ForestedValley);
        this.addSubBiome(this.Sahara, this.Sahara);
        this.addSubBiome(this.Sahara, this.Sahara);
        this.addSubBiome(this.Sahara, this.Sahara);
        this.addSubBiome(this.Sahara, this.Oasis);
        this.addSubBiome(this.RedDesert, this.RedDesert);
        this.addSubBiome(this.RedDesert, this.RedDesert);
        this.addSubBiome(this.RedDesert, this.RedDesert);
        this.addSubBiome(this.RedDesert, this.Oasis);
    }

    @Override
    public void setRules(ClimateControlRules rules) {
    }

    @Override
    public void onNewWorld() {
        this.biomesFromConfig.set(this.biomesInNewWorlds);
    }

    @Override
    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }

    private class NativeSettings
    extends Settings {
        public final Settings.Category biomeIDCategory = new Settings.Category(this, "general");
        ArrayList<LinkedSetting> linkedSettings = new ArrayList();

        NativeSettings() {
            for (BiomeSettings.Element element : EBBiomeSettings.this.elements()) {
                this.linkedSettings.add(new LinkedSetting(element));
            }
        }

        void setIDs(Configuration settingFrom) {
            this.readFrom(settingFrom);
            for (LinkedSetting linkage : this.linkedSettings) {
                linkage.settingInCC.biomeID().set(linkage.settingInEB);
            }
        }

        private class LinkedSetting {
            final Mutable<Integer> settingInEB;
            final BiomeSettings.Element settingInCC;

            LinkedSetting(BiomeSettings.Element element) {
                this.settingInCC = element;
                this.settingInEB = NativeSettings.this.biomeIDCategory.intSetting("Biome ID of " + element.name, element.biomeID().value());
            }
        }
    }
}

