/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateDistribution;
import climateControl.biomeSettings.EBXLBiomes;
import climateControl.utils.Mutable;
import climateControl.utils.Settings;
import java.io.File;

public class EBXLBiomeSettings
extends BiomeSettings {
    public static final String biomeCategory = "EXBLBiome";
    public static final String EBLXCategory = "EBLXSettings";
    public final Settings.Category EBLXSettings = new Settings.Category(this, "EBLXSettings");
    public final BiomeSettings.Element alpine;
    public final BiomeSettings.Element autumnwoods;
    public final BiomeSettings.Element birchforest;
    public final BiomeSettings.Element extremejungle;
    public final BiomeSettings.Element forestedisland;
    public final BiomeSettings.Element forestedhills;
    public final BiomeSettings.Element glacier;
    public final BiomeSettings.Element greenhills;
    public final BiomeSettings.Element icewasteland;
    public final BiomeSettings.Element greenswamp;
    public final BiomeSettings.ID marsh;
    public final BiomeSettings.Element meadow;
    public final BiomeSettings.Element minijungle;
    public final BiomeSettings.Element mountaindesert;
    public final BiomeSettings.Element mountainridge;
    public final BiomeSettings.Element mountaintaiga;
    public final BiomeSettings.Element pineforest;
    public final BiomeSettings.Element rainforest;
    public final BiomeSettings.Element redwoodforest;
    public final BiomeSettings.Element redwoodlush;
    public final BiomeSettings.Element savanna;
    public final BiomeSettings.Element shrubland;
    public final BiomeSettings.Element snowyforest;
    public final BiomeSettings.Element snowyrainforest;
    public final BiomeSettings.Element temperaterainforest;
    public final BiomeSettings.Element tundra;
    public final BiomeSettings.Element wasteland;
    public final BiomeSettings.Element woodlands;
    static final String biomesOnName = "EBXLBiomesOn";
    public final Mutable<Boolean> biomesFromConfig;
    static final String configName = "EBXL";
    public final Mutable<Boolean> biomesInNewWorlds;

    public EBXLBiomeSettings() {
        super(biomeCategory);
        this.alpine = (BiomeSettings)this.new BiomeSettings.Element("Alpine", 60, Climate.SNOWY.name);
        this.autumnwoods = (BiomeSettings)this.new BiomeSettings.Element("Autumn Woods", 61, Climate.COOL.name);
        this.birchforest = (BiomeSettings)this.new BiomeSettings.Element("Birch Forest", 62, Climate.WARM.name);
        this.extremejungle = (BiomeSettings)this.new BiomeSettings.Element("Extreme Jungle", 63, Climate.HOT.name);
        this.forestedisland = (BiomeSettings)this.new BiomeSettings.Element("Forested Island", 65, ClimateDistribution.MEDIUM.name());
        this.forestedhills = (BiomeSettings)this.new BiomeSettings.Element("Forested Hills", 64, ClimateDistribution.MEDIUM.name());
        this.glacier = (BiomeSettings)this.new BiomeSettings.Element("Glacier", 66, Climate.SNOWY.name);
        this.greenhills = (BiomeSettings)this.new BiomeSettings.Element("Green Hills", 67, Climate.COOL.name);
        this.icewasteland = (BiomeSettings)this.new BiomeSettings.Element("Ice Wasteland", 41, Climate.SNOWY.name);
        this.greenswamp = (BiomeSettings)this.new BiomeSettings.Element("Green Swamp", 40, Climate.WARM.name);
        this.marsh = (BiomeSettings)this.new BiomeSettings.ID("Marsh", -1);
        this.meadow = (BiomeSettings)this.new BiomeSettings.Element("Meadow", 43, ClimateDistribution.MEDIUM.name());
        this.minijungle = (BiomeSettings)this.new BiomeSettings.Element("Minijungle", 44, Climate.HOT.name);
        this.mountaindesert = (BiomeSettings)this.new BiomeSettings.Element("Mountain Desert", 45, Climate.HOT.name);
        this.mountainridge = (BiomeSettings)this.new BiomeSettings.Element("Mountain Ridge", 46, ClimateDistribution.PLAINS.name());
        this.mountaintaiga = (BiomeSettings)this.new BiomeSettings.Element("Mountain Taiga", 47, Climate.COOL.name);
        this.pineforest = (BiomeSettings)this.new BiomeSettings.Element("Pine Forest", 48, ClimateDistribution.MEDIUM.name());
        this.rainforest = (BiomeSettings)this.new BiomeSettings.Element("Rainforest", 49, Climate.HOT.name);
        this.redwoodforest = (BiomeSettings)this.new BiomeSettings.Element("Redwood Forest", 50, ClimateDistribution.COOL.name());
        this.redwoodlush = (BiomeSettings)this.new BiomeSettings.Element("Lush Redwood Forest", 51, ClimateDistribution.WARM.name());
        this.savanna = (BiomeSettings)this.new BiomeSettings.Element("Savanna", 52, Climate.HOT.name);
        this.shrubland = (BiomeSettings)this.new BiomeSettings.Element("Shrubland", 53, ClimateDistribution.PLAINS.name());
        this.snowyforest = (BiomeSettings)this.new BiomeSettings.Element("Snowy Forest", 54, Climate.SNOWY.name);
        this.snowyrainforest = (BiomeSettings)this.new BiomeSettings.Element("Snowy Rainforest", 55, Climate.SNOWY.name);
        this.temperaterainforest = (BiomeSettings)this.new BiomeSettings.Element("Temperate Rainforest", 56, ClimateDistribution.MEDIUM.name());
        this.tundra = (BiomeSettings)this.new BiomeSettings.Element("Tundra", 57, Climate.SNOWY.name);
        this.wasteland = (BiomeSettings)this.new BiomeSettings.Element("Wasteland", 58, ClimateDistribution.PLAINS.name());
        this.woodlands = (BiomeSettings)this.new BiomeSettings.Element("Woodlands", 59, ClimateDistribution.MEDIUM.name());
        this.biomesFromConfig = this.climateControlCategory.booleanSetting(biomesOnName, "", false);
        this.biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName(configName), "Use biome in new worlds and dimensions", true);
    }

    public void setRules(ClimateControlRules rules) {
    }

    public void setNativeBiomeIDs(File configDirectory) {
        EBXLBiomes EBXLBiomes2 = new EBXLBiomes(configDirectory);
        this.alpine.biomeID().set(EBXLBiomes2.alpine.biomeID());
        this.autumnwoods.biomeID().set(EBXLBiomes2.autumnwoods.nativeBiomeID());
        this.birchforest.biomeID().set(EBXLBiomes2.birchforest.nativeBiomeID());
        this.extremejungle.biomeID().set(EBXLBiomes2.extremejungle.nativeBiomeID());
        this.forestedhills.biomeID().set(EBXLBiomes2.forestedhills.nativeBiomeID());
        this.forestedisland.biomeID().set(EBXLBiomes2.forestedisland.nativeBiomeID());
        this.glacier.biomeID().set(EBXLBiomes2.glacier.nativeBiomeID());
        this.greenhills.biomeID().set(EBXLBiomes2.greenhills.nativeBiomeID());
        this.greenswamp.biomeID().set(EBXLBiomes2.greenswamp.nativeBiomeID());
        this.icewasteland.biomeID().set(EBXLBiomes2.icewasteland.nativeBiomeID());
        this.marsh.biomeID().set(EBXLBiomes2.marsh.nativeBiomeID());
        this.meadow.biomeID().set(EBXLBiomes2.meadow.nativeBiomeID());
        this.minijungle.biomeID().set(EBXLBiomes2.minijungle.nativeBiomeID());
        this.mountaindesert.biomeID().set(EBXLBiomes2.mountaindesert.nativeBiomeID());
        this.mountainridge.biomeID().set(EBXLBiomes2.mountainridge.nativeBiomeID());
        this.mountaintaiga.biomeID().set(EBXLBiomes2.mountaintaiga.nativeBiomeID());
        this.pineforest.biomeID().set(EBXLBiomes2.pineforest.nativeBiomeID());
        this.rainforest.biomeID().set(EBXLBiomes2.rainforest.nativeBiomeID());
        this.redwoodforest.biomeID().set(EBXLBiomes2.redwoodforest.nativeBiomeID());
        this.redwoodlush.biomeID().set(EBXLBiomes2.redwoodlush.nativeBiomeID());
        this.savanna.biomeID().set(EBXLBiomes2.savanna.nativeBiomeID());
        this.shrubland.biomeID().set(EBXLBiomes2.shrubland.nativeBiomeID());
        this.snowyforest.biomeID().set(EBXLBiomes2.snowforest.nativeBiomeID());
        this.snowyrainforest.biomeID().set(EBXLBiomes2.snowyrainforest.nativeBiomeID());
        this.temperaterainforest.biomeID().set(EBXLBiomes2.temperaterainforest.nativeBiomeID());
        this.tundra.biomeID().set(EBXLBiomes2.tundra.nativeBiomeID());
        this.wasteland.biomeID().set(EBXLBiomes2.wasteland.nativeBiomeID());
        this.woodlands.biomeID().set(EBXLBiomes2.woodland.nativeBiomeID());
    }

    public void onNewWorld() {
        this.biomesFromConfig.set(this.biomesInNewWorlds);
    }

    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }
}

