/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateDistribution;
import climateControl.biomeSettings.BiomeReplacer;
import climateControl.generator.SubBiomeChooser;
import climateControl.utils.Acceptor;
import climateControl.utils.Mutable;
import climateControl.utils.Settings;
import highlands.Config;
import java.io.File;
import java.util.HashMap;
import net.minecraft.world.biome.BiomeGenBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlandsBiomeSettings
extends BiomeSettings {
    public static final String biomeCategory = "HighlandsBiome";
    public static final String highlandsCategory = "HighlandsSettings";
    public final Settings.Category highlandsSettings = new Settings.Category(this, "HighlandsSettings");
    public final BiomeSettings.Element alps = (BiomeSettings)this.new BiomeSettings.Element("Alps", 200, "COOL");
    public final BiomeSettings.Element autumnForest = (BiomeSettings)this.new BiomeSettings.Element("Autumn Forest", 201, "COOL");
    public final BiomeSettings.Element badlands = (BiomeSettings)this.new BiomeSettings.Element("Badlands", 202, "WARM");
    public final BiomeSettings.Element birchHills = (BiomeSettings)this.new BiomeSettings.Element("Birch Hills", 203);
    public final BiomeSettings.Element bog;
    public final BiomeSettings.Element cliffs;
    public final BiomeSettings.Element desertMountains;
    public final BiomeSettings.Element dunes;
    public final BiomeSettings.Element estuary;
    public final BiomeSettings.Element flyingMountains;
    public final BiomeSettings.Element glacier;
    public final BiomeSettings.Element highlandsb;
    public final BiomeSettings.Element lowlands;
    public final BiomeSettings.Element meadow;
    public final BiomeSettings.ID ocean2;
    public final BiomeSettings.Element outback;
    public final BiomeSettings.Element pinelands;
    public final BiomeSettings.Element rainforest;
    public final BiomeSettings.Element redwoodForest;
    public final BiomeSettings.Element rockMountains;
    public final BiomeSettings.Element sahel;
    public final BiomeSettings.Element savannah;
    public final BiomeSettings.Element steppe;
    public final BiomeSettings.Element snowMountains;
    public final BiomeSettings.Element tallPineForest;
    public final BiomeSettings.Element tropics;
    public final BiomeSettings.Element tropicalIslands;
    public final BiomeSettings.Element tundra;
    public final BiomeSettings.Element woodlands;
    public final BiomeSettings.Element woodlandMountains;
    public final BiomeSettings.ID baldHill;
    public final BiomeSettings.ID canyon;
    public final BiomeSettings.Element desertIsland;
    public final BiomeSettings.Element forestIsland;
    public final BiomeSettings.Element jungleIsland;
    public final BiomeSettings.ID lake;
    public final BiomeSettings.ID mesa;
    public final BiomeSettings.ID oasis;
    public final BiomeSettings.Element rockIsland;
    public final BiomeSettings.Element shrublands;
    public final BiomeSettings.Element snowIsland;
    public final BiomeSettings.ID valley;
    public final BiomeSettings.Element volcanoIsland;
    public final BiomeSettings.Element windyIsland;
    public final BiomeSettings.ID desert;
    public final BiomeSettings.ID plains;
    public final BiomeSettings.ID deepOcean;
    public final BiomeSettings.ID frozenOcean;
    public final BiomeSettings.ID frozenRiver;
    public Acceptor<Boolean> catchFalse;
    private HashMap<BiomeSettings.ID, BiomeReplacer.Variable> subBiomeSets;
    static final String biomesOnName = "HighlandsBiomesOn";
    public final Mutable<Boolean> biomesFromConfig;
    static final String configName = "Highlands";
    public final Mutable<Boolean> biomesInNewWorlds;

    public HighlandsBiomeSettings() {
        super(biomeCategory);
        this.bog = (BiomeSettings)this.new BiomeSettings.Element("Bog", 204, true, Climate.COOL.name);
        this.cliffs = (BiomeSettings)this.new BiomeSettings.Element("Cliffs", 205, ClimateDistribution.MEDIUM.name());
        this.desertMountains = (BiomeSettings)this.new BiomeSettings.Element("Desert Mountains", 206, "HOT");
        this.dunes = (BiomeSettings)this.new BiomeSettings.Element("Dunes", 207, Climate.HOT.name);
        this.estuary = (BiomeSettings)this.new BiomeSettings.Element("Estuary", 208, "WARM");
        this.flyingMountains = (BiomeSettings)this.new BiomeSettings.Element("Flying Mountains", 209, ClimateDistribution.MEDIUM.name());
        this.glacier = (BiomeSettings)this.new BiomeSettings.Element("Glacier", 210, Climate.SNOWY.name);
        this.highlandsb = (BiomeSettings)this.new BiomeSettings.Element(configName, 211, ClimateDistribution.MEDIUM.name());
        this.lowlands = (BiomeSettings)this.new BiomeSettings.Element("Lowlands", 212, ClimateDistribution.MEDIUM.name());
        this.meadow = (BiomeSettings)this.new BiomeSettings.Element("Meadow", 213, true, ClimateDistribution.MEDIUM.name());
        this.ocean2 = (BiomeSettings)this.new BiomeSettings.ID("Improved Oceans", 229);
        this.outback = (BiomeSettings)this.new BiomeSettings.Element("Outback", 214, Climate.HOT.name);
        this.pinelands = (BiomeSettings)this.new BiomeSettings.Element("Pinelands", 215, true, "COOL");
        this.rainforest = (BiomeSettings)this.new BiomeSettings.Element("Rainforest", 216, "WARM");
        this.redwoodForest = (BiomeSettings)this.new BiomeSettings.Element("Redwood Forest", 217, "COOL");
        this.rockMountains = (BiomeSettings)this.new BiomeSettings.Element("Rock Mountains", 218, Climate.WARM.name);
        this.sahel = (BiomeSettings)this.new BiomeSettings.Element("Sahel", 219, true, Climate.HOT.name);
        this.savannah = (BiomeSettings)this.new BiomeSettings.Element("Savannah", 220, true, Climate.HOT.name);
        this.steppe = (BiomeSettings)this.new BiomeSettings.Element("Steppe", 221, true, Climate.COOL.name);
        this.snowMountains = (BiomeSettings)this.new BiomeSettings.Element("Snow Mountains", 222, Climate.SNOWY.name);
        this.tallPineForest = (BiomeSettings)this.new BiomeSettings.Element("Tall Pine Forest", 223, Climate.SNOWY.name);
        this.tropics = (BiomeSettings)this.new BiomeSettings.Element("Tropics", 224, "HOT");
        this.tropicalIslands = new BiomeSettings.Element("Tropical Islands", 225, 1, true, Climate.DEEP_OCEAN.name);
        this.tundra = (BiomeSettings)this.new BiomeSettings.Element("Tundra", 226, Climate.SNOWY.name);
        this.woodlands = (BiomeSettings)this.new BiomeSettings.Element("Woodlands", 227, ClimateDistribution.MEDIUM.name());
        this.woodlandMountains = (BiomeSettings)this.new BiomeSettings.Element("Woodland Mountains", 228, ClimateDistribution.MEDIUM.name());
        this.baldHill = (BiomeSettings)this.new BiomeSettings.ID("Bald Hill", 238);
        this.canyon = (BiomeSettings)this.new BiomeSettings.ID("Canyon", 242);
        this.desertIsland = (BiomeSettings)this.new BiomeSettings.Element("DesertIsland", 230, 1, "DEEP_OCEAN");
        this.forestIsland = (BiomeSettings)this.new BiomeSettings.Element("Forest Island", 231, 1, "DEEP_OCEAN");
        this.jungleIsland = (BiomeSettings)this.new BiomeSettings.Element("Jungle Island", 232, 1, "DEEP_OCEAN");
        this.lake = (BiomeSettings)this.new BiomeSettings.ID("Lake", 237);
        this.mesa = (BiomeSettings)this.new BiomeSettings.ID("Mesa ID", 239);
        this.oasis = (BiomeSettings)this.new BiomeSettings.ID("Oasis", 241);
        this.rockIsland = (BiomeSettings)this.new BiomeSettings.Element("Rock Island", 235, 1, "DEEP_OCEAN");
        this.shrublands = (BiomeSettings)this.new BiomeSettings.Element("Shrublands", 243);
        this.snowIsland = (BiomeSettings)this.new BiomeSettings.Element("Snow Island", 234, 1, "DEEP_OCEAN");
        this.valley = (BiomeSettings)this.new BiomeSettings.ID("Valley", 240);
        this.volcanoIsland = (BiomeSettings)this.new BiomeSettings.Element("Volcano Island", 233, 1, "DEEP_OCEAN");
        this.windyIsland = new BiomeSettings.Element("Windy Island", 236, 1, true, "DEEP_OCEAN");
        this.desert = this.externalBiome("Desert", BiomeGenBase.field_76769_d.field_76756_M);
        this.plains = this.externalBiome("Plains", BiomeGenBase.field_76772_c.field_76756_M);
        this.deepOcean = this.externalBiome("Deep Ocean", BiomeGenBase.field_150575_M.field_76756_M);
        this.frozenOcean = this.externalBiome("Frozen Ocean", BiomeGenBase.field_76776_l.field_76756_M);
        this.frozenRiver = this.externalBiome("Frozen River", BiomeGenBase.field_76777_m.field_76756_M);
        this.catchFalse = this.catchFalse();
        this.biomesFromConfig = this.climateControlCategory.booleanSetting(biomesOnName, "", false);
        this.biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName(configName), "Use biome in new worlds and dimensions", true);
    }

    public Acceptor<Boolean> catchFalse() {
        return new Acceptor<Boolean>(){

            @Override
            public void accept(Boolean arg0) {
                if (!arg0.booleanValue()) {
                    throw new RuntimeException();
                }
            }
        };
    }

    private BiomeReplacer.Variable subBiomeSet(BiomeSettings.ID biome) {
        BiomeReplacer.Variable result = this.subBiomeSets.get(biome);
        if (result == null) {
            result = new BiomeReplacer.Variable();
            this.subBiomeSets.put(biome, result);
        }
        return result;
    }

    private void addSubBiome(BiomeSettings.ID biome, BiomeSettings.ID subBiome) {
        if (subBiome.active()) {
            this.subBiomeSet(biome).add(subBiome, 1);
            biome.setSubBiomeChooser(this.subBiomeSet(biome));
        }
    }

    @Override
    public void update(SubBiomeChooser subBiomeChooser) {
        this.setUpAllSubBiomes();
        super.update(subBiomeChooser);
    }

    public void setUpAllSubBiomes() {
        this.subBiomeSets = new HashMap();
        this.addSubBiome(this.alps, this.tallPineForest);
        this.addSubBiome(this.alps, this.glacier);
        this.addSubBiome(this.alps, this.alps);
        this.addSubBiome(this.alps, this.alps);
        this.addSubBiome(this.tropicalIslands, this.volcanoIsland);
        for (int i = 0; i < 3; ++i) {
            this.addSubBiome(this.tropicalIslands, this.tropicalIslands);
        }
        this.addSubBiome(this.autumnForest, this.baldHill);
        this.addSubBiome(this.autumnForest, this.lake);
        this.addSubBiome(this.autumnForest, this.autumnForest);
        this.addSubBiome(this.autumnForest, this.autumnForest);
        this.addSubBiome(this.birchHills, this.meadow);
        this.addSubBiome(this.birchHills, this.birchHills);
        this.addSubBiome(this.cliffs, this.valley);
        this.addSubBiome(this.desertMountains, this.oasis);
        this.addSubBiome(this.desertMountains, this.desertMountains);
        this.addSubBiome(this.desertMountains, this.desertMountains);
        this.addSubBiome(this.desertMountains, this.desertMountains);
        this.addSubBiome(this.dunes, this.oasis);
        this.addSubBiome(this.dunes, this.dunes);
        this.addSubBiome(this.estuary, this.lake);
        this.addSubBiome(this.meadow, this.lake);
        this.addSubBiome(this.meadow, this.birchHills);
        this.addSubBiome(this.meadow, this.meadow);
        this.addSubBiome(this.meadow, this.meadow);
        this.addSubBiome(this.woodlands, this.baldHill);
        this.addSubBiome(this.woodlands, this.lake);
        this.addSubBiome(this.woodlands, this.plains);
        this.addSubBiome(this.woodlands, this.woodlands);
        this.addSubBiome(this.woodlands, this.woodlands);
        this.addSubBiome(this.highlandsb, this.woodlands);
        this.addSubBiome(this.highlandsb, this.highlandsb);
        this.addSubBiome(this.lowlands, this.baldHill);
        this.addSubBiome(this.lowlands, this.lake);
        this.addSubBiome(this.lowlands, this.lowlands);
        this.addSubBiome(this.lowlands, this.lowlands);
        this.addSubBiome(this.outback, this.mesa);
        this.addSubBiome(this.outback, this.desert);
        this.addSubBiome(this.outback, this.outback);
        this.addSubBiome(this.outback, this.outback);
        this.addSubBiome(this.pinelands, this.autumnForest);
        this.addSubBiome(this.pinelands, this.pinelands);
        this.addSubBiome(this.redwoodForest, this.highlandsb);
        this.addSubBiome(this.redwoodForest, this.lake);
        this.addSubBiome(this.redwoodForest, this.redwoodForest);
        this.addSubBiome(this.redwoodForest, this.redwoodForest);
        this.addSubBiome(this.sahel, this.mesa);
        this.addSubBiome(this.sahel, this.desert);
        this.addSubBiome(this.sahel, this.savannah);
        this.addSubBiome(this.sahel, this.sahel);
        this.addSubBiome(this.sahel, this.sahel);
        this.addSubBiome(this.sahel, this.sahel);
        this.addSubBiome(this.savannah, this.mesa);
        this.addSubBiome(this.savannah, this.savannah);
        this.addSubBiome(this.snowMountains, this.pinelands);
        this.addSubBiome(this.snowMountains, this.snowMountains);
        this.addSubBiome(this.snowMountains, this.snowMountains);
        this.addSubBiome(this.snowMountains, this.snowMountains);
        this.addSubBiome(this.steppe, this.canyon);
        this.addSubBiome(this.steppe, this.steppe);
        this.addSubBiome(this.tallPineForest, this.alps);
        this.addSubBiome(this.tallPineForest, this.tallPineForest);
        this.addSubBiome(this.rainforest, this.baldHill);
        this.addSubBiome(this.rainforest, this.lake);
        this.addSubBiome(this.rainforest, this.rainforest);
        this.addSubBiome(this.rainforest, this.rainforest);
        this.addSubBiome(this.tropics, this.lake);
        this.addSubBiome(this.tropics, this.tropics);
        this.addSubBiome(this.tundra, this.alps);
        this.addSubBiome(this.tundra, this.tallPineForest);
        this.addSubBiome(this.tundra, this.tundra);
        this.addSubBiome(this.tundra, this.tundra);
    }

    public File configFile(File source) {
        File directory = source.getParentFile();
        File highlands = new File(directory, configName);
        File generalConfig = new File(highlands, "General.cfg");
        return generalConfig;
    }

    @Override
    public void setNativeBiomeIDs(File configDirectory) {
        try {
            this.alps.biomeID().set(Config.alpsID);
            this.autumnForest.biomeID().set(Config.autumnForestID);
            this.badlands.biomeID().set(Config.badlandsID);
            this.baldHill.biomeID().set(Config.baldHillID);
            this.birchHills.biomeID().set(Config.birchHillsID);
            this.bog.biomeID().set(Config.bogID);
            this.canyon.biomeID().set(Config.canyonID);
            this.cliffs.biomeID().set(Config.cliffsID);
            this.desertIsland.biomeID().set(Config.desertIslandID);
            this.desertMountains.biomeID().set(Config.desertMountainsID);
            this.dunes.biomeID().set(Config.dunesID);
            this.estuary.biomeID().set(Config.estuaryID);
            this.flyingMountains.biomeID().set(Config.flyingMountainsID);
            this.forestIsland.biomeID().set(Config.forestIslandID);
            this.glacier.biomeID().set(Config.glacierID);
            this.highlandsb.biomeID().set(Config.highlandsbID);
            this.lowlands.biomeID().set(Config.lowlandsID);
            this.jungleIsland.biomeID().set(Config.jungleIslandID);
            this.lake.biomeID().set(Config.lakeID);
            this.meadow.biomeID().set(Config.meadowID);
            this.mesa.biomeID().set(Config.mesaID);
            this.oasis.biomeID().set(Config.oasisID);
            this.ocean2.biomeID().set(Config.ocean2ID);
            this.outback.biomeID().set(Config.outbackID);
            this.pinelands.biomeID().set(Config.pinelandsID);
            this.rainforest.biomeID().set(Config.rainforestID);
            this.redwoodForest.biomeID().set(Config.redwoodForestID);
            this.rockIsland.biomeID().set(Config.rockIslandID);
            this.rockMountains.biomeID().set(Config.rockMountainsID);
            this.sahel.biomeID().set(Config.sahelID);
            this.savannah.biomeID().set(Config.savannahID);
            this.shrublands.biomeID().set(Config.shrublandID);
            this.snowIsland.biomeID().set(Config.snowIslandID);
            this.snowMountains.biomeID().set(Config.snowMountainsID);
            this.tallPineForest.biomeID().set(Config.tallPineForestID);
            this.tropicalIslands.biomeID().set(Config.tropicalIslandsID);
            this.tropics.biomeID().set(Config.tropicsID);
            this.tundra.biomeID().set(Config.tundraID);
            this.valley.biomeID().set(Config.valleyID);
            this.volcanoIsland.biomeID().set(Config.volcanoIslandID);
            this.windyIsland.biomeID().set(Config.windyIslandID);
            this.woodlandMountains.biomeID().set(Config.woodlandMountainsID);
            this.woodlands.biomeID().set(Config.woodlandsID);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void setRules(ClimateControlRules rules) {
        rules.disallowRivers(this.desertMountains.biomeID().value());
        rules.disallowRivers(this.canyon.biomeID().value());
        rules.disallowRivers(this.rockMountains.biomeID().value());
        rules.disallowRivers(this.tropics.biomeID().value());
        rules.disallowRivers(this.valley.biomeID().value());
        rules.disallowStoneBeach(this.sahel.biomeID().value());
        rules.disallowStoneBeach(this.desertMountains.biomeID().value());
        rules.disallowStoneBeach(this.dunes.biomeID().value());
        rules.disallowStoneBeach(this.desertIsland.biomeID().value());
        this.setVillages(rules);
    }

    @Override
    public void onNewWorld() {
        this.biomesFromConfig.set(this.biomesInNewWorlds);
    }

    @Override
    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }
}

