/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import climateControl.api.BiomeSettings;
import climateControl.api.ClimateControlRules;
import climateControl.biomeSettings.NativeChromaticraftSettings;
import climateControl.utils.Mutable;
import climateControl.utils.Settings;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ReikasBiomeSettings
extends BiomeSettings {
    public static final String biomeCategory = "ReikasBiome";
    public static final String reikasCategory = "ReikasSettings";
    public final Settings.Category reikasSettings = new Settings.Category(this, "ReikasSettings");
    public final BiomeSettings.Element enderForest = (BiomeSettings)this.new BiomeSettings.Element("Ender Forest", 47, "MEDIUM");
    public final BiomeSettings.Element island = (BiomeSettings)this.new BiomeSettings.Element("Island", 101, "OCEAN");
    public final BiomeSettings.Element plains = (BiomeSettings)this.new BiomeSettings.Element("Plains", 102, "PLAINS");
    public final BiomeSettings.Element rainbowForest = (BiomeSettings)this.new BiomeSettings.Element("Rainbow Forest", 48, "MEDIUM");
    public final BiomeSettings.Element skyland = (BiomeSettings)this.new BiomeSettings.Element("Skyland", 100, "LAND");
    static final String biomesOnName = "ReikasBiomesOn";
    public final Mutable<Boolean> biomesFromConfig = this.climateControlCategory.booleanSetting("ReikasBiomesOn", "", false);
    static final String configName = "Reikas";
    public final Mutable<Boolean> biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName("Reikas"), "Use biome in new worlds and dimensions", true);

    public ReikasBiomeSettings() {
        super(biomeCategory);
        this.enderForest.biomeIncidences().set(3);
        this.island.biomeIncidences().set(0);
        this.plains.biomeIncidences().set(0);
        this.rainbowForest.biomeIncidences().set(3);
        this.skyland.biomeIncidences().set(0);
    }

    public File configFile(File source) {
        File directory = source.getParentFile();
        File highlands = new File(directory, "Highlands");
        File generalConfig = new File(highlands, "General.cfg");
        return generalConfig;
    }

    public void setNativeBiomeIDs(File configDirectory) {
        try {
            NativeChromaticraftSettings nativeSettings = this.nativeIDs(configDirectory);
            this.enderForest.biomeID().set(nativeSettings.EnderForestID.value());
            this.island.biomeID().set(nativeSettings.IslandID.value());
            this.plains.biomeID().set(nativeSettings.PlainsID.value());
            this.skyland.biomeID().set(nativeSettings.SkylandID.value());
            this.rainbowForest.biomeID().set(nativeSettings.RainbowForestID.value());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void setRules(ClimateControlRules rules) {
    }

    public void onNewWorld() {
        this.biomesFromConfig.set(this.biomesInNewWorlds);
    }

    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }

    private NativeChromaticraftSettings nativeIDs(File configDirectory) {
        NativeChromaticraftSettings result = new NativeChromaticraftSettings();
        File reikaDirectory = new File(configDirectory, "Reika");
        File configFile = new File(reikaDirectory, "ChromatiCraft.cfg");
        result.readFrom(new Configuration(configFile));
        return result;
    }
}

