/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.api.IslandClimateMaker;
import climateControl.genLayerPack.GenLayerPack;
import climateControl.utils.IntRandomizer;
import climateControl.utils.Numbered;
import climateControl.utils.PlaneLocation;
import climateControl.utils.RandomIntUser;
import climateControl.utils.Zeno410Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenLayerOceanicIslands
extends GenLayerPack {
    public static final Logger logger = new Zeno410Logger("OceanicIslands").logger();
    private final IntRandomizer passer = new IntRandomizer(){

        public int nextInt(int range) {
            return GenLayerOceanicIslands.this.func_75902_a(range);
        }
    };
    private final boolean suppressDiagonals;
    private final int milleFill;
    private final IslandClimateMaker island;
    private final String layerName;

    private GenLayerOceanicIslands(long p_i45480_1_, GenLayer p_i45480_3_, int milleFill, final int islandValue, boolean suppressDiagonals, String layerName) {
        super(p_i45480_1_);
        this.field_75909_a = p_i45480_3_;
        this.milleFill = milleFill;
        this.island = new IslandClimateMaker(){

            public int climate(int x, int z, IntRandomizer randomizer) {
                return islandValue;
            }
        };
        this.suppressDiagonals = suppressDiagonals;
        this.layerName = layerName;
    }

    public GenLayerOceanicIslands(long p_i45480_1_, GenLayer p_i45480_3_, int milleFill, final RandomIntUser island, boolean suppressDiagonals, String layerName) {
        super(p_i45480_1_);
        this.field_75909_a = p_i45480_3_;
        this.milleFill = milleFill;
        this.island = new IslandClimateMaker(){

            public int climate(int x, int z, IntRandomizer randomizer) {
                return island.value(randomizer);
            }
        };
        this.suppressDiagonals = suppressDiagonals;
        this.layerName = layerName;
    }

    public GenLayerOceanicIslands(long p_i45480_1_, GenLayer p_i45480_3_, int milleFill, IslandClimateMaker island, boolean suppressDiagonals, String layerName) {
        super(p_i45480_1_);
        this.field_75909_a = p_i45480_3_;
        this.milleFill = milleFill;
        this.island = island;
        this.suppressDiagonals = suppressDiagonals;
        this.layerName = layerName;
    }

    @Override
    public int[] func_75904_a(int par1, int par2, int par3, int par4) {
        if (this.suppressDiagonals) {
            return this.getSeparatedIslands(par1, par2, par3, par4);
        }
        int i1 = par1 - 1;
        int j1 = par2 - 1;
        int k1 = par3 + 2;
        int l1 = par4 + 2;
        int[] aint = this.field_75909_a.func_75904_a(i1, j1, k1, l1);
        int[] aint1 = IntCache.func_76445_a((int)(par3 * par4));
        for (int i2 = 0; i2 < par4; ++i2) {
            for (int j2 = 0; j2 < par3; ++j2) {
                int k3;
                int k2 = aint[j2 + 1 + (i2 + 1 - 1) * (par3 + 2)];
                int l2 = aint[j2 + 1 + 1 + (i2 + 1) * (par3 + 2)];
                int i3 = aint[j2 + 1 - 1 + (i2 + 1) * (par3 + 2)];
                int j3 = aint[j2 + 1 + (i2 + 1 + 1) * (par3 + 2)];
                aint1[j2 + i2 * par3] = k3 = aint[j2 + 1 + (i2 + 1) * k1];
                if (!GenLayerOceanicIslands.isOceanic(k3) || !GenLayerOceanicIslands.isOceanic(k2) || !GenLayerOceanicIslands.isOceanic(l2) || !GenLayerOceanicIslands.isOceanic(i3) || !GenLayerOceanicIslands.isOceanic(j3)) continue;
                if (this.suppressDiagonals) {
                    int upperLeft = aint[j2 + i2 * (par3 + 2)];
                    int upperRight = aint[j2 + 2 + i2 * (par3 + 2)];
                    int lowerLeft = aint[j2 + (i2 + 2) * (par3 + 2)];
                    int lowerRight = aint[j2 + 2 + (i2 + 2) * (par3 + 2)];
                    if (!GenLayerOceanicIslands.isOceanic(upperLeft) || !GenLayerOceanicIslands.isOceanic(upperRight) || !GenLayerOceanicIslands.isOceanic(lowerLeft) || !GenLayerOceanicIslands.isOceanic(lowerRight)) continue;
                }
                this.func_75903_a(j2 + par1, i2 + par2);
                if (this.func_75902_a(1000) >= this.milleFill) continue;
                aint1[j2 + i2 * par3] = this.island.climate(j2 + par1, i2 + par2, this.passer);
            }
        }
        return aint1;
    }

    /*
     * WARNING - void declaration
     */
    public int[] getSeparatedIslands(int par1, int par2, int par3, int par4) {
        void var13_18;
        int j2;
        ArrayList<Numbered<LocatedInt>> newIslands = new ArrayList<Numbered<LocatedInt>>();
        int i1 = par1 - 2;
        int j1 = par2 - 2;
        int parentXSize = par3 + 4;
        int l1 = par4 + 4;
        int[] parentVals = this.field_75909_a.func_75904_a(i1, j1, parentXSize, l1);
        int[] changed = new int[parentVals.length];
        for (int i = 0; i < parentVals.length; ++i) {
            changed[i] = parentVals[i];
        }
        for (int i2 = 1; i2 < par4 + 3; ++i2) {
            for (int i = 1; i < par3 + 3; ++i) {
                int k2 = parentVals[i + (i2 - 1) * parentXSize];
                int l2 = parentVals[i + 1 + i2 * parentXSize];
                int i3 = parentVals[i - 1 + i2 * parentXSize];
                int j3 = parentVals[i + (i2 + 1) * parentXSize];
                int k3 = parentVals[i + i2 * parentXSize];
                if (!GenLayerOceanicIslands.isOceanic(k3) || !GenLayerOceanicIslands.isOceanic(k2) || !GenLayerOceanicIslands.isOceanic(l2) || !GenLayerOceanicIslands.isOceanic(i3) || !GenLayerOceanicIslands.isOceanic(j3)) continue;
                if (this.suppressDiagonals) {
                    int upperLeft = parentVals[i - 1 + (i2 - 1) * parentXSize];
                    int upperRight = parentVals[i + 1 + (i2 - 1) * parentXSize];
                    int lowerLeft = parentVals[i - 1 + (i2 + 1) * parentXSize];
                    int lowerRight = parentVals[i + 1 + (i2 + 1) * parentXSize];
                    if (!GenLayerOceanicIslands.isOceanic(upperLeft) || !GenLayerOceanicIslands.isOceanic(upperRight) || !GenLayerOceanicIslands.isOceanic(lowerLeft) || !GenLayerOceanicIslands.isOceanic(lowerRight)) continue;
                }
                this.func_75903_a(i + par1, i2 + par2);
                if (this.func_75902_a(1000) >= this.milleFill) continue;
                LocatedInt toAdd = new LocatedInt(new PlaneLocation(i, i2), this.island.climate(i + par1, i2 + par2, this.passer));
                newIslands.add(new Numbered<LocatedInt>(this.passer.nextInt(Integer.MAX_VALUE), toAdd));
            }
        }
        Collections.sort(newIslands, Numbered.comparator(GenLayerOceanicIslands.locatedIntComparator()));
        for (Numbered numbered : newIslands) {
            j2 = ((LocatedInt)numbered.item()).location.x();
            int i2 = ((LocatedInt)numbered.item()).location.z();
            changed[j2 + i2 * parentXSize] = ((LocatedInt)numbered.item()).climate;
            this.revertNonOcean(j2 + (i2 - 1) * parentXSize, parentVals, changed);
            this.revertNonOcean(j2 + 1 + i2 * parentXSize, parentVals, changed);
            this.revertNonOcean(j2 - 1 + i2 * parentXSize, parentVals, changed);
            this.revertNonOcean(j2 + (i2 + 1) * parentXSize, parentVals, changed);
            if (!this.suppressDiagonals) continue;
            this.revertNonOcean(j2 - 1 + (i2 - 1) * parentXSize, parentVals, changed);
            this.revertNonOcean(j2 + 1 + (i2 - 1) * parentXSize, parentVals, changed);
            this.revertNonOcean(j2 - 1 + (i2 + 1) * parentXSize, parentVals, changed);
            this.revertNonOcean(j2 + 1 + (i2 + 1) * parentXSize, parentVals, changed);
        }
        int[] aint1 = new int[par3 * par4];
        int n = 2;
        while (var13_18 < par4 + 2) {
            for (j2 = 2; j2 < par3 + 2; ++j2) {
                int k3;
                aint1[j2 - 2 + (var13_18 - 2) * par3] = k3 = changed[j2 + var13_18 * parentXSize];
                if (k3 <= 0) continue;
            }
            ++var13_18;
        }
        return aint1;
    }

    private final void revertNonOcean(int location, int[] original, int[] changed) {
        if (!GenLayerOceanicIslands.isOceanic(changed[location])) {
            changed[location] = original[location];
        }
    }

    private static Comparator<LocatedInt> locatedIntComparator() {
        return new Comparator<LocatedInt>(){

            @Override
            public int compare(LocatedInt arg0, LocatedInt arg1) {
                if (arg0.location.x() != arg1.location.x()) {
                    return arg0.location.x() - arg1.location.x();
                }
                return arg0.location.z() - arg1.location.z();
            }
        };
    }

    private class LocatedInt {
        final PlaneLocation location;
        final int climate;

        LocatedInt(PlaneLocation location, int climate) {
            this.location = location;
            this.climate = climate;
        }
    }
}

