/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.LockGenLayers;
import climateControl.api.ClimateControlSettings;
import climateControl.customGenLayer.GenLayerConstant;
import climateControl.customGenLayer.GenLayerLowlandRiverMix;
import climateControl.utils.Accessor;
import climateControl.utils.Zeno410Logger;
import java.util.logging.Logger;
import net.minecraft.world.World;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;

public class GenLayerRiverMixWrapper
extends GenLayerRiverMix {
    public static Logger logger = new Zeno410Logger("GenLayerRiverMixWrapper").logger();
    private LockableRiverMix redirect;
    private GenLayer voronoi;
    private LockableRiverMix original;
    private Accessor<GenLayerRiverMix, GenLayer> riverMixBiome = new Accessor("field_75910_b");
    private LockGenLayers biomeLocker = new LockGenLayers();

    private static GenLayer dummyGenLayer() {
        return new GenLayer(0L){

            public int[] func_75904_a(int var1, int var2, int var3, int var4) {
                return new int[var3 * var4];
            }
        };
    }

    public GenLayerRiverMixWrapper(long baseSeed) {
        super(baseSeed, GenLayerRiverMixWrapper.dummyGenLayer(), GenLayerRiverMixWrapper.dummyGenLayer());
        this.voronoi = new GenLayerVoronoiZoom(baseSeed, (GenLayer)this);
    }

    public void setOriginal(GenLayer target) {
        if (this.original == null) {
            this.redirect = this.original = new LockableRiverMix(new GenLayerConstant(0L));
        }
    }

    public void useOriginal() {
        if (this.redirect != this.original) {
            this.redirect = this.original;
            logger.info("using original " + this.original.toString());
            return;
        }
        logger.info("already using original ");
    }

    public void setRedirection(GenLayerRiverMix target) {
        if (this.locked()) {
            logger.info("already locked prior to " + target.toString());
            return;
        }
        logger.info("redirecting to " + target.toString());
        this.redirect = new LockableRiverMix((GenLayer)target);
        logger.info("redirected");
    }

    public int[] func_75904_a(int arg0, int arg1, int arg2, int arg3) {
        return this.redirect.generator.func_75904_a(arg0, arg1, arg2, arg3);
    }

    public void func_75903_a(long par1, long par3) {
        super.func_75903_a(par1, par3);
        this.redirect.generator.func_75903_a(par1, par3);
    }

    public void func_75905_a(long arg0) {
        super.func_75905_a(arg0);
        this.redirect.generator.func_75905_a(arg0);
    }

    public void clearRedirection() {
        this.redirect = null;
    }

    public void lock(int dimension, World world, ClimateControlSettings newSettings) {
        this.redirect.lock(dimension, world, newSettings);
    }

    public boolean locked() {
        if (this.redirect == null) {
            return false;
        }
        return this.redirect.locked;
    }

    public GenLayer voronoi() {
        return this.voronoi;
    }

    public GenLayer[] modifiedGenerators() {
        return new GenLayer[]{this, this.voronoi, this};
    }

    private class LockableRiverMix {
        boolean locked = false;
        private final GenLayer generator;

        LockableRiverMix(GenLayer generator) {
            this.generator = generator;
            logger.info("created");
        }

        void lock(int dimension, World world, ClimateControlSettings newSettings) {
            if (this.locked) {
                return;
            }
            try {
                GenLayerRiverMixWrapper.this.biomeLocker.lock(this.forLocking(), dimension, world, newSettings);
                this.locked = true;
            }
            catch (Unlockable ex) {
                // empty catch block
            }
        }

        public GenLayer forLocking() throws Unlockable {
            if (this.generator instanceof GenLayerLowlandRiverMix) {
                return ((GenLayerLowlandRiverMix)this.generator).forLocking();
            }
            if (this.generator instanceof GenLayerRiverMix) {
                return (GenLayer)GenLayerRiverMixWrapper.this.riverMixBiome.get((GenLayerRiverMix)this.generator);
            }
            throw new Unlockable();
        }
    }

    private class Unlockable
    extends Exception {
        private Unlockable() {
        }
    }
}

