/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.ClimateControl;
import climateControl.utils.Accessor;
import exterminatorJeff.undergroundBiomes.worldGen.ChunkProviderWrapper;
import java.lang.reflect.Field;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.MapGenVillage;

public class ChunkGeneratorExtractor {
    private AccessChunkProviderServer accessChunkProviderServer = new AccessChunkProviderServer();
    private Accessor<ChunkProviderServer, IChunkProvider> providerFromChunkServer = new Accessor("field_73246_d");
    private Accessor<ChunkProviderGenerate, MapGenVillage> villageGeneratorFromVillage = new Accessor("field_73224_v");

    public IChunkProvider extractFrom(WorldServer world) {
        ChunkProviderServer server = this.accessChunkProviderServer.chunkProviderServer(world);
        IChunkProvider provider = this.providerFromChunkServer.get(server);
        if (!(provider instanceof ChunkProviderGenerate) && provider instanceof ChunkProviderWrapper) {
            provider = ((ChunkProviderWrapper)provider).wrappee();
        }
        if (provider instanceof ChunkProviderGenerate) {
            return (ChunkProviderGenerate)provider;
        }
        if (ClimateControl.testing) {
            throw new RuntimeException();
        }
        return provider;
    }

    public void impose(WorldServer world, MapGenVillage mapGen) {
        IChunkProvider provider = this.extractFrom(world);
        if (provider instanceof ChunkProviderGenerate) {
            this.villageGeneratorFromVillage.setField((ChunkProviderGenerate)provider, mapGen);
        }
    }

    static class AccessChunkProviderServer {
        Field iChunkProviderServerField;

        AccessChunkProviderServer() {
            try {
                this.setIChunkProviderField();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private void setIChunkProviderField() throws IllegalAccessException {
            Field[] fields = WorldServer.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().contains("field_73059_b")) continue;
                this.iChunkProviderServerField = fields[i];
                this.iChunkProviderServerField.setAccessible(true);
            }
        }

        public ChunkProviderServer chunkProviderServer(WorldServer world) {
            try {
                return (ChunkProviderServer)this.iChunkProviderServerField.get(world);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void setIChunkProvider(WorldServer world, ChunkProviderServer chunkProvider) {
            try {
                this.iChunkProviderServerField.set(world, chunkProvider);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

