/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.utils.PlaneLocation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.world.chunk.storage.RegionFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkLister {
    private Map<String, Boolean> markedSafe;

    public ArrayList<PlaneLocation> savedChunks(String levelPathString) {
        String[] files;
        ArrayList<PlaneLocation> result = new ArrayList<PlaneLocation>();
        ArrayList<RegionFileInfo> regionFileInfos = new ArrayList<RegionFileInfo>();
        File levelPath = new File(levelPathString, "region");
        if (!levelPath.exists()) {
            System.out.println("This path does not exist: " + levelPath.getAbsolutePath());
        }
        if ((files = levelPath.list()) != null) {
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                File filePath = new File(levelPath.toString(), files[i]);
                if (!filePath.isFile() || !filePath.toString().endsWith("mca")) continue;
                String[] fileNameParts = fileName.split("\\.");
                int regionX = Integer.parseInt(fileNameParts[1]);
                int regionZ = Integer.parseInt(fileNameParts[2]);
                RegionFileInfo info = new RegionFileInfo(filePath, regionX, regionZ);
                regionFileInfos.add(info);
            }
        }
        System.out.println("-----------------------------------");
        for (RegionFileInfo info : regionFileInfos) {
            result.addAll(info.savedChunks());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegionFileInfo {
        public File filePath;
        public int regionX;
        public int regionZ;

        public RegionFileInfo(File filePath, int regionX, int regionZ) {
            this.filePath = filePath;
            this.regionX = regionX;
            this.regionZ = regionZ;
        }

        ArrayList<PlaneLocation> savedChunks() {
            ArrayList<PlaneLocation> result = new ArrayList<PlaneLocation>();
            RegionFile regionFile = new RegionFile(this.filePath);
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    if (!regionFile.func_76709_c(x, z)) continue;
                    int chunkX = this.regionX * 32 + x;
                    int chunkZ = this.regionZ * 32 + z;
                    result.add(new PlaneLocation(chunkX, chunkZ));
                }
            }
            try {
                regionFile.func_76708_c();
            }
            catch (IOException ex) {
                Logger.getLogger(ChunkLister.class.getName()).log(Level.SEVERE, null, ex);
            }
            return result;
        }
    }
}

