/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.utils.Acceptor;
import climateControl.utils.Trackable;
import climateControl.utils.Trackers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Mutable<Type>
extends Trackable<Type> {
    public void set(Type var1);

    public void set(Mutable<Type> var1);

    public Type value();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Concrete<CType>
    implements Mutable<CType> {
        private CType type;
        private Trackers<CType> trackers = new Trackers();

        public Concrete(CType initial) {
            this.type = initial;
        }

        @Override
        public void set(CType newValue) {
            if (this.type == null && newValue != null || !this.type.equals(this.value())) {
                this.type = newValue;
                this.trackers.update(newValue);
            }
        }

        @Override
        public void set(Mutable<CType> toCopy) {
            this.set(toCopy.value());
        }

        @Override
        public CType value() {
            return this.type;
        }

        @Override
        public void informOnChange(Acceptor<CType> target) {
            this.trackers.informOnChange(target);
        }

        @Override
        public void stopInforming(Acceptor<CType> target) {
            this.trackers.stopInforming(target);
        }
    }
}

