/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.utils.Acceptor;
import climateControl.utils.PlaneLocation;
import climateControl.utils.SelfTrackable;
import climateControl.utils.Streamer;
import climateControl.utils.Trackers;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaneLocated<Type>
implements SelfTrackable<PlaneLocated<Type>> {
    private HashMap<PlaneLocation, Type> storedVals = new HashMap();
    private Trackers<PlaneLocated<Type>> trackers = new Trackers();

    public final Type get(PlaneLocation location) {
        return this.storedVals.get(location);
    }

    public final void put(PlaneLocation location, Type stored) {
        this.storedVals.put(location, stored);
        this.trackers.update(this);
    }

    public final void putAll(HashMap<PlaneLocation, Type> newValues) {
        for (PlaneLocation location : newValues.keySet()) {
            this.storedVals.put(location, newValues.get(location));
        }
        this.trackers.update(this);
    }

    public final void remove(PlaneLocation location) {
        this.storedVals.remove(location);
        this.trackers.update(this);
    }

    public boolean confirm(PlaneLocation location, Type value) {
        Type existing = this.storedVals.get(location);
        if (existing == null) {
            this.storedVals.put(location, value);
        } else if (!existing.equals(value)) {
            return false;
        }
        return true;
    }

    public int size() {
        return this.storedVals.size();
    }

    public Set<PlaneLocation> locations() {
        return this.storedVals.keySet();
    }

    public static <StoredType> Streamer<PlaneLocated<StoredType>> streamer(Streamer<StoredType> typeStreamer) {
        return new PlaneLocatedStreamer<StoredType>(typeStreamer);
    }

    @Override
    public void informOnChange(Acceptor<PlaneLocated<Type>> target) {
        this.trackers.informOnChange(target);
    }

    @Override
    public void stopInforming(Acceptor<PlaneLocated<Type>> target) {
        this.trackers.stopInforming(target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlaneLocatedStreamer<StoredType>
    extends Streamer<PlaneLocated<StoredType>> {
        private final Streamer<StoredType> storedStreamer;

        PlaneLocatedStreamer(Streamer<StoredType> storedStreamer) {
            this.storedStreamer = storedStreamer;
        }

        @Override
        public PlaneLocated<StoredType> readFrom(DataInput input) throws IOException {
            PlaneLocated result = new PlaneLocated();
            int entries = input.readInt();
            for (int entry = 0; entry < entries; ++entry) {
                int x = input.readInt();
                int z = input.readInt();
                result.storedVals.put(new PlaneLocation(x, z), this.storedStreamer.readFrom(input));
            }
            return result;
        }

        @Override
        public void writeTo(PlaneLocated<StoredType> written, DataOutput output) throws IOException {
            output.writeInt(((PlaneLocated)written).storedVals.size());
            for (PlaneLocation location : ((PlaneLocated)written).storedVals.keySet()) {
                output.writeInt(location.x());
                output.writeInt(location.z());
                this.storedStreamer.writeTo(((PlaneLocated)written).storedVals.get(location), output);
            }
        }
    }
}

