/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.api.BiomeSettings;
import climateControl.utils.Named;
import climateControl.utils.Settings;
import climateControl.utils.Zeno410Logger;
import java.io.File;
import java.util.logging.Logger;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedConfigManager<Type extends Settings> {
    private final String modConfigName;
    private final String groupDirectoryName;
    public static final String worldSpecificConfigFileName = "worldSpecificConfig";
    public static Logger logger = new Zeno410Logger("TaggedConfigManager").logger();

    public TaggedConfigManager(String generalConfigName, String groupDirectoryName) {
        this.modConfigName = generalConfigName;
        this.groupDirectoryName = groupDirectoryName;
    }

    public void updateConfig(Named<Type> namedSettings, File generalDirectory, File specificDirectory) {
        Settings settings = (Settings)namedSettings.object;
        File generalModFile = new File(generalDirectory, this.modConfigName);
        File generalAddOnDirectory = new File(generalDirectory, this.groupDirectoryName);
        if (!generalAddOnDirectory.exists()) {
            generalAddOnDirectory.mkdir();
        }
        File generalAddonFile = new File(generalAddOnDirectory, namedSettings.name);
        this.readConfigs(generalModFile, generalAddonFile, settings, generalDirectory, true);
        try {
            BiomeSettings biomeSettings = (BiomeSettings)settings;
            biomeSettings.setNativeBiomeIDs(generalDirectory);
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        File specificModFile = new File(specificDirectory, this.modConfigName);
        File specificAddOnDirectory = new File(specificDirectory, this.groupDirectoryName);
        if (!specificAddOnDirectory.exists()) {
            specificAddOnDirectory.mkdir();
        }
        if (!specificAddOnDirectory.exists()) {
            throw new RuntimeException(specificAddOnDirectory.getAbsolutePath());
        }
        File specificAddonFile = new File(specificAddOnDirectory, namedSettings.name);
        this.readConfigs(specificModFile, specificAddonFile, settings, generalDirectory, false);
    }

    public void initializeConfig(Named<Type> namedSettings, File generalDirectory) {
        Settings settings = (Settings)namedSettings.object;
        File generalModFile = new File(generalDirectory, this.modConfigName);
        File generalAddOnDirectory = new File(generalDirectory, this.groupDirectoryName);
        File generalAddonFile = new File(generalAddOnDirectory, namedSettings.name);
        this.readConfigs(generalModFile, generalAddonFile, settings, generalDirectory, true);
        try {
            BiomeSettings biomeSettings = (BiomeSettings)settings;
            Configuration sample = new Configuration(generalAddonFile);
            biomeSettings.stripIDsFrom(sample);
            sample.save();
            biomeSettings.setNativeBiomeIDs(generalDirectory);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    private void readConfigs(File generalFile, File specificFile, Settings settings, File generalDirectory, boolean isGeneral) {
        Configuration specific = null;
        try {
            settings.readForeignConfigs(generalDirectory);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (specificFile.exists()) {
            specific = new Configuration(specificFile);
            settings.readFrom(specific);
        } else {
            if (generalFile.exists()) {
                Configuration general = new Configuration(generalFile);
                settings.readForeignConfigs(generalDirectory);
                try {
                    BiomeSettings biomeSettings = (BiomeSettings)settings;
                    biomeSettings.setNativeBiomeIDs(generalDirectory);
                }
                catch (ClassCastException ex) {
                    // empty catch block
                }
                general.save();
            }
            specific = new Configuration(specificFile);
            settings.copyTo(specific);
        }
        settings.copyTo(specific);
        try {
            BiomeSettings biomeSettings = (BiomeSettings)settings;
            if (isGeneral) {
                biomeSettings.stripIDsFrom(specific);
            }
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        specific.save();
    }

    public void saveConfigs(File generalDirectory, File specificDirectory, Named<Settings> namedSettings) {
        File specificModFile = new File(specificDirectory, this.modConfigName);
        Configuration general = new Configuration(specificModFile);
        try {
            BiomeSettings biomeSettings = (BiomeSettings)namedSettings.object;
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        general.save();
        File specificAddOnDirectory = new File(specificDirectory, this.groupDirectoryName);
        if (!specificAddOnDirectory.exists()) {
            specificAddOnDirectory.mkdir();
        }
        if (!specificAddOnDirectory.exists()) {
            throw new RuntimeException(specificAddOnDirectory.getAbsolutePath());
        }
        File specificAddonFile = new File(specificAddOnDirectory, namedSettings.name);
        Configuration specific = new Configuration(specificAddonFile);
        ((Settings)namedSettings.object).copyTo(specific);
        try {
            BiomeSettings biomeSettings = (BiomeSettings)namedSettings.object;
            biomeSettings.setNativeBiomeIDs(generalDirectory);
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        specific.save();
    }

    private boolean usable(File tested) {
        return tested != null;
    }

    public void updateConfig(Named<Type> namedSettings, File generalDirectory, WorldServer server) {
        File configDirectory = new File(server.getChunkSaveLocation(), worldSpecificConfigFileName);
        configDirectory.mkdir();
        this.updateConfig(namedSettings, generalDirectory, configDirectory);
    }
}

