/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.LoadingPlugin;
import cofh.asm.relauncher.Implementable;
import cofh.asm.relauncher.Strippable;
import cofh.asm.relauncher.Substitutable;
import cofh.mod.updater.ModRange;
import cofh.mod.updater.ModVersion;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import gnu.trove.map.hash.TObjectByteHashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMCore {
    static Logger log = LogManager.getLogger((String)"CoFH ASM");
    static TObjectByteHashMap<String> hashes = new TObjectByteHashMap(30, 1.0f, 0);
    static THashSet<String> parsables;
    static THashSet<String> implementables;
    static THashSet<String> strippables;
    static THashSet<String> substitutables;
    static final String implementableDesc;
    static final String strippableDesc;
    static final String substitutableDesc;
    static String side;
    static final ArrayList<String> workingPath;
    private static final String[] emptyList;
    private static boolean gameLoaded;
    private static Map<String, ModContainer> mods;
    private static Map<String, ModContainer> apis;

    static void init() {
    }

    static byte[] parse(String name, String transformedName, byte[] bytes) {
        ClassWriter cw;
        ClassNode cn;
        ClassReader cr;
        workingPath.add(transformedName);
        if (implementables.contains((Object)name)) {
            log.debug("Adding runtime interfaces to " + transformedName);
            cr = new ClassReader(bytes);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (ASMCore.implement(cn)) {
                cw = new ClassWriter(0);
                cn.accept((ClassVisitor)cw);
                bytes = cw.toByteArray();
            } else {
                log.debug("Nothing implemented on " + transformedName);
            }
        }
        if (substitutables.contains((Object)name)) {
            log.debug("Substituting methods from " + transformedName);
            cr = new ClassReader(bytes);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (ASMCore.substitute(cn)) {
                cw = new ClassWriter(0);
                cn.accept((ClassVisitor)cw);
                bytes = cw.toByteArray();
            } else {
                log.debug("Nothing substituted from " + transformedName);
            }
        }
        if (strippables.contains((Object)name)) {
            log.debug("Stripping methods and fields from " + transformedName);
            cr = new ClassReader(bytes);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (ASMCore.strip(cn)) {
                cw = new ClassWriter(0);
                cn.accept((ClassVisitor)cw);
                bytes = cw.toByteArray();
            } else {
                log.debug("Nothing stripped from " + transformedName);
            }
        }
        workingPath.remove(workingPath.size() - 1);
        return bytes;
    }

    static byte[] transform(int index, String name, String transformedName, byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        switch (index) {
            case 1: {
                return ASMCore.writeWorldServer(transformedName, bytes, cr);
            }
            case 2: {
                return ASMCore.writeWorld(transformedName, bytes, cr);
            }
            case 3: {
                return ASMCore.writeWorldProxy(name, bytes, cr);
            }
            case 4: {
                return ASMCore.writeWorldServerProxy(name, bytes, cr);
            }
            case 5: {
                return ASMCore.alterBlockPane(transformedName, bytes, cr);
            }
            case 6: {
                return ASMCore.alterBlock(transformedName, bytes, cr);
            }
            case 7: {
                return ASMCore.alterController(transformedName, bytes, cr);
            }
            case 8: {
                return ASMCore.alterLongHashMap(transformedName, bytes, cr);
            }
            case 9: {
                return ASMCore.alterChunk(transformedName, bytes, cr);
            }
            case 10: {
                return ASMCore.alterMinecraft(transformedName, bytes, cr);
            }
            case 11: {
                return ASMCore.alterRenderBlocks(transformedName, bytes, cr);
            }
            case 12: {
                return ASMCore.alterTileEntity(transformedName, bytes, cr);
            }
            case 13: {
                return ASMCore.alterContainer(transformedName, bytes, cr);
            }
            case 14: {
                return ASMCore.alterEntity(transformedName, bytes, cr);
            }
            case 15: {
                return ASMCore.alterEntityItem(transformedName, bytes, cr);
            }
            case 16: {
                return ASMCore.alterHooksCore(name, bytes, cr);
            }
            case 17: {
                return ASMCore.alterEnchantment(transformedName, bytes, cr);
            }
            case 18: {
                return ASMCore.alterItem(transformedName, bytes, cr);
            }
            case 19: {
                return ASMCore.alterKeyEntry(transformedName, bytes, cr);
            }
            case 20: {
                return ASMCore.alterKeyBinding(transformedName, bytes, cr);
            }
            case 21: {
                return ASMCore.alterGameRegistry(name, bytes, cr);
            }
            case 22: {
                return ASMCore.alterProfiler(transformedName, bytes, cr);
            }
        }
        return bytes;
    }

    private static byte[] alterGameRegistry(String name, byte[] bytes, ClassReader cr) {
        MethodNode n2;
        String names = "generateWorld";
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 0);
        MethodNode m = null;
        for (MethodNode n2 : cn.methods) {
            if (!names.equals(n2.name)) continue;
            m = n2;
            break;
        }
        if (m == null) {
            return bytes;
        }
        String sig = "(Lnet/minecraft/world/World;II)V";
        MethodNode methodNode = n2 = m.instructions.getFirst();
        n2 = new VarInsnNode(25, 2);
        m.instructions.insertBefore((AbstractInsnNode)methodNode, (AbstractInsnNode)n2);
        MethodNode methodNode2 = n2;
        n2 = new VarInsnNode(21, 0);
        m.instructions.insert((AbstractInsnNode)methodNode2, (AbstractInsnNode)n2);
        MethodNode methodNode3 = n2;
        n2 = new VarInsnNode(21, 1);
        m.instructions.insert((AbstractInsnNode)methodNode3, (AbstractInsnNode)n2);
        m.instructions.insert((AbstractInsnNode)n2, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asmhooks/HooksCore", "preGenerateWorld", "(Lnet/minecraft/world/World;II)V", false));
        for (n2 = m.instructions.getFirst(); n2 != null; n2 = n2.getNext()) {
            if (n2.getOpcode() != 177) continue;
            m.instructions.insertBefore((AbstractInsnNode)n2, (AbstractInsnNode)new VarInsnNode(25, 2));
            m.instructions.insertBefore((AbstractInsnNode)n2, (AbstractInsnNode)new VarInsnNode(21, 0));
            m.instructions.insertBefore((AbstractInsnNode)n2, (AbstractInsnNode)new VarInsnNode(21, 1));
            m.instructions.insertBefore((AbstractInsnNode)n2, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asmhooks/HooksCore", "postGenerateWorld", "(Lnet/minecraft/world/World;II)V", false));
        }
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterProfiler(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_76319_b", "func_76320_a", "func_76318_c", "func_76317_a"} : new String[]{"endSection", "startSection", "endStartSection", "clearProfiling"};
        name = name.replace('.', '/');
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 0);
        cn.fields.add(new FieldNode(4098, "cofh_stack", "Ljava/util/Deque;", null, null));
        cn.fields.add(new FieldNode(4098, "cofh_endStart", "Z", null, (Object)Boolean.FALSE));
        block0: for (MethodNode m : cn.methods) {
            VarInsnNode n;
            AbstractInsnNode n2;
            if ("<init>".equals(m.name)) {
                LabelNode a = new LabelNode(new Label());
                for (n2 = m.instructions.getFirst(); n2 != null && n2.getOpcode() != 183; n2 = n2.getNext()) {
                }
                AbstractInsnNode abstractInsnNode = n2;
                n2 = a;
                m.instructions.insert(abstractInsnNode, n2);
                AbstractInsnNode abstractInsnNode2 = n2;
                n2 = new LineNumberNode(-15000, a);
                m.instructions.insert(abstractInsnNode2, n2);
                AbstractInsnNode abstractInsnNode3 = n2;
                n2 = new VarInsnNode(25, 0);
                m.instructions.insert(abstractInsnNode3, n2);
                AbstractInsnNode abstractInsnNode4 = n2;
                n2 = new TypeInsnNode(187, "java/util/LinkedList");
                m.instructions.insert(abstractInsnNode4, n2);
                AbstractInsnNode abstractInsnNode5 = n2;
                n2 = new InsnNode(89);
                m.instructions.insert(abstractInsnNode5, n2);
                AbstractInsnNode abstractInsnNode6 = n2;
                n2 = new MethodInsnNode(183, "java/util/LinkedList", "<init>", "()V", false);
                m.instructions.insert(abstractInsnNode6, n2);
                AbstractInsnNode abstractInsnNode7 = n2;
                n2 = new FieldInsnNode(181, name, "cofh_stack", "Ljava/util/Deque;");
                m.instructions.insert(abstractInsnNode7, n2);
                continue;
            }
            if (names[0].equals(m.name)) {
                int c = 0;
                for (n2 = m.instructions.getFirst(); n2 != null; n2 = n2.getNext()) {
                    if (n2.getOpcode() != 25 || ++c <= 1) continue;
                    LabelNode lCond = new LabelNode(new Label());
                    LabelNode lGuard = new LabelNode(new Label());
                    AbstractInsnNode abstractInsnNode = n2;
                    n2 = new VarInsnNode(25, 0);
                    m.instructions.insertBefore(abstractInsnNode, n2);
                    AbstractInsnNode abstractInsnNode8 = n2;
                    n2 = new FieldInsnNode(180, name, "cofh_endStart", "Z");
                    m.instructions.insert(abstractInsnNode8, n2);
                    AbstractInsnNode abstractInsnNode9 = n2;
                    n2 = new JumpInsnNode(154, lGuard);
                    m.instructions.insert(abstractInsnNode9, n2);
                    AbstractInsnNode abstractInsnNode10 = n2;
                    n2 = new VarInsnNode(25, 0);
                    m.instructions.insert(abstractInsnNode10, n2);
                    AbstractInsnNode abstractInsnNode11 = n2;
                    n2 = new FieldInsnNode(180, name, "cofh_stack", "Ljava/util/Deque;");
                    m.instructions.insert(abstractInsnNode11, n2);
                    AbstractInsnNode abstractInsnNode12 = n2;
                    n2 = new MethodInsnNode(185, "java/util/Deque", "pop", "()Ljava/lang/Object;", true);
                    m.instructions.insert(abstractInsnNode12, n2);
                    AbstractInsnNode abstractInsnNode13 = n2;
                    n2 = new TypeInsnNode(192, "java/lang/Throwable");
                    m.instructions.insert(abstractInsnNode13, n2);
                    AbstractInsnNode abstractInsnNode14 = n2;
                    n2 = new InsnNode(89);
                    m.instructions.insert(abstractInsnNode14, n2);
                    AbstractInsnNode abstractInsnNode15 = n2;
                    n2 = new MethodInsnNode(182, "java/lang/Throwable", "getStackTrace", "()[Ljava/lang/StackTraceElement;", false);
                    m.instructions.insert(abstractInsnNode15, n2);
                    AbstractInsnNode abstractInsnNode16 = n2;
                    n2 = new InsnNode(190);
                    m.instructions.insert(abstractInsnNode16, n2);
                    AbstractInsnNode abstractInsnNode17 = n2;
                    n2 = new TypeInsnNode(187, "java/lang/Throwable");
                    m.instructions.insert(abstractInsnNode17, n2);
                    AbstractInsnNode abstractInsnNode18 = n2;
                    n2 = new InsnNode(89);
                    m.instructions.insert(abstractInsnNode18, n2);
                    AbstractInsnNode abstractInsnNode19 = n2;
                    n2 = new MethodInsnNode(183, "java/lang/Throwable", "<init>", "()V", false);
                    m.instructions.insert(abstractInsnNode19, n2);
                    AbstractInsnNode abstractInsnNode20 = n2;
                    n2 = new MethodInsnNode(182, "java/lang/Throwable", "getStackTrace", "()[Ljava/lang/StackTraceElement;", false);
                    m.instructions.insert(abstractInsnNode20, n2);
                    AbstractInsnNode abstractInsnNode21 = n2;
                    n2 = new InsnNode(190);
                    m.instructions.insert(abstractInsnNode21, n2);
                    AbstractInsnNode abstractInsnNode22 = n2;
                    n2 = new JumpInsnNode(164, lCond);
                    m.instructions.insert(abstractInsnNode22, n2);
                    AbstractInsnNode abstractInsnNode23 = n2;
                    n2 = new TypeInsnNode(187, "java/lang/Error");
                    m.instructions.insert(abstractInsnNode23, n2);
                    AbstractInsnNode abstractInsnNode24 = n2;
                    n2 = new InsnNode(89);
                    m.instructions.insert(abstractInsnNode24, n2);
                    AbstractInsnNode abstractInsnNode25 = n2;
                    n2 = new LdcInsnNode((Object)"Detected bad stack depth call to endSection");
                    m.instructions.insert(abstractInsnNode25, n2);
                    AbstractInsnNode abstractInsnNode26 = n2;
                    n2 = new MethodInsnNode(183, "java/lang/Error", "<init>", "(Ljava/lang/String;)V", false);
                    m.instructions.insert(abstractInsnNode26, n2);
                    AbstractInsnNode abstractInsnNode27 = n2;
                    n2 = new InsnNode(95);
                    m.instructions.insert(abstractInsnNode27, n2);
                    AbstractInsnNode abstractInsnNode28 = n2;
                    n2 = new MethodInsnNode(182, "java/lang/Throwable", "initCause", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", false);
                    m.instructions.insert(abstractInsnNode28, n2);
                    AbstractInsnNode abstractInsnNode29 = n2;
                    n2 = new InsnNode(191);
                    m.instructions.insert(abstractInsnNode29, n2);
                    AbstractInsnNode abstractInsnNode30 = n2;
                    n2 = new FrameNode(4, 0, null, 0, new Object[]{"java/lang/Throwable"});
                    m.instructions.insert(abstractInsnNode30, n2);
                    AbstractInsnNode abstractInsnNode31 = n2;
                    n2 = lCond;
                    m.instructions.insert(abstractInsnNode31, n2);
                    AbstractInsnNode abstractInsnNode32 = n2;
                    n2 = new InsnNode(87);
                    m.instructions.insert(abstractInsnNode32, n2);
                    AbstractInsnNode abstractInsnNode33 = n2;
                    n2 = new FrameNode(3, 0, null, 0, null);
                    m.instructions.insert(abstractInsnNode33, n2);
                    AbstractInsnNode abstractInsnNode34 = n2;
                    n2 = lGuard;
                    m.instructions.insert(abstractInsnNode34, n2);
                    continue block0;
                }
                continue;
            }
            if (names[1].equals(m.name)) {
                int c = 0;
                for (n2 = m.instructions.getFirst(); n2 != null; n2 = n2.getNext()) {
                    if (n2.getOpcode() != 25 || ++c <= 1) continue;
                    LabelNode lGuard = new LabelNode(new Label());
                    AbstractInsnNode abstractInsnNode = n2;
                    n2 = new VarInsnNode(25, 0);
                    m.instructions.insertBefore(abstractInsnNode, n2);
                    AbstractInsnNode abstractInsnNode35 = n2;
                    n2 = new FieldInsnNode(180, name, "cofh_endStart", "Z");
                    m.instructions.insert(abstractInsnNode35, n2);
                    AbstractInsnNode abstractInsnNode36 = n2;
                    n2 = new JumpInsnNode(154, lGuard);
                    m.instructions.insert(abstractInsnNode36, n2);
                    AbstractInsnNode abstractInsnNode37 = n2;
                    n2 = new VarInsnNode(25, 0);
                    m.instructions.insert(abstractInsnNode37, n2);
                    AbstractInsnNode abstractInsnNode38 = n2;
                    n2 = new FieldInsnNode(180, name, "cofh_stack", "Ljava/util/Deque;");
                    m.instructions.insert(abstractInsnNode38, n2);
                    AbstractInsnNode abstractInsnNode39 = n2;
                    n2 = new TypeInsnNode(187, "java/lang/Error");
                    m.instructions.insert(abstractInsnNode39, n2);
                    AbstractInsnNode abstractInsnNode40 = n2;
                    n2 = new InsnNode(89);
                    m.instructions.insert(abstractInsnNode40, n2);
                    AbstractInsnNode abstractInsnNode41 = n2;
                    n2 = new LdcInsnNode((Object)"Failed to call endSection after calling startSection");
                    m.instructions.insert(abstractInsnNode41, n2);
                    AbstractInsnNode abstractInsnNode42 = n2;
                    n2 = new MethodInsnNode(183, "java/lang/Error", "<init>", "(Ljava/lang/String;)V", false);
                    m.instructions.insert(abstractInsnNode42, n2);
                    AbstractInsnNode abstractInsnNode43 = n2;
                    n2 = new MethodInsnNode(185, "java/util/Deque", "push", "(Ljava/lang/Object;)V", true);
                    m.instructions.insert(abstractInsnNode43, n2);
                    AbstractInsnNode abstractInsnNode44 = n2;
                    n2 = new FrameNode(3, 0, null, 0, null);
                    m.instructions.insert(abstractInsnNode44, n2);
                    AbstractInsnNode abstractInsnNode45 = n2;
                    n2 = lGuard;
                    m.instructions.insert(abstractInsnNode45, n2);
                    continue block0;
                }
                continue;
            }
            if (names[2].equals(m.name)) {
                n = new VarInsnNode(25, 0);
                m.instructions.insertBefore(m.instructions.getFirst(), (AbstractInsnNode)n);
                VarInsnNode varInsnNode = n;
                n = new InsnNode(4);
                m.instructions.insert((AbstractInsnNode)varInsnNode, (AbstractInsnNode)n);
                VarInsnNode varInsnNode2 = n;
                n = new FieldInsnNode(181, name, "cofh_endStart", "Z");
                m.instructions.insert((AbstractInsnNode)varInsnNode2, (AbstractInsnNode)n);
                n = new VarInsnNode(25, 0);
                m.instructions.insertBefore(m.instructions.getLast(), (AbstractInsnNode)n);
                VarInsnNode varInsnNode3 = n;
                n = new InsnNode(3);
                m.instructions.insert((AbstractInsnNode)varInsnNode3, (AbstractInsnNode)n);
                VarInsnNode varInsnNode4 = n;
                n = new FieldInsnNode(181, name, "cofh_endStart", "Z");
                m.instructions.insert((AbstractInsnNode)varInsnNode4, (AbstractInsnNode)n);
                continue;
            }
            if (!names[3].equals(m.name)) continue;
            n = new VarInsnNode(25, 0);
            m.instructions.insertBefore(m.instructions.getFirst(), (AbstractInsnNode)n);
            VarInsnNode varInsnNode = n;
            n = new FieldInsnNode(180, name, "cofh_stack", "Ljava/util/Deque;");
            m.instructions.insert((AbstractInsnNode)varInsnNode, (AbstractInsnNode)n);
            VarInsnNode varInsnNode5 = n;
            n = new MethodInsnNode(185, "java/util/Deque", "clear", "()V", true);
            m.instructions.insert((AbstractInsnNode)varInsnNode5, (AbstractInsnNode)n);
        }
        ClassWriter cw = new ClassWriter(2);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static void saveTransformedClass(byte[] data, String transformedName) {
        File outFile = new File(new File("../decompClasses"), transformedName.replace('.', File.separatorChar) + ".class");
        File outDir = outFile.getParentFile();
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        try {
            FileOutputStream output = new FileOutputStream(outFile);
            output.write(data);
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static byte[] alterContainer(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_75135_a", "field_75151_b"} : new String[]{"mergeItemStack", "inventorySlots"};
        name = name.replace('.', '/');
        ClassNode cn = new ClassNode(262144);
        cr.accept((ClassVisitor)cn, 8);
        String sig = "(Lnet/minecraft/item/ItemStack;IIZ)Z";
        MethodNode m = null;
        for (MethodNode n : cn.methods) {
            if (!names[0].equals(n.name) || !"(Lnet/minecraft/item/ItemStack;IIZ)Z".equals(n.desc)) continue;
            m = n;
            break;
        }
        if (m == null) {
            return bytes;
        }
        m.instructions.clear();
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(180, name, names[1], "Ljava/util/List;"));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
        m.instructions.add((AbstractInsnNode)new InsnNode(3));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "cofh/lib/util/helpers/InventoryHelper", "mergeItemStack", "(Ljava/util/List;Lnet/minecraft/item/ItemStack;IIZZ)Z", false));
        m.instructions.add((AbstractInsnNode)new InsnNode(172));
        m.localVariables = null;
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterEnchantment(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_92089_a", "func_77973_b"} : new String[]{"canApply", "getItem"};
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        MethodNode m = null;
        for (MethodNode n : cn.methods) {
            if (!names[0].equals(n.name)) continue;
            m = n;
            break;
        }
        if (m == null) {
            return bytes;
        }
        AbstractInsnNode n = m.instructions.getFirst();
        LabelNode end = new LabelNode();
        LabelNode out = new LabelNode();
        AbstractInsnNode abstractInsnNode = n;
        n = new VarInsnNode(25, 1);
        m.instructions.insertBefore(abstractInsnNode, n);
        AbstractInsnNode abstractInsnNode2 = n;
        n = new MethodInsnNode(182, "net/minecraft/item/ItemStack", names[1], "()Lnet/minecraft/item/Item;", false);
        m.instructions.insert(abstractInsnNode2, n);
        AbstractInsnNode abstractInsnNode3 = n;
        n = new VarInsnNode(25, 1);
        m.instructions.insert(abstractInsnNode3, n);
        AbstractInsnNode abstractInsnNode4 = n;
        n = new VarInsnNode(25, 0);
        m.instructions.insert(abstractInsnNode4, n);
        AbstractInsnNode abstractInsnNode5 = n;
        n = new MethodInsnNode(182, "net/minecraft/item/Item", "cofh_canEnchantApply", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/enchantment/Enchantment;)I", false);
        m.instructions.insert(abstractInsnNode5, n);
        AbstractInsnNode abstractInsnNode6 = n;
        n = new InsnNode(89);
        m.instructions.insert(abstractInsnNode6, n);
        AbstractInsnNode abstractInsnNode7 = n;
        n = new JumpInsnNode(155, end);
        m.instructions.insert(abstractInsnNode7, n);
        AbstractInsnNode abstractInsnNode8 = n;
        n = new JumpInsnNode(153, out);
        m.instructions.insert(abstractInsnNode8, n);
        AbstractInsnNode abstractInsnNode9 = n;
        n = new InsnNode(4);
        m.instructions.insert(abstractInsnNode9, n);
        AbstractInsnNode abstractInsnNode10 = n;
        n = new InsnNode(172);
        m.instructions.insert(abstractInsnNode10, n);
        AbstractInsnNode abstractInsnNode11 = n;
        n = out;
        m.instructions.insert(abstractInsnNode11, n);
        AbstractInsnNode abstractInsnNode12 = n;
        n = new FrameNode(3, 0, null, 0, null);
        m.instructions.insert(abstractInsnNode12, n);
        AbstractInsnNode abstractInsnNode13 = n;
        n = new InsnNode(3);
        m.instructions.insert(abstractInsnNode13, n);
        AbstractInsnNode abstractInsnNode14 = n;
        n = new InsnNode(172);
        m.instructions.insert(abstractInsnNode14, n);
        AbstractInsnNode abstractInsnNode15 = n;
        n = end;
        m.instructions.insert(abstractInsnNode15, n);
        AbstractInsnNode abstractInsnNode16 = n;
        n = new FrameNode(4, 0, null, 0, new Object[]{Opcodes.INTEGER});
        m.instructions.insert(abstractInsnNode16, n);
        AbstractInsnNode abstractInsnNode17 = n;
        n = new InsnNode(87);
        m.instructions.insert(abstractInsnNode17, n);
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterItem(String name, byte[] bytes, ClassReader cr) {
        name = name.replace('.', '/');
        ClassWriter cw = new ClassWriter(0);
        cr.accept((ClassVisitor)cw, 0);
        String sig = "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/enchantment/Enchantment;)I";
        cw.newMethod(name, "cofh_canEnchantApply", sig, true);
        MethodVisitor mv = cw.visitMethod(4097, "cofh_canEnchantApply", sig, null, null);
        mv.visitCode();
        mv.visitInsn(2);
        mv.visitInsn(172);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        cw.visitEnd();
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterBlock(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_149671_p"} : new String[]{"registerBlocks"};
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        MethodNode m = null;
        for (MethodNode n : cn.methods) {
            if (!names[0].equals(n.name)) continue;
            m = n;
            break;
        }
        if (m == null) {
            return bytes;
        }
        for (AbstractInsnNode n = m.instructions.getFirst(); n != null; n = n.getNext()) {
            AbstractInsnNode p;
            if (n.getOpcode() != 187 || (p = n.getPrevious().getPrevious()).getOpcode() != 16) continue;
            TypeInsnNode node = (TypeInsnNode)n;
            switch (((IntInsnNode)p).operand) {
                case 8: {
                    node.desc = "cofh/asmhooks/block/BlockTickingWater";
                    break;
                }
                case 9: {
                    node.desc = "cofh/asmhooks/block/BlockWater";
                    break;
                }
                default: {
                    node = null;
                }
            }
            if (node == null) continue;
            ((MethodInsnNode)n.getNext().getNext().getNext()).owner = node.desc;
        }
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterEntityItem(String name, byte[] bytes, ClassReader cr) {
        return bytes;
    }

    private static byte[] alterEntity(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_70091_d", "func_72945_a", "func_70104_M"} : new String[]{"moveEntity", "getCollidingBoundingBoxes", "canBePushed"};
        name = name.replace('.', '/');
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        String mOwner = "net/minecraft/world/World";
        MethodNode m = null;
        for (MethodNode n : cn.methods) {
            if (!names[0].equals(n.name)) continue;
            m = n;
            break;
        }
        if (m == null) {
            return bytes;
        }
        int e = m.instructions.size();
        for (int i = 0; i < e; ++i) {
            AbstractInsnNode n = m.instructions.get(i);
            if (n.getOpcode() != 182) continue;
            MethodInsnNode mn = (MethodInsnNode)n;
            if (!mOwner.equals(mn.owner) || !names[1].equals(mn.name)) continue;
            mn.setOpcode(184);
            mn.owner = "cofh/asmhooks/HooksCore";
            mn.desc = "(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;";
            mn.name = "getEntityCollisionBoxes";
        }
        m = new MethodNode(1, "cofh_collideCheck", "()Z", null, null);
        cn.methods.add(m);
        m.instructions.insert((AbstractInsnNode)new InsnNode(172));
        m.instructions.insert((AbstractInsnNode)new MethodInsnNode(182, name, names[2], "()Z", false));
        m.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 0));
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterHooksCore(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_70104_M"} : new String[]{"canBePushed"};
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        MethodNode m = null;
        for (MethodNode n : cn.methods) {
            if (!"getEntityCollisionBoxes".equals(n.name)) continue;
            m = n;
            break;
        }
        int e = m.instructions.size();
        for (int i = 0; i < e; ++i) {
            AbstractInsnNode n = m.instructions.get(i);
            if (n.getOpcode() != 182) continue;
            MethodInsnNode mn = (MethodInsnNode)n;
            if (!names[0].equals(mn.name)) continue;
            mn.name = "cofh_collideCheck";
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterKeyEntry(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_148279_a", "func_151463_i"} : new String[]{"drawEntry", "getKeyCode"};
        name = name.replace('.', '/');
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        MethodNode m = null;
        for (MethodNode n : cn.methods) {
            if (!names[0].equals(n.name)) continue;
            m = n;
            break;
        }
        if (m != null) {
            int e = m.instructions.size();
            for (int i = 0; i < e; ++i) {
                AbstractInsnNode n = m.instructions.get(i);
                if (n.getOpcode() != 182 || n.getNext().getOpcode() != 153) continue;
                MethodInsnNode mn = (MethodInsnNode)n;
                if (!names[1].equals(mn.name)) continue;
                mn.name = "cofh_conflictCode";
            }
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            bytes = cw.toByteArray();
        }
        return bytes;
    }

    private static byte[] alterKeyBinding(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_148279_a", "func_151463_i"} : new String[]{"drawEntry", "getKeyCode"};
        name = name.replace('.', '/');
        ClassWriter cw = new ClassWriter(1);
        cr.accept((ClassVisitor)cw, 0);
        cw.newMethod(name, "cofh_conflictCode", "()I", true);
        MethodVisitor mv = cw.visitMethod(4097, "cofh_conflictCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "net/minecraft/client/settings/KeyBinding", names[1], "()I", false);
        mv.visitInsn(172);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        cw.visitEnd();
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterRenderBlocks(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_147733_k", "func_150098_a", "func_147439_a"} : new String[]{"renderBlockStainedGlassPane", "canPaneConnectToBlock", "getBlock"};
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        String sig = "(Lnet/minecraft/block/Block;III)Z";
        String Rsig = "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z";
        String Ssig = "(Lnet/minecraft/block/Block;)Z";
        String Csig = "(III)Lnet/minecraft/block/Block;";
        String cc = "net/minecraft/block/BlockPane";
        String fd = "net/minecraftforge/common/util/ForgeDirection";
        MethodNode m = null;
        for (MethodNode n : cn.methods) {
            if (!names[0].equals(n.name) || !"(Lnet/minecraft/block/Block;III)Z".equals(n.desc)) continue;
            m = n;
            break;
        }
        if (m == null) {
            return bytes;
        }
        m.localVariables = null;
        String[] dirs = new String[]{"NORTH", "NORTH", "SOUTH", "SOUTH", "WEST", "WEST", "EAST", "EAST"};
        int di = 0;
        int e = m.instructions.size();
        for (int i = 0; i < e; ++i) {
            AbstractInsnNode n = m.instructions.get(i);
            if (n.getType() != 5) continue;
            MethodInsnNode mn = (MethodInsnNode)n;
            if (n.getOpcode() != 185 || n.getNext().getOpcode() != 182 || !names[2].equals(mn.name) || !"(III)Lnet/minecraft/block/Block;".equals(mn.desc) || !"(Lnet/minecraft/block/Block;)Z".equals(((MethodInsnNode)mn.getNext()).desc)) continue;
            m.instructions.insertBefore(n, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/util/ForgeDirection", dirs[di++], "Lnet/minecraftforge/common/util/ForgeDirection;"));
            m.instructions.insertBefore(n, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/block/BlockPane", "canPaneConnectTo", "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z", false));
            m.instructions.remove(n.getNext());
            m.instructions.remove(n);
        }
        if (di == 0) {
            return bytes;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterBlockPane(String name, byte[] bytes, ClassReader cr) {
        String names = "canPaneConnectTo";
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        String sig = "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z";
        MethodNode m = null;
        for (MethodNode n : cn.methods) {
            if (!names.equals(n.name) || !"(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z".equals(n.desc)) continue;
            m = n;
            break;
        }
        if (m == null) {
            return bytes;
        }
        m.instructions.clear();
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 5));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "cofh/asmhooks/HooksCore", "paneConnectsTo", "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z", false));
        m.instructions.add((AbstractInsnNode)new InsnNode(172));
        m.localVariables = null;
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterMinecraft(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_71407_l", "func_110550_d"} : new String[]{"runTick", "tick"};
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        String mOwner = "net/minecraft/client/renderer/texture/TextureManager";
        boolean updated = false;
        block0: for (MethodNode m : cn.methods) {
            String mName = m.name;
            if (!names[0].equals(mName) || !"()V".equals(m.desc)) continue;
            updated = true;
            int e = m.instructions.size();
            for (int i = 0; i < e; ++i) {
                AbstractInsnNode n = m.instructions.get(i);
                if (n.getOpcode() != 182) continue;
                MethodInsnNode mn = (MethodInsnNode)n;
                if (!mOwner.equals(mn.owner) || !names[1].equals(mn.name) || !"()V".equals(mn.desc)) continue;
                m.instructions.set((AbstractInsnNode)mn, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asmhooks/HooksCore", "tickTextures", "(Lnet/minecraft/client/renderer/texture/ITickable;)V", false));
                break block0;
            }
        }
        if (!updated) {
            return bytes;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterChunk(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_150803_c", "field_76650_s"} : new String[]{"recheckGaps", "isGapLightingUpdated"};
        name = name.replace('.', '/');
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        boolean updated = false;
        block0: for (MethodNode m : cn.methods) {
            String mName = m.name;
            if (!names[0].equals(mName) || !"(Z)V".equals(m.desc)) continue;
            updated = true;
            int e = m.instructions.size();
            for (int i = 0; i < e; ++i) {
                AbstractInsnNode n = m.instructions.get(i);
                if (n.getOpcode() != 177) continue;
                m.instructions.insertBefore(n, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore(n, (AbstractInsnNode)new InsnNode(3));
                m.instructions.insertBefore(n, (AbstractInsnNode)new FieldInsnNode(181, name, names[1], "Z"));
                continue block0;
            }
        }
        if (!updated) {
            return bytes;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterLongHashMap(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_76155_g", "func_76160_c", "func_76161_b"} : new String[]{"getHashedKey", "getEntry", "containsItem"};
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 0);
        boolean updated = false;
        MethodNode getEntry = null;
        MethodNode containsItem = null;
        for (MethodNode m : cn.methods) {
            String mName = m.name;
            if (names[0].equals(mName) && "(J)I".equals(m.desc)) {
                updated = true;
                int e = m.instructions.size();
                for (int i = 0; i < e; ++i) {
                    AbstractInsnNode n = m.instructions.get(i);
                    if (n.getOpcode() != 131) continue;
                    m.instructions.insertBefore(n, (AbstractInsnNode)new LdcInsnNode((Object)new Long(13L)));
                    m.instructions.insertBefore(n, (AbstractInsnNode)new InsnNode(105));
                    break;
                }
                if (containsItem == null) continue;
                break;
            }
            if (!names[2].equals(mName) || !"(J)Z".equals(m.desc)) continue;
            containsItem = m;
            if (!updated) continue;
            break;
        }
        if (containsItem != null) {
            ClassNode clone = new ClassNode(327680);
            cr.accept((ClassVisitor)clone, 8);
            String sig = "(J)Lnet/minecraft/util/LongHashMap$Entry;";
            for (MethodNode m : clone.methods) {
                String mName = m.name;
                if (!names[1].equals(mName) || !sig.equals(m.desc)) continue;
                getEntry = m;
                break;
            }
            if (getEntry == null) {
                return bytes;
            }
            updated = true;
            containsItem.instructions.clear();
            containsItem.instructions.add(getEntry.instructions);
            for (AbstractInsnNode n = containsItem.instructions.get(0); n != null; n = n.getNext()) {
                if (n.getOpcode() != 176) continue;
                AbstractInsnNode n2 = n.getPrevious();
                if (n2.getOpcode() == 1) {
                    containsItem.instructions.set(n2, (AbstractInsnNode)new InsnNode(3));
                } else {
                    containsItem.instructions.set(n2, (AbstractInsnNode)new InsnNode(4));
                }
                AbstractInsnNode abstractInsnNode = n;
                n = new InsnNode(172);
                containsItem.instructions.set(abstractInsnNode, n);
            }
        }
        if (!updated) {
            return bytes;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] alterController(String name, byte[] bytes, ClassReader cr) {
        block7: {
            String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_85182_a", "field_85183_f"} : new String[]{"sameToolAndBlock", "currentItemHittingBlock"};
            name = name.replace('.', '/');
            ClassNode cn = new ClassNode(327680);
            cr.accept((ClassVisitor)cn, 0);
            String sig = "(III)Z";
            String itemstack = "net/minecraft/item/ItemStack";
            MethodNode m = null;
            for (MethodNode n : cn.methods) {
                if (!names[0].equals(n.name) || !"(III)Z".equals(n.desc)) continue;
                m = n;
                break;
            }
            if (m == null) {
                return bytes;
            }
            int e = m.instructions.size();
            for (int i = 0; i < e; ++i) {
                AbstractInsnNode n = m.instructions.get(i);
                if (n.getOpcode() != 182) continue;
                MethodInsnNode mn = (MethodInsnNode)n;
                if (!"net/minecraft/item/ItemStack".equals(mn.owner)) continue;
                LabelNode jmp = null;
                LabelNode jmp2 = null;
                block2: for (int j = i; j < e; ++j) {
                    int k;
                    n = m.instructions.get(j);
                    if (n.getOpcode() != 4) continue;
                    for (k = j; k > i; --k) {
                        n = m.instructions.get(k);
                        if (n.getType() != 8) continue;
                        jmp = (LabelNode)n;
                        break;
                    }
                    for (k = j; k < e; ++k) {
                        n = m.instructions.get(k);
                        if (n.getType() != 8) continue;
                        jmp2 = (LabelNode)n;
                        break block2;
                    }
                }
                if (jmp != null && jmp2 != null) {
                    m.instructions.insertBefore((AbstractInsnNode)mn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore((AbstractInsnNode)mn, (AbstractInsnNode)new FieldInsnNode(180, name, names[1], "Lnet/minecraft/item/ItemStack;"));
                    String clazz = "cofh/asmhooks/HooksCore";
                    String method = "areItemsEqualHook";
                    String sign = "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z";
                    m.instructions.insertBefore((AbstractInsnNode)mn, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asmhooks/HooksCore", "areItemsEqualHook", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z", false));
                    m.instructions.insertBefore((AbstractInsnNode)mn, (AbstractInsnNode)new JumpInsnNode(153, jmp2));
                    m.instructions.insertBefore((AbstractInsnNode)mn, (AbstractInsnNode)new JumpInsnNode(167, jmp));
                    break;
                }
                break block7;
            }
            ClassWriter cw = new ClassWriter(2);
            cn.accept((ClassVisitor)cw);
            bytes = cw.toByteArray();
        }
        return bytes;
    }

    private static byte[] alterTileEntity(String name, byte[] bytes, ClassReader cr) {
        name = name.replace('.', '/');
        ClassWriter cw = new ClassWriter(1);
        cr.accept((ClassVisitor)cw, 0);
        cw.newMethod(name, "cofh_validate", "()V", true);
        MethodVisitor mv = cw.visitMethod(4097, "cofh_validate", "()V", null, null);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitMaxs(0, 1);
        mv.visitEnd();
        cw.visitEnd();
        cw.newMethod(name, "cofh_invalidate", "()V", true);
        mv = cw.visitMethod(4097, "cofh_invalidate", "()V", null, null);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitMaxs(0, 1);
        mv.visitEnd();
        cw.visitEnd();
        cw.visitField(4097, "cofh_isInited$", "Z", null, null);
        return cw.toByteArray();
    }

    private static byte[] writeWorld(String name, byte[] bytes, ClassReader cr) {
        AbstractInsnNode n;
        LabelNode n2;
        LabelNode a;
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"field_73019_z", "field_72986_A", "field_73011_w", "field_72984_F", "func_147448_a", "func_147455_a", "func_72939_s", "func_145830_o", "field_147481_N", "func_147457_a"} : new String[]{"saveHandler", "worldInfo", "provider", "theProfiler", "func_147448_a", "setTileEntity", "updateEntities", "hasWorldObj", "field_147481_N", "func_147457_a"};
        name = name.replace('.', '/');
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        String sig = "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V";
        MethodNode addTileEntity = null;
        MethodNode setTileEntity = null;
        MethodNode addTileEntities = null;
        MethodNode updateEntities = null;
        MethodNode unloadTile = null;
        boolean found = false;
        for (MethodNode m : cn.methods) {
            if ("<init>".equals(m.name)) {
                if ("(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V".equals(m.desc)) {
                    found = true;
                }
                LabelNode a2 = new LabelNode(new Label());
                AbstractInsnNode n3 = m.instructions.getFirst();
                while (n3.getOpcode() != 183 || !((MethodInsnNode)n3).name.equals("<init>")) {
                    n3 = n3.getNext();
                }
                AbstractInsnNode abstractInsnNode = n3;
                n3 = a2;
                m.instructions.insert(abstractInsnNode, n3);
                AbstractInsnNode abstractInsnNode2 = n3;
                n3 = new LineNumberNode(-15000, a2);
                m.instructions.insert(abstractInsnNode2, n3);
                AbstractInsnNode abstractInsnNode3 = n3;
                n3 = new VarInsnNode(25, 0);
                m.instructions.insert(abstractInsnNode3, n3);
                AbstractInsnNode abstractInsnNode4 = n3;
                n3 = new TypeInsnNode(187, "java/util/LinkedList");
                m.instructions.insert(abstractInsnNode4, n3);
                AbstractInsnNode abstractInsnNode5 = n3;
                n3 = new InsnNode(89);
                m.instructions.insert(abstractInsnNode5, n3);
                AbstractInsnNode abstractInsnNode6 = n3;
                n3 = new MethodInsnNode(183, "java/util/LinkedList", "<init>", "()V", false);
                m.instructions.insert(abstractInsnNode6, n3);
                AbstractInsnNode abstractInsnNode7 = n3;
                n3 = new FieldInsnNode(181, "net/minecraft/world/World", "cofh_recentTiles", "Ljava/util/LinkedList;");
                m.instructions.insert(abstractInsnNode7, n3);
                continue;
            }
            if ("addTileEntity".equals(m.name) && "(Lnet/minecraft/tileentity/TileEntity;)V".equals(m.desc)) {
                addTileEntity = m;
                continue;
            }
            if (names[4].equals(m.name) && "(Ljava/util/Collection;)V".equals(m.desc)) {
                addTileEntities = m;
                continue;
            }
            if (names[5].equals(m.name) && "(IIILnet/minecraft/tileentity/TileEntity;)V".equals(m.desc)) {
                setTileEntity = m;
                continue;
            }
            if (names[6].equals(m.name) && "()V".equals(m.desc)) {
                updateEntities = m;
                continue;
            }
            if (!names[9].equals(m.name) || !"(Lnet/minecraft/tileentity/TileEntity;)V".equals(m.desc)) continue;
            unloadTile = m;
        }
        cn.fields.add(new FieldNode(4098, "cofh_recentTiles", "Ljava/util/LinkedList;", null, null));
        if (unloadTile != null) {
            n2 = a = new LabelNode(new Label());
            unloadTile.instructions.insert((AbstractInsnNode)n2);
            LabelNode labelNode = n2;
            n2 = new LineNumberNode(-15005, a);
            unloadTile.instructions.insert((AbstractInsnNode)labelNode, (AbstractInsnNode)n2);
            LabelNode labelNode2 = n2;
            n2 = new VarInsnNode(25, 1);
            unloadTile.instructions.insert((AbstractInsnNode)labelNode2, (AbstractInsnNode)n2);
            LabelNode labelNode3 = n2;
            n2 = new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", "cofh_invalidate", "()V", false);
            unloadTile.instructions.insert((AbstractInsnNode)labelNode3, (AbstractInsnNode)n2);
        }
        if (addTileEntity != null) {
            n2 = a = new LabelNode(new Label());
            addTileEntity.instructions.insert((AbstractInsnNode)n2);
            LabelNode labelNode = n2;
            n2 = new LineNumberNode(-15001, a);
            addTileEntity.instructions.insert((AbstractInsnNode)labelNode, (AbstractInsnNode)n2);
            LabelNode labelNode4 = n2;
            n2 = new VarInsnNode(25, 0);
            addTileEntity.instructions.insert((AbstractInsnNode)labelNode4, (AbstractInsnNode)n2);
            LabelNode labelNode5 = n2;
            n2 = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Ljava/util/LinkedList;");
            addTileEntity.instructions.insert((AbstractInsnNode)labelNode5, (AbstractInsnNode)n2);
            LabelNode labelNode6 = n2;
            n2 = new VarInsnNode(25, 1);
            addTileEntity.instructions.insert((AbstractInsnNode)labelNode6, (AbstractInsnNode)n2);
            LabelNode labelNode7 = n2;
            n2 = new MethodInsnNode(182, "java/util/LinkedList", "addLast", "(Ljava/lang/Object;)V", false);
            addTileEntity.instructions.insert((AbstractInsnNode)labelNode7, (AbstractInsnNode)n2);
            LabelNode labelNode8 = n2;
            n2 = new VarInsnNode(25, 1);
            addTileEntity.instructions.insert((AbstractInsnNode)labelNode8, (AbstractInsnNode)n2);
            LabelNode labelNode9 = n2;
            n2 = new InsnNode(3);
            addTileEntity.instructions.insert((AbstractInsnNode)labelNode9, (AbstractInsnNode)n2);
            LabelNode labelNode10 = n2;
            n2 = new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "cofh_isInited$", "Z");
            addTileEntity.instructions.insert((AbstractInsnNode)labelNode10, (AbstractInsnNode)n2);
        }
        if (setTileEntity != null) {
            a = new LabelNode(new Label());
            n2 = setTileEntity.instructions.getLast();
            while (n2.getOpcode() != 177) {
                n2 = n2.getPrevious();
            }
            n2 = n2.getPrevious();
            n2 = a;
            setTileEntity.instructions.insert((AbstractInsnNode)n2);
            LabelNode labelNode = n2;
            n2 = new LineNumberNode(-15002, a);
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode, (AbstractInsnNode)n2);
            LabelNode nullCheck = new LabelNode();
            LabelNode labelNode11 = n2;
            n2 = new VarInsnNode(25, 4);
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode11, (AbstractInsnNode)n2);
            LabelNode labelNode12 = n2;
            n2 = new JumpInsnNode(198, nullCheck);
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode12, (AbstractInsnNode)n2);
            LabelNode labelNode13 = n2;
            n2 = new VarInsnNode(25, 0);
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode13, (AbstractInsnNode)n2);
            LabelNode labelNode14 = n2;
            n2 = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Ljava/util/LinkedList;");
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode14, (AbstractInsnNode)n2);
            LabelNode labelNode15 = n2;
            n2 = new VarInsnNode(25, 4);
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode15, (AbstractInsnNode)n2);
            LabelNode labelNode16 = n2;
            n2 = new MethodInsnNode(182, "java/util/LinkedList", "addLast", "(Ljava/lang/Object;)V", false);
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode16, (AbstractInsnNode)n2);
            LabelNode labelNode17 = n2;
            n2 = new VarInsnNode(25, 4);
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode17, (AbstractInsnNode)n2);
            LabelNode labelNode18 = n2;
            n2 = new InsnNode(3);
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode18, (AbstractInsnNode)n2);
            LabelNode labelNode19 = n2;
            n2 = new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "cofh_isInited$", "Z");
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode19, (AbstractInsnNode)n2);
            LabelNode labelNode20 = n2;
            n2 = nullCheck;
            setTileEntity.instructions.insert((AbstractInsnNode)labelNode20, (AbstractInsnNode)n2);
        }
        if (addTileEntities != null) {
            n = null;
            for (AbstractInsnNode node : addTileEntities.instructions) {
                if (node.getOpcode() != 192 || !((TypeInsnNode)node).desc.equals("net/minecraft/tileentity/TileEntity")) continue;
                n = node;
                break;
            }
            if (n != null) {
                LabelNode a3 = new LabelNode(new Label());
                AbstractInsnNode abstractInsnNode = n;
                n = a3;
                addTileEntities.instructions.insert(abstractInsnNode, n);
                AbstractInsnNode abstractInsnNode8 = n;
                n = new LineNumberNode(-15003, a3);
                addTileEntities.instructions.insert(abstractInsnNode8, n);
                AbstractInsnNode abstractInsnNode9 = n;
                n = new InsnNode(89);
                addTileEntities.instructions.insert(abstractInsnNode9, n);
                AbstractInsnNode abstractInsnNode10 = n;
                n = new VarInsnNode(25, 0);
                addTileEntities.instructions.insert(abstractInsnNode10, n);
                AbstractInsnNode abstractInsnNode11 = n;
                n = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Ljava/util/LinkedList;");
                addTileEntities.instructions.insert(abstractInsnNode11, n);
                AbstractInsnNode abstractInsnNode12 = n;
                n = new InsnNode(95);
                addTileEntities.instructions.insert(abstractInsnNode12, n);
                AbstractInsnNode abstractInsnNode13 = n;
                n = new InsnNode(89);
                addTileEntities.instructions.insert(abstractInsnNode13, n);
                AbstractInsnNode abstractInsnNode14 = n;
                n = new InsnNode(3);
                addTileEntities.instructions.insert(abstractInsnNode14, n);
                AbstractInsnNode abstractInsnNode15 = n;
                n = new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "cofh_isInited$", "Z");
                addTileEntities.instructions.insert(abstractInsnNode15, n);
                AbstractInsnNode abstractInsnNode16 = n;
                n = new MethodInsnNode(182, "java/util/LinkedList", "addLast", "(Ljava/lang/Object;)V", false);
                addTileEntities.instructions.insert(abstractInsnNode16, n);
            }
        }
        if (updateEntities != null) {
            n = updateEntities.instructions.getFirst();
            while (n.getOpcode() != 182 || !"onChunkUnload".equals(((MethodInsnNode)n).name) || !"()V".equals(((MethodInsnNode)n).desc)) {
                n = n.getNext();
            }
            while (n.getOpcode() != 181 || !names[8].equals(((FieldInsnNode)n).name)) {
                n = n.getPrevious();
            }
            n = n.getNext();
            LabelNode lStart = new LabelNode(new Label());
            LabelNode lGuard = new LabelNode(new Label());
            LabelNode a4 = new LabelNode(new Label());
            AbstractInsnNode abstractInsnNode = n;
            n = a4;
            updateEntities.instructions.insertBefore(abstractInsnNode, n);
            AbstractInsnNode abstractInsnNode17 = n;
            n = new LineNumberNode(-15004, a4);
            updateEntities.instructions.insert(abstractInsnNode17, n);
            LabelNode loopExit = new LabelNode();
            AbstractInsnNode abstractInsnNode18 = n;
            n = lStart;
            updateEntities.instructions.insert(abstractInsnNode18, n);
            AbstractInsnNode abstractInsnNode19 = n;
            n = new VarInsnNode(25, 0);
            updateEntities.instructions.insert(abstractInsnNode19, n);
            AbstractInsnNode abstractInsnNode20 = n;
            n = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Ljava/util/LinkedList;");
            updateEntities.instructions.insert(abstractInsnNode20, n);
            AbstractInsnNode abstractInsnNode21 = n;
            n = new MethodInsnNode(182, "java/util/LinkedList", "poll", "()Ljava/lang/Object;", false);
            updateEntities.instructions.insert(abstractInsnNode21, n);
            AbstractInsnNode abstractInsnNode22 = n;
            n = new InsnNode(89);
            updateEntities.instructions.insert(abstractInsnNode22, n);
            AbstractInsnNode abstractInsnNode23 = n;
            n = new JumpInsnNode(198, loopExit);
            updateEntities.instructions.insert(abstractInsnNode23, n);
            AbstractInsnNode abstractInsnNode24 = n;
            n = new TypeInsnNode(192, "net/minecraft/tileentity/TileEntity");
            updateEntities.instructions.insert(abstractInsnNode24, n);
            AbstractInsnNode abstractInsnNode25 = n;
            n = new InsnNode(89);
            updateEntities.instructions.insert(abstractInsnNode25, n);
            AbstractInsnNode abstractInsnNode26 = n;
            n = new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "cofh_isInited$", "Z");
            updateEntities.instructions.insert(abstractInsnNode26, n);
            AbstractInsnNode abstractInsnNode27 = n;
            n = new JumpInsnNode(154, lGuard);
            updateEntities.instructions.insert(abstractInsnNode27, n);
            AbstractInsnNode abstractInsnNode28 = n;
            n = new InsnNode(89);
            updateEntities.instructions.insert(abstractInsnNode28, n);
            AbstractInsnNode abstractInsnNode29 = n;
            n = new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", names[7], "()Z", false);
            updateEntities.instructions.insert(abstractInsnNode29, n);
            AbstractInsnNode abstractInsnNode30 = n;
            n = new JumpInsnNode(153, lGuard);
            updateEntities.instructions.insert(abstractInsnNode30, n);
            AbstractInsnNode abstractInsnNode31 = n;
            n = new InsnNode(89);
            updateEntities.instructions.insert(abstractInsnNode31, n);
            AbstractInsnNode abstractInsnNode32 = n;
            n = new InsnNode(4);
            updateEntities.instructions.insert(abstractInsnNode32, n);
            AbstractInsnNode abstractInsnNode33 = n;
            n = new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "cofh_isInited$", "Z");
            updateEntities.instructions.insert(abstractInsnNode33, n);
            AbstractInsnNode abstractInsnNode34 = n;
            n = new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", "cofh_validate", "()V", false);
            updateEntities.instructions.insert(abstractInsnNode34, n);
            AbstractInsnNode abstractInsnNode35 = n;
            n = new InsnNode(1);
            updateEntities.instructions.insert(abstractInsnNode35, n);
            AbstractInsnNode abstractInsnNode36 = n;
            n = lGuard;
            updateEntities.instructions.insert(abstractInsnNode36, n);
            AbstractInsnNode abstractInsnNode37 = n;
            n = new InsnNode(87);
            updateEntities.instructions.insert(abstractInsnNode37, n);
            AbstractInsnNode abstractInsnNode38 = n;
            n = new JumpInsnNode(167, lStart);
            updateEntities.instructions.insert(abstractInsnNode38, n);
            AbstractInsnNode abstractInsnNode39 = n;
            n = loopExit;
            updateEntities.instructions.insert(abstractInsnNode39, n);
            AbstractInsnNode abstractInsnNode40 = n;
            n = new InsnNode(87);
            updateEntities.instructions.insert(abstractInsnNode40, n);
        }
        ClassWriter cw = new ClassWriter(2);
        cn.accept((ClassVisitor)cw);
        if (!found) {
            cw.newMethod(name, "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", true);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, name, names[0], "Lnet/minecraft/world/storage/ISaveHandler;");
            mv.visitTypeInsn(187, "net/minecraft/world/storage/WorldInfo");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 4);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(183, "net/minecraft/world/storage/WorldInfo", "<init>", "(Lnet/minecraft/world/WorldSettings;Ljava/lang/String;)V", false);
            mv.visitFieldInsn(181, name, names[1], "Lnet/minecraft/world/storage/WorldInfo;");
            mv.visitVarInsn(25, 3);
            mv.visitFieldInsn(181, name, names[2], "Lnet/minecraft/world/WorldProvider;");
            mv.visitVarInsn(25, 5);
            mv.visitFieldInsn(181, name, names[3], "Lnet/minecraft/profiler/Profiler;");
            mv.visitInsn(177);
            mv.visitMaxs(11, 10);
            mv.visitEnd();
            cw.visitEnd();
        }
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] writeWorldServer(String name, byte[] bytes, ClassReader cr) {
        String[] names = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"field_73061_a", "field_73062_L", "field_73063_M", "field_85177_Q"} : new String[]{"mcServer", "theEntityTracker", "thePlayerManager", "worldTeleporter"};
        name = name.replace('.', '/');
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 8);
        String sig = "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V";
        for (MethodNode m : cn.methods) {
            if (!"<init>".equals(m.name) || !"(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V".equals(m.desc)) continue;
            return bytes;
        }
        ClassWriter cw = new ClassWriter(2);
        cn.accept((ClassVisitor)cw);
        cw.newMethod(name, "<init>", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", true);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitInsn(89);
        mv.visitInsn(89);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitVarInsn(25, 5);
        mv.visitVarInsn(25, 6);
        mv.visitMethodInsn(183, "net/minecraft/world/World", "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", false);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, name, names[0], "Lnet/minecraft/server/MinecraftServer;");
        mv.visitInsn(1);
        mv.visitFieldInsn(181, name, names[1], "Lnet/minecraft/entity/EntityTracker;");
        mv.visitInsn(1);
        mv.visitFieldInsn(181, name, names[2], "Lnet/minecraft/server/management/PlayerManager;");
        mv.visitInsn(1);
        mv.visitFieldInsn(181, name, names[3], "Lnet/minecraft/world/Teleporter;");
        mv.visitInsn(177);
        mv.visitMaxs(11, 10);
        mv.visitEnd();
        cw.visitEnd();
        bytes = cw.toByteArray();
        return bytes;
    }

    private static byte[] writeWorldProxy(String name, byte[] bytes, ClassReader cr) {
        Method[] world = null;
        try {
            world = World.class.getDeclaredMethods();
        }
        catch (Throwable e) {
            Throwables.propagate((Throwable)e);
        }
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 4);
        for (Method m : world) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            String desc = Type.getMethodDescriptor((Method)m);
            cn.methods.removeIf(m2 -> m2.name.equals(m.getName()) && m2.desc.equals(desc));
            MethodVisitor mv = cn.visitMethod(ASMCore.getAccess(m), m.getName(), desc, null, ASMCore.getExceptions(m));
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "skyboy/core/world/WorldProxy", "proxiedWorld", "Lnet/minecraft/world/World;");
            Type[] types = Type.getArgumentTypes((Method)m);
            int w = 1;
            int e = types.length;
            for (int i = 0; i < e; ++i) {
                mv.visitVarInsn(types[i].getOpcode(21), w);
                w += types[i].getSize();
            }
            mv.visitMethodInsn(182, "net/minecraft/world/World", m.getName(), desc, false);
            mv.visitInsn(Type.getReturnType((Method)m).getOpcode(172));
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        ClassWriter cw = new ClassWriter(2);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private static byte[] writeWorldServerProxy(String name, byte[] bytes, ClassReader cr) {
        int i;
        int e;
        int w;
        Type[] types;
        MethodVisitor mv;
        Method[] worldServer = null;
        try {
            worldServer = WorldServer.class.getDeclaredMethods();
        }
        catch (Throwable e2) {
            Throwables.propagate((Throwable)e2);
        }
        Method[] world = null;
        try {
            world = World.class.getDeclaredMethods();
        }
        catch (Throwable e3) {
            Throwables.propagate((Throwable)e3);
        }
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 4);
        cn.superName = "net/minecraft/world/WorldServer";
        block4: for (MethodNode m : cn.methods) {
            if (!"<init>".equals(m.name)) continue;
            InsnList l = m.instructions;
            int e4 = l.size();
            for (int i2 = 0; i2 < e4; ++i2) {
                MethodInsnNode mn;
                AbstractInsnNode n = l.get(i2);
                if (!(n instanceof MethodInsnNode) || (mn = (MethodInsnNode)n).getOpcode() != 183) continue;
                mn.owner = cn.superName;
                continue block4;
            }
        }
        for (Method m : world) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            String desc = Type.getMethodDescriptor((Method)m);
            cn.methods.removeIf(m2 -> m2.name.equals(m.getName()) && m2.desc.equals(desc));
            mv = cn.visitMethod(ASMCore.getAccess(m), m.getName(), desc, null, ASMCore.getExceptions(m));
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "skyboy/core/world/WorldServerProxy", "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
            types = Type.getArgumentTypes((Method)m);
            w = 1;
            e = types.length;
            for (i = 0; i < e; ++i) {
                mv.visitVarInsn(types[i].getOpcode(21), w);
                w += types[i].getSize();
            }
            mv.visitMethodInsn(182, "net/minecraft/world/World", m.getName(), desc, false);
            mv.visitInsn(Type.getReturnType((Method)m).getOpcode(172));
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        for (Method m : worldServer) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            String desc = Type.getMethodDescriptor((Method)m);
            cn.methods.removeIf(m2 -> m2.name.equals(m.getName()) && m2.desc.equals(desc));
            mv = cn.visitMethod(ASMCore.getAccess(m), m.getName(), desc, null, ASMCore.getExceptions(m));
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "skyboy/core/world/WorldServerProxy", "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
            types = Type.getArgumentTypes((Method)m);
            w = 1;
            e = types.length;
            for (i = 0; i < e; ++i) {
                mv.visitVarInsn(types[i].getOpcode(21), w);
                w += types[i].getSize();
            }
            mv.visitMethodInsn(182, "net/minecraft/world/WorldServer", m.getName(), desc, false);
            mv.visitInsn(Type.getReturnType((Method)m).getOpcode(172));
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        ClassWriter cw = new ClassWriter(2);
        cn.accept((ClassVisitor)cw);
        bytes = cw.toByteArray();
        return bytes;
    }

    private static int getAccess(Method m) {
        int r = m.getModifiers();
        r &= 0xFFFFFBA8;
        return r |= 0x1001;
    }

    private static String[] getExceptions(Method m) {
        Class<?>[] d = m.getExceptionTypes();
        String[] r = new String[d.length];
        for (int i = 0; i < d.length; ++i) {
            r[i] = Type.getInternalName(d[i]);
        }
        return r;
    }

    static boolean implement(ClassNode cn) {
        if (cn.visibleAnnotations == null) {
            return false;
        }
        boolean interfaces = false;
        for (AnnotationNode n : cn.visibleAnnotations) {
            AnnotationInfo node = ASMCore.parseAnnotation(n, implementableDesc);
            if (node == null || node.side != "NONE" && side != node.side) continue;
            for (String string : node.values) {
                String clazz = string.trim();
                String cz = clazz.replace('.', '/');
                if (cn.interfaces.contains(cz)) continue;
                try {
                    if (!workingPath.contains(clazz)) {
                        Class.forName(clazz, false, ASMCore.class.getClassLoader());
                    }
                    cn.interfaces.add(cz);
                    interfaces = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return interfaces;
    }

    static boolean substitute(ClassNode cn) {
        boolean altered = false;
        if (cn.methods != null) {
            for (MethodNode mn : cn.methods) {
                if (mn.visibleAnnotations == null) continue;
                block13: for (AnnotationNode node : mn.visibleAnnotations) {
                    AnnotationInfo info = ASMCore.parseAnnotation(node, substitutableDesc);
                    if (!ASMCore.checkSub(info, mn)) continue;
                    altered = true;
                    mn.instructions.clear();
                    mn.localVariables = null;
                    for (MethodNode m : cn.methods) {
                        if (!info.method.equals(m.name) || !mn.desc.equals(m.desc)) continue;
                        mn.instructions.add(m.instructions);
                        continue block13;
                    }
                    Type rType = Type.getReturnType((String)mn.desc);
                    switch (rType.getSort()) {
                        case 9: 
                        case 10: 
                        case 11: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(1));
                            break;
                        }
                        case 6: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(11));
                            break;
                        }
                        case 8: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(14));
                            break;
                        }
                        case 7: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(9));
                            break;
                        }
                        default: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(3));
                            switch (rType.getSort()) {
                                case 4: {
                                    mn.instructions.add((AbstractInsnNode)new InsnNode(147));
                                    break;
                                }
                                case 2: {
                                    mn.instructions.add((AbstractInsnNode)new InsnNode(146));
                                    break;
                                }
                                case 3: {
                                    mn.instructions.add((AbstractInsnNode)new InsnNode(145));
                                }
                            }
                        }
                        case 0: 
                    }
                    mn.instructions.add((AbstractInsnNode)new InsnNode(rType.getOpcode(172)));
                }
            }
        }
        return altered;
    }

    static boolean checkSub(AnnotationInfo node, MethodNode method) {
        if (node != null) {
            boolean needsReplaced;
            boolean bl = needsReplaced = node.side == side;
            if (!needsReplaced) {
                String string;
                String[] value;
                String[] stringArray = value = node.values;
                int n = stringArray.length;
                for (int i = 0; i < n && !(needsReplaced = ASMCore.parseValue(string = stringArray[i])); ++i) {
                }
            }
            if (needsReplaced) {
                return !node.method.equals(method.name);
            }
        }
        return false;
    }

    static boolean strip(ClassNode cn) {
        Iterator iter;
        boolean altered = false;
        if (cn.visibleAnnotations != null) {
            for (AnnotationNode n : cn.visibleAnnotations) {
                AnnotationInfo node = ASMCore.parseAnnotation(n, strippableDesc);
                if (node == null) continue;
                String[] value = node.values;
                boolean wrongSide = side == node.side;
                for (String clazz : value) {
                    String cz = clazz.replace('.', '/');
                    if (!cn.interfaces.contains(cz)) continue;
                    boolean remove = true;
                    try {
                        if (!wrongSide && !workingPath.contains(clazz)) {
                            Class.forName(clazz, false, ASMCore.class.getClassLoader());
                            remove = false;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!remove) continue;
                    cn.interfaces.remove(cz);
                    altered = true;
                }
            }
        }
        if (cn.methods != null) {
            iter = cn.methods.iterator();
            block4: while (iter.hasNext()) {
                MethodNode mn = (MethodNode)iter.next();
                if (mn.visibleAnnotations == null) continue;
                for (AnnotationNode node : mn.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(node, strippableDesc), iter)) continue;
                    altered = true;
                    continue block4;
                }
            }
        }
        if (cn.fields != null) {
            iter = cn.fields.iterator();
            block6: while (iter.hasNext()) {
                FieldNode fn = (FieldNode)iter.next();
                if (fn.visibleAnnotations == null) continue;
                for (AnnotationNode node : fn.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(node, strippableDesc), iter)) continue;
                    altered = true;
                    continue block6;
                }
            }
        }
        return altered;
    }

    static boolean checkRemove(AnnotationInfo node, Iterator<? extends Object> iter) {
        if (node != null) {
            boolean needsRemoved;
            boolean bl = needsRemoved = node.side == side;
            if (!needsRemoved) {
                String string;
                String[] stringArray = node.values;
                int n = stringArray.length;
                for (int i = 0; i < n && !(needsRemoved = ASMCore.parseValue(string = stringArray[i])); ++i) {
                }
            }
            if (needsRemoved) {
                iter.remove();
                return true;
            }
        }
        return false;
    }

    static boolean parseValue(String clazz) {
        boolean ret;
        block16: {
            String mod;
            ret = false;
            String string = mod = clazz.length() > 4 ? clazz.substring(4) : clazz;
            if (clazz.startsWith("mod:")) {
                int i = mod.indexOf(64);
                if (i > 0) {
                    clazz = mod.substring(i + 1);
                    mod = mod.substring(0, i);
                }
                boolean bl = ret = !Loader.isModLoaded((String)mod);
                if (!ret && i > 0) {
                    ModContainer modc = ASMCore.getLoadedMods().get(mod);
                    try {
                        if (Boolean.parseBoolean((String)modc.getCustomModProperties().get("cofhversion"))) {
                            ret = !ModRange.createFromVersionSpec(mod, clazz).containsVersion((ArtifactVersion)new ModVersion(mod, modc.getVersion()));
                            break block16;
                        }
                        ret = !VersionRange.createFromVersionSpec((String)clazz).containsVersion(modc.getProcessedVersion());
                    }
                    catch (InvalidVersionSpecificationException e) {
                        ret = true;
                    }
                }
            } else if (clazz.startsWith("api:")) {
                int i = mod.indexOf(64);
                if (i > 0) {
                    clazz = mod.substring(i + 1);
                    mod = mod.substring(0, i);
                }
                boolean bl = ret = !ModAPIManager.INSTANCE.hasAPI(mod);
                if (!ret && i > 0) {
                    ModContainer modc = ASMCore.getLoadedAPIs().get(mod);
                    try {
                        ret = !VersionRange.createFromVersionSpec((String)clazz).containsVersion(modc.getProcessedVersion());
                    }
                    catch (InvalidVersionSpecificationException e) {
                        ret = true;
                    }
                }
            } else {
                try {
                    if (!workingPath.contains(clazz)) {
                        Class.forName(clazz, false, ASMCore.class.getClassLoader());
                    }
                }
                catch (Throwable $) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static void onGameLoaded() {
        gameLoaded = true;
        mods = null;
        apis = null;
    }

    static Map<String, ModContainer> getLoadedMods() {
        if (mods == null) {
            List list = Loader.instance().getModList();
            HashMap<String, ModContainer> x = new HashMap<String, ModContainer>(list.size());
            for (ModContainer m : list) {
                x.put(m.getModId(), m);
            }
            if (gameLoaded) {
                return x;
            }
            mods = x;
        }
        return mods;
    }

    static Map<String, ModContainer> getLoadedAPIs() {
        if (apis == null) {
            HashMap<String, ModContainer> x = new HashMap<String, ModContainer>();
            for (ModContainer m : ModAPIManager.INSTANCE.getAPIList()) {
                x.put(m.getModId(), m);
            }
            if (gameLoaded) {
                return x;
            }
            apis = x;
        }
        return apis;
    }

    static AnnotationInfo parseAnnotation(AnnotationNode node, String desc) {
        AnnotationInfo info = null;
        if (node.desc.equals(desc)) {
            info = new AnnotationInfo();
            if (node.values != null) {
                List values = node.values;
                int i = 0;
                int e = values.size();
                while (i < e) {
                    Object k = values.get(i++);
                    Object v = values.get(i++);
                    if ("value".equals(k)) {
                        if (!(v instanceof List) || ((List)v).isEmpty() || !(((List)v).get(0) instanceof String)) continue;
                        info.values = ((List)v).toArray(emptyList);
                        continue;
                    }
                    if ("side".equals(k) && v instanceof String) {
                        info.side = ((String)v).toUpperCase().intern();
                        continue;
                    }
                    if (!"method".equals(k) || !(v instanceof String)) continue;
                    info.method = (String)v;
                }
            }
        }
        return info;
    }

    static void scrapeData(ASMDataTable table) {
        String name;
        log.debug("Scraping data");
        side = FMLCommonHandler.instance().getSide().toString().toUpperCase(Locale.US).intern();
        for (ASMDataTable.ASMData data : table.getAll(Implementable.class.getName())) {
            name = data.getClassName();
            parsables.add((Object)name);
            parsables.add((Object)(name + "$class"));
            implementables.add((Object)name);
            implementables.add((Object)(name + "$class"));
        }
        for (ASMDataTable.ASMData data : table.getAll(Strippable.class.getName())) {
            name = data.getClassName();
            parsables.add((Object)name);
            parsables.add((Object)(name + "$class"));
            strippables.add((Object)name);
            strippables.add((Object)(name + "$class"));
        }
        for (ASMDataTable.ASMData data : table.getAll(Substitutable.class.getName())) {
            name = data.getClassName();
            parsables.add((Object)name);
            parsables.add((Object)(name + "$class"));
            substitutables.add((Object)name);
            substitutables.add((Object)(name + "$class"));
        }
        log.debug("Found " + implementables.size() / 2 + " @Implementable; " + strippables.size() / 2 + " @Strippable; " + substitutables.size() / 2 + " @Substitutable");
    }

    static /* synthetic */ String[] access$000() {
        return emptyList;
    }

    static {
        implementableDesc = Type.getDescriptor(Implementable.class);
        strippableDesc = Type.getDescriptor(Strippable.class);
        substitutableDesc = Type.getDescriptor(Substitutable.class);
        parsables = new THashSet(30);
        implementables = new THashSet(10);
        strippables = new THashSet(10);
        substitutables = new THashSet(10);
        hashes.put((Object)"net.minecraft.world.WorldServer", (byte)1);
        hashes.put((Object)"net.minecraft.world.World", (byte)2);
        hashes.put((Object)"skyboy.core.world.WorldProxy", (byte)3);
        hashes.put((Object)"skyboy.core.world.WorldServerProxy", (byte)4);
        hashes.put((Object)"net.minecraft.block.BlockPane", (byte)5);
        hashes.put((Object)"net.minecraft.block.Block", (byte)6);
        hashes.put((Object)"net.minecraft.client.multiplayer.PlayerControllerMP", (byte)7);
        hashes.put((Object)"net.minecraft.util.LongHashMap", (byte)8);
        if (Boolean.parseBoolean(System.getProperty("cofh.lightedit", "true"))) {
            hashes.put((Object)"net.minecraft.world.chunk.Chunk", (byte)9);
        }
        hashes.put((Object)"net.minecraft.client.Minecraft", (byte)10);
        hashes.put((Object)"net.minecraft.client.renderer.RenderBlocks", (byte)11);
        hashes.put((Object)"net.minecraft.tileentity.TileEntity", (byte)12);
        hashes.put((Object)"net.minecraft.inventory.Container", (byte)13);
        hashes.put((Object)"net.minecraft.entity.Entity", (byte)14);
        hashes.put((Object)"net.minecraft.entity.item.EntityItem", (byte)15);
        hashes.put((Object)"cofh.asmhooks.HooksCore", (byte)16);
        hashes.put((Object)"net.minecraft.enchantment.Enchantment", (byte)17);
        hashes.put((Object)"net.minecraft.item.Item", (byte)18);
        hashes.put((Object)"net.minecraft.client.gui.GuiKeyBindingList$KeyEntry", (byte)19);
        hashes.put((Object)"net.minecraft.client.settings.KeyBinding", (byte)20);
        hashes.put((Object)"cpw.mods.fml.common.registry.GameRegistry", (byte)21);
        if (Boolean.parseBoolean(System.getProperty("cofh.profiler.debug", "false"))) {
            hashes.put((Object)"net.minecraft.profiler.Profiler", (byte)22);
        }
        hashes.trimToSize();
        workingPath = new ArrayList();
        emptyList = new String[0];
    }

    static class AnnotationInfo {
        public String side = "NONE";
        public String[] values = ASMCore.access$000();
        public String method = "!unmatchable!";

        AnnotationInfo() {
        }
    }
}

