/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.particles;

import cofh.core.particles.ParticleBase;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class ParticleRenderer {
    private static ParticleRenderer instance = new ParticleRenderer();
    private WeakReference<World> worldRef = new WeakReference<Object>(null);
    private static final LinkedList<ParticleBase> particles_toAdd = new LinkedList();
    private final LinkedHashMap<ResourceLocation, LinkedList<ParticleBase>> particles = new LinkedHashMap();

    private ParticleRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderParticles(RenderWorldLastEvent renderWorldLastEvent) {
        if (this.worldRef.get() == null) {
            return;
        }
        if (this.particles.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2912);
        float f = renderWorldLastEvent.partialTicks;
        minecraft.field_71460_t.func_78463_b((double)f);
        EntityLivingBase entityLivingBase = minecraft.field_71451_h;
        ParticleBase.interpPosX = entityLivingBase.field_70142_S + (entityLivingBase.field_70165_t - entityLivingBase.field_70142_S) * (double)renderWorldLastEvent.partialTicks;
        ParticleBase.interpPosY = entityLivingBase.field_70137_T + (entityLivingBase.field_70163_u - entityLivingBase.field_70137_T) * (double)renderWorldLastEvent.partialTicks;
        ParticleBase.interpPosZ = entityLivingBase.field_70136_U + (entityLivingBase.field_70161_v - entityLivingBase.field_70136_U) * (double)renderWorldLastEvent.partialTicks;
        ParticleBase.rX = ActiveRenderInfo.field_74588_d;
        ParticleBase.rZ = ActiveRenderInfo.field_74586_f;
        ParticleBase.rYZ = ActiveRenderInfo.field_74587_g;
        ParticleBase.rXY = ActiveRenderInfo.field_74596_h;
        ParticleBase.rXZ = ActiveRenderInfo.field_74589_e;
        LinkedHashMap<ResourceLocation, LinkedList<ParticleBase>> linkedHashMap = this.particles;
        synchronized (linkedHashMap) {
            for (Map.Entry<ResourceLocation, LinkedList<ParticleBase>> entry : this.particles.entrySet()) {
                minecraft.func_110434_K().func_110577_a(entry.getKey());
                LinkedList<ParticleBase> linkedList = entry.getValue();
                if (linkedList.isEmpty()) continue;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                for (final ParticleBase particleBase : linkedList) {
                    tessellator.func_78380_c(particleBase.brightness(renderWorldLastEvent.partialTicks));
                    try {
                        particleBase.render(tessellator, renderWorldLastEvent.partialTicks);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                        CrashReportCategory crashReportCategory = crashReport.func_85058_a("Particle being rendered");
                        crashReportCategory.func_71500_a("Particle", new Callable(){

                            public String call() {
                                return particleBase.toString();
                            }
                        });
                        crashReportCategory.func_71500_a("Particle Type", new Callable(){

                            public String call() {
                                return particleBase.location.toString();
                            }
                        });
                        throw new ReportedException(crashReport);
                    }
                }
                tessellator.func_78381_a();
                GL11.glDisable((int)3042);
                GL11.glDepthMask((boolean)true);
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
        }
        minecraft.field_71460_t.func_78483_a((double)f);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2912);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void updateParticles(TickEvent.ClientTickEvent clientTickEvent) {
        LinkedList<ParticleBase> linkedList;
        ParticleBase particleBase;
        if (clientTickEvent.phase == TickEvent.Phase.END || this.particles.isEmpty() && particles_toAdd.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null || minecraft.func_147113_T()) {
            return;
        }
        WorldClient worldClient = Minecraft.func_71410_x().field_71441_e;
        if (worldClient == null) {
            return;
        }
        World world = (World)this.worldRef.get();
        if (world == null || worldClient != world) {
            this.clearParticles();
            this.worldRef = new WeakReference<WorldClient>(worldClient);
        }
        while ((particleBase = particles_toAdd.poll()) != null) {
            linkedList = this.particles.get(particleBase.location);
            if (linkedList == null) {
                linkedList = new LinkedList<ParticleBase>();
                this.particles.put(particleBase.location, linkedList);
            }
            while (linkedList.size() > 4000) {
                linkedList.poll();
            }
            linkedList.add(particleBase);
        }
        linkedList = this.particles.entrySet().iterator();
        while (linkedList.hasNext()) {
            LinkedList linkedList2 = (LinkedList)((Map.Entry)linkedList.next()).getValue();
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                ParticleBase particleBase2 = (ParticleBase)iterator.next();
                try {
                    if (particleBase2.advance()) continue;
                    iterator.remove();
                }
                catch (Exception exception) {
                    throw Throwables.propagate((Throwable)exception);
                }
            }
            if (!linkedList2.isEmpty()) continue;
            linkedList.remove();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void unloadParticles(WorldEvent.Unload unload) {
        World world;
        if (!unload.world.field_72995_K) {
            return;
        }
        if (unload.world != Minecraft.func_71410_x().field_71441_e && (world = (World)this.worldRef.get()) != null && world != unload.world) {
            return;
        }
        this.clearParticles();
        this.worldRef = new WeakReference<Object>(null);
    }

    public void clearParticles() {
        this.particles.clear();
        particles_toAdd.clear();
    }

    public static void spawnParticle(ParticleBase particleBase) {
        particles_toAdd.add(particleBase);
    }
}

