/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.network;

import io.netty.buffer.ByteBuf;

public final class ByteBufHelper {
    private ByteBufHelper() {
    }

    public static int readVarInt(ByteBuf byteBuf) {
        byte by = byteBuf.readByte();
        int n = by & 0x3F;
        boolean bl = (by & 0x40) != 0;
        int n2 = 6;
        while ((by & 0x80) != 0) {
            by = byteBuf.readByte();
            n |= (by & 0x7F) << n2;
            if ((n2 += 7) <= 34) continue;
            throw new RuntimeException("VarInt too big");
        }
        return bl ? ~n : n;
    }

    public static void writeVarInt(int n, ByteBuf byteBuf) {
        int n2 = 0;
        if (n < 0) {
            n2 |= 0x40;
            n ^= 0xFFFFFFFF;
        }
        if ((n & 0xFFFFFFC0) != 0) {
            n2 |= 0x80;
        }
        byteBuf.writeByte(n2 | n & 0x3F);
        n >>>= 6;
        while (n != 0) {
            byteBuf.writeByte(n & 0x7F | ((n & 0xFFFFFF80) != 0 ? 128 : 0));
            n >>>= 7;
        }
    }

    public static String readString(ByteBuf byteBuf) {
        int n;
        int n2;
        int n3 = ByteBufHelper.readVarInt(byteBuf);
        if (n3 == -1) {
            return null;
        }
        byte[] byArray = null;
        char[] cArray = null;
        byArray = new byte[n3];
        cArray = new char[n3];
        int n4 = 0;
        byteBuf.readBytes(byArray, 0, n3);
        for (n2 = 0; n2 < n3 && (n = byArray[n2] & 0xFF) <= 127; ++n2) {
            cArray[n4++] = (char)n;
        }
        block6: while (n2 < n3) {
            n = byArray[n2] & 0xFF;
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n4++] = (char)n;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n3) {
                        throw new IllegalArgumentException("malformed input: partial character at end");
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + n2);
                    }
                    cArray[n4++] = (char)((n & 0x1F) << 6 | by & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((n2 += 3) > n3) {
                        throw new IllegalArgumentException("malformed input: partial character at end");
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + (n2 - 1));
                    }
                    cArray[n4++] = (char)((n & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("malformed input around byte " + n2);
        }
        return new String(cArray, 0, n4);
    }

    public static void writeString(String string, ByteBuf byteBuf) {
        int n;
        char c;
        if (string == null) {
            ByteBufHelper.writeVarInt(-1, byteBuf);
            return;
        }
        int n2 = string.length();
        long l = 0L;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            c = string.charAt(i);
            if (c >= '\u0001' & c <= '\u007f') {
                ++l;
                continue;
            }
            if (c < '\u0800') {
                l += 2L;
                continue;
            }
            l += 3L;
        }
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("encoded string too long: " + l + " bytes");
        }
        byte[] byArray = new byte[(int)l];
        ByteBufHelper.writeVarInt((int)l, byteBuf);
        if (l == (long)n2) {
            for (n = 0; n < n2; ++n) {
                byArray[n3++] = (byte)string.charAt(n);
            }
        }
        while (n < n2) {
            c = string.charAt(n);
            if (c >= '\u0001' & c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c < '\u0800') {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n;
        }
        byteBuf.writeBytes(byArray);
    }
}

