/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.nei;

import codechicken.nei.ItemStackSet;
import codechicken.nei.LayoutManager;
import codechicken.nei.api.ItemInfo;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.nei.NEI")
public class NEI {
    private static final boolean hasNEI = Loader.isModLoaded((String)"NotEnoughItems");
    private static final MethodHandle removeFromItemsSet = NEI.lookupMethod0();

    private static MethodHandle lookupMethod0() {
        if (!hasNEI) {
            return null;
        }
        try {
            return MethodHandles.publicLookup().unreflect(ItemStackSet.class.getMethod("remove", ItemStack.class)).bindTo(ItemInfo.hiddenItems);
        }
        catch (Throwable t) {
            MineTweakerAPI.logError("CraftTweaker will not support rolling back the NEI#hide method, as ItemStackSet#remove method not found!", t);
            return null;
        }
    }

    @ZenMethod
    public static void hide(@NotNull IItemStack stack) {
        ItemStack item = MineTweakerMC.getItemStack(stack);
        if (item != null) {
            MineTweakerAPI.apply(new NEIHideItemAction(item));
        } else {
            MineTweakerAPI.logWarning("[NEI] ItemStack cant be null");
        }
    }

    @ZenMethod
    public static void addEntry(@NotNull IItemStack stack) {
        ItemStack item = MineTweakerMC.getItemStack(stack);
        if (item != null) {
            MineTweakerAPI.apply(new NEIAddEntryAction(item));
        } else {
            MineTweakerAPI.logWarning("[NEI] ItemStack cant be null");
        }
    }

    @ZenMethod
    public static void overrideName(@NotNull IItemStack item, @NotNull String name) {
        ItemStack s = MineTweakerMC.getItemStack(item);
        if (s != null) {
            MineTweakerAPI.apply(new NEIOverrideNameAction(s, name));
        } else {
            MineTweakerAPI.logWarning("[NEI] ItemStack cant be null");
        }
    }

    private static void tryUpdateJEI() {
        try {
            ReflectionHelper.findMethod(LayoutManager.class, null, (String[])new String[]{"markItemsDirty"}, (Class[])new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class NEIOverrideNameAction
    implements IUndoableAction {
        private final ItemStack item;
        private final String name;
        private String replacedName;

        public NEIOverrideNameAction(ItemStack item, String name) {
            this.item = item;
            this.name = name;
        }

        @Override
        public void apply() {
            if (hasNEI) {
                this.replacedName = (String)ItemInfo.nameOverrides.get(this.item);
                ItemInfo.nameOverrides.put(this.item, (Object)this.name);
                NEI.tryUpdateJEI();
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            if (!hasNEI) {
                return;
            }
            if (this.replacedName != null) {
                ItemInfo.nameOverrides.put(this.item, (Object)this.replacedName);
            } else {
                ItemInfo.nameOverrides.remove(this.item);
            }
            NEI.tryUpdateJEI();
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public String describe() {
            return "Overriding NEI item name of " + this.item.func_77977_a() + " to " + this.name;
        }

        @Override
        public Object getOverrideKey() {
            return this.item;
        }
    }

    private static class NEIHideItemAction
    implements IUndoableAction {
        private final ItemStack stack;
        private boolean applied;

        public NEIHideItemAction(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public void apply() {
            if (hasNEI) {
                if (ItemInfo.hiddenItems.contains(this.stack)) {
                    return;
                }
                this.applied = true;
                ItemInfo.hiddenItems.add(this.stack);
                NEI.tryUpdateJEI();
            }
        }

        @Override
        public boolean canUndo() {
            return removeFromItemsSet != null;
        }

        @Override
        public void undo() {
            if (hasNEI && this.applied && removeFromItemsSet != null) {
                try {
                    Object v = removeFromItemsSet.invoke(this.stack);
                    if (v != null && v != Boolean.FALSE) {
                        NEI.tryUpdateJEI();
                    }
                }
                catch (Throwable t) {
                    MineTweakerAPI.logError("Cant undo NEI#hide for " + this.stack.func_82833_r(), t);
                }
            }
        }

        @Override
        public String describe() {
            return "Hiding " + this.stack.func_77977_a() + " in NEI";
        }

        @Override
        public String describeUndo() {
            return "Displaying " + this.stack.func_77977_a() + " in NEI";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class NEIAddEntryAction
    implements IUndoableAction {
        private final ItemStack item;

        public NEIAddEntryAction(ItemStack item) {
            this.item = item;
        }

        @Override
        public void apply() {
            if (hasNEI) {
                ItemInfo.itemOverrides.put((Object)this.item.func_77973_b(), (Object)this.item);
                NEI.tryUpdateJEI();
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            if (hasNEI) {
                ItemInfo.itemOverrides.remove((Object)this.item.func_77973_b(), (Object)this.item);
                NEI.tryUpdateJEI();
            }
        }

        @Override
        public String describe() {
            return "Adding " + this.item.func_82833_r() + " as NEI entry";
        }

        @Override
        public String describeUndo() {
            return "Removing " + this.item.func_82833_r() + " as NEI entry";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

