/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.runtime;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.runtime.GlobalRegistry;
import minetweaker.runtime.IScriptIterator;
import minetweaker.runtime.IScriptProvider;
import minetweaker.runtime.ITweaker;
import minetweaker.runtime.providers.ScriptProviderMemory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SerializationUtils;
import stanhebben.zenscript.ZenModule;
import stanhebben.zenscript.ZenParsedFile;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.parser.ParseException;
import team.luxinfine.minetweakerapi.EmptyScriptProvider;

public class MTTweaker
implements ITweaker {
    private static final boolean DEBUG = false;
    private final List<IUndoableAction> actions = new ArrayList<IUndoableAction>();
    private final Set<IUndoableAction> wereStuck = new LinkedHashSet<IUndoableAction>();
    private final Map<Object, IUndoableAction> stuckOverridable = new HashMap<Object, IUndoableAction>();
    private IScriptProvider scriptProvider;
    private byte[] scriptData;

    @Override
    public byte[] getStagedScriptData() {
        return this.scriptProvider == EmptyScriptProvider.INSTANCE ? ArrayUtils.EMPTY_BYTE_ARRAY : ScriptProviderMemory.collect(this.scriptProvider);
    }

    public static void receiveScriptInfo(ByteBuf date, long modifyDate) {
        ZenModule.classes.clear();
        ZenModule.loadedClasses.clear();
        MineTweakerImplementationAPI.setScriptProvider(EmptyScriptProvider.INSTANCE);
        System.out.println("Apply server scripts");
        int size = date.readInt();
        for (int i = 0; i < size; ++i) {
            try {
                String name = ByteBufUtils.readUTF8String((ByteBuf)date);
                int length = date.readInt();
                byte[] bytes = new byte[length];
                date.readBytes(bytes);
                ZenModule.classes.put(name, bytes);
                continue;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        try {
            Files.write(Paths.get(Loader.instance().getConfigDir().getPath(), "scripts.dat"), SerializationUtils.serialize((Serializable)((Serializable)((Object)ZenModule.classes))), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Files.write(Paths.get(Loader.instance().getConfigDir().getPath(), "scripts.time"), SerializationUtils.serialize((Serializable)Long.valueOf(modifyDate)), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ZenModule.modifyDate = modifyDate;
        MineTweakerImplementationAPI.reload();
    }

    @Override
    public void apply(IUndoableAction action) {
        MineTweakerAPI.logInfo(action.describe());
        Object overrideKey = action.getOverrideKey();
        if (this.wereStuck.contains(action)) {
            MineTweakerAPI.logInfo("WAS STUCK");
            this.wereStuck.remove(action);
            if (overrideKey != null) {
                this.stuckOverridable.remove(overrideKey);
            }
        } else {
            if (overrideKey != null && this.stuckOverridable.containsKey(overrideKey)) {
                this.wereStuck.remove(this.stuckOverridable.get(overrideKey));
                this.stuckOverridable.remove(overrideKey);
            }
            action.apply();
        }
        this.actions.add(action);
    }

    @Override
    public void remove(IIngredient items) {
        GlobalRegistry.remove(items);
    }

    @Override
    public List<IUndoableAction> rollback() {
        ArrayList<IUndoableAction> stuck = new ArrayList<IUndoableAction>();
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            IUndoableAction action = this.actions.get(i);
            if (action.canUndo()) {
                MineTweakerAPI.logInfo(action.describeUndo());
                action.undo();
                continue;
            }
            MineTweakerAPI.logInfo("[Stuck] 1 " + action.describe());
            MineTweakerAPI.logInfo("[Stuck] 2 " + action.describeUndo());
            MineTweakerAPI.logInfo("[Stuck] 3 " + action);
            stuck.add(0, action);
            this.wereStuck.add(action);
            Object overrideKey = action.getOverrideKey();
            if (overrideKey == null) continue;
            this.stuckOverridable.put(overrideKey, action);
        }
        this.actions.clear();
        return stuck;
    }

    @Override
    public void setScriptProvider(IScriptProvider provider) {
        this.scriptProvider = provider;
    }

    @Override
    public void load() {
        System.out.println("Loading scripts");
        if (this.scriptProvider == EmptyScriptProvider.INSTANCE) {
            ZenModule zenModule = new ZenModule(new HashMap<String, byte[]>(ZenModule.classes), MineTweakerAPI.class.getClassLoader());
            zenModule.getMain().run();
            zenModule.runScripts();
            return;
        }
        ZenModule.classes.clear();
        ZenModule.loadedClasses.clear();
        try {
            Map map = (Map)SerializationUtils.deserialize((byte[])IOUtils.toByteArray((InputStream)Files.newInputStream(Paths.get(Loader.instance().getConfigDir().getPath(), "scripts.dat"), new OpenOption[0])));
            ZenModule.classes.putAll(map);
            ZenModule zenModule = new ZenModule(new HashMap<String, byte[]>(ZenModule.classes), MineTweakerAPI.class.getClassLoader());
            zenModule.getMain().run();
            zenModule.runScripts();
            System.out.println("Scripts loaded from cache");
            return;
        }
        catch (Exception e) {
            System.out.println("Script cache not found. Loading originally.");
            e.printStackTrace();
            this.scriptData = ScriptProviderMemory.collect(this.scriptProvider);
            HashSet<String> executed = new HashSet<String>();
            Iterator<IScriptIterator> scripts = this.scriptProvider.getScripts();
            while (scripts.hasNext()) {
                IScriptIterator script = scripts.next();
                if (executed.contains(script.getGroupName())) continue;
                executed.add(script.getGroupName());
                HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
                IEnvironmentGlobal environmentGlobal = GlobalRegistry.makeGlobalEnvironment(classes);
                ArrayList<ZenParsedFile> files = new ArrayList<ZenParsedFile>();
                while (script.next()) {
                    InputStreamReader reader = null;
                    try {
                        reader = new InputStreamReader((InputStream)new BufferedInputStream(script.open()), StandardCharsets.UTF_8);
                        String filename = script.getName();
                        String className = ZenModule.extractClassName(filename);
                        ZenTokener parser = new ZenTokener(reader, environmentGlobal.getEnvironment(), filename, false);
                        ZenParsedFile pfile = new ZenParsedFile(filename, className, parser, environmentGlobal);
                        files.add(pfile);
                    }
                    catch (IOException ex) {
                        MineTweakerAPI.logError("Could not load script " + script.getName() + ": " + ex.getMessage());
                    }
                    catch (ParseException ex) {
                        MineTweakerAPI.logError("Error parsing " + ex.getFile().getFileName() + ":" + ex.getLine() + " -- " + ex.getExplanation());
                    }
                    catch (Exception ex) {
                        MineTweakerAPI.logError("Error loading " + script.getName() + ": " + ex.toString(), ex);
                    }
                    if (reader == null) continue;
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException ex) {}
                }
                try {
                    String filename = script.getGroupName();
                    System.out.println("MineTweaker: Loading " + filename);
                    ZenModule.compileScripts(filename, files, environmentGlobal, false);
                    ZenModule module = new ZenModule(classes, MineTweakerAPI.class.getClassLoader());
                    module.getMain().run();
                }
                catch (Throwable ex) {
                    MineTweakerAPI.logError("Error executing " + script.getGroupName() + ": " + ex.getMessage(), ex);
                }
            }
            if (this.wereStuck.size() > 0) {
                MineTweakerAPI.logWarning(this.wereStuck.size() + " modifications were stuck");
                for (IUndoableAction action : this.wereStuck) {
                    MineTweakerAPI.logInfo("Stuck: " + action.describe());
                }
            }
            return;
        }
    }

    @Override
    public byte[] getScriptData() {
        return this.scriptProvider == EmptyScriptProvider.INSTANCE ? ArrayUtils.EMPTY_BYTE_ARRAY : this.scriptData;
    }
}

