/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.TileEntityEnder;
import com.enderio.core.common.interfaces.IComparatorOutput;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.Log;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockEnder
extends Block {
    @Nullable
    protected final Class<? extends TileEntityEnder> teClass;
    protected final String name;
    protected final boolean hasComparatorInputOverride;

    protected BlockEnder(String name, Class<? extends TileEntityEnder> teClass) {
        this(name, teClass, new Material(MapColor.field_151668_h));
    }

    protected BlockEnder(String name, Class<? extends TileEntityEnder> teClass, Material mat) {
        super(mat);
        this.teClass = teClass;
        this.name = name;
        this.func_149711_c(0.5f);
        this.func_149663_c(name);
        this.func_149672_a(Block.field_149777_j);
        this.setHarvestLevel("pickaxe", 0);
        this.hasComparatorInputOverride = teClass != null && IComparatorOutput.class.isAssignableFrom(teClass);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity(this.teClass, (String)(this.name + "TileEntity"));
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.teClass != null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.teClass != null) {
            try {
                TileEntityEnder te = this.teClass.newInstance();
                te.init();
                return te;
            }
            catch (Exception e) {
                Log.error("Could not create tile entity for block " + this.name + " for class " + this.teClass);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("enderio:" + this.name);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        if (te instanceof ITankAccess) {
            if (FluidUtil.fillInternalTankFromPlayerHandItem(world, x, y, z, entityPlayer, (ITankAccess)te)) {
                return true;
            }
            if (FluidUtil.fillPlayerHandItemFromInternalTank(world, x, y, z, entityPlayer, (ITankAccess)te)) {
                return true;
            }
        }
        return this.openGui(world, x, y, z, entityPlayer, side);
    }

    protected boolean shouldWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return true;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return false;
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.doNormalDrops(world, x, y, z)) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getNBTDrop(world, x, y, z, (TileEntityEnder)world.func_147438_o(x, y, z))});
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getPickBlock(target, world, x, y, z, null);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, @Nullable EntityPlayer player) {
        return this.getNBTDrop(world, x, y, z, this.teClass != null ? this.getTileEntityEio((IBlockAccess)world, x, y, z) : null);
    }

    public ItemStack getNBTDrop(World world, int x, int y, int z, @Nullable TileEntityEnder te) {
        int meta = te != null ? this.func_149692_a(te.func_145832_p()) : world.func_72805_g(x, y, z);
        ItemStack itemStack = new ItemStack((Block)this, 1, meta);
        this.processDrop(world, x, y, z, te, itemStack);
        return itemStack;
    }

    protected void processDrop(World world, int x, int y, int z, @Nullable TileEntityEnder te, ItemStack drop) {
    }

    @Nullable
    protected TileEntityEnder getTileEntityEio(IBlockAccess world, int x, int y, int z) {
        TileEntity te;
        if (this.teClass != null && this.teClass.isInstance(te = world.func_147438_o(x, y, z))) {
            return (TileEntityEnder)te;
        }
        return null;
    }

    protected boolean shouldDoWorkThisTick(World world, int x, int y, int z, int interval) {
        TileEntityEnder te = this.getTileEntityEio((IBlockAccess)world, x, y, z);
        if (te == null) {
            return world.func_82737_E() % (long)interval == 0L;
        }
        return te.shouldDoWorkThisTick(interval);
    }

    protected boolean shouldDoWorkThisTick(World world, int x, int y, int z, int interval, int offset) {
        TileEntityEnder te = this.getTileEntityEio((IBlockAccess)world, x, y, z);
        if (te == null) {
            return (world.func_82737_E() + (long)offset) % (long)interval == 0L;
        }
        return te.shouldDoWorkThisTick(interval, offset);
    }

    public boolean func_149740_M() {
        return this.hasComparatorInputOverride;
    }

    public int func_149736_g(World w, int x, int y, int z, int side) {
        TileEntityEnder te;
        if (this.hasComparatorInputOverride && (te = this.getTileEntityEio((IBlockAccess)w, x, y, z)) != null) {
            return ((IComparatorOutput)((Object)te)).getComparatorOutput();
        }
        return 0;
    }

    public void setBlockBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.field_149759_B = minX;
        this.field_149760_C = minY;
        this.field_149754_D = minZ;
        this.field_149755_E = maxX;
        this.field_149756_F = maxY;
        this.field_149757_G = maxZ;
    }

    public void setBlockBounds(AxisAlignedBB bb) {
        this.setBlockBounds(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
    }
}

