/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.l\u043c\u043e;
import extracells.15_09_2024__02_32_46.p\u043c\u0440;
import extracells.container.ContainerFluidTerminal;
import extracells.container.ContainerGasTerminal;
import extracells.gridblock.ECBaseGridBlock;
import extracells.gui.GuiFluidTerminal;
import extracells.network.packet.part.PacketFluidTerminal;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.FluidUtil;
import extracells.util.PermissionUtil;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public class PartFluidTerminal
extends PartECBase
implements IGridTickable,
IInventoryUpdateReceiver,
ITerminalHost {
    protected Fluid currentFluid;
    private List<Object> containers = new ArrayList<Object>();
    protected ECPrivateInventory inventory;
    protected MachineSource machineSource;

    public PartFluidTerminal() {
        PartFluidTerminal $;
        $.inventory = new ECPrivateInventory(l\u043c\u043e."bn \u0443", 2, 64, $){

            @Override
            public boolean func_94041_b(int n, ItemStack itemStack) {
                return  .PartFluidTerminal.this.isItemValidForInputSlot(n, itemStack);
            }
        };
        $.machineSource = new MachineSource((IActionHost)$);
    }

    protected boolean isItemValidForInputSlot(int $, ItemStack $2) {
        return FluidUtil.isFluidContainer($2);
    }

    @Override
    public void getDrops(List<ItemStack> list, boolean bl) {
        for (ItemStack itemStack :  .inventory.slots) {
            if (itemStack == null) continue;
            list.add(itemStack);
        }
    }

    @Override
    public ItemStack getItemStack(PartItemStack $) {
        PartFluidTerminal $2;
        ItemStack $3 = super.getItemStack($);
        if ($.equals((Object)PartItemStack.Wrench)) {
            $3.func_77978_p().func_82580_o(p\u043c\u0440." elh");
        }
        return $3;
    }

    public void addContainer(ContainerFluidTerminal containerFluidTerminal) {
         .containers.add(containerFluidTerminal);
         .sendCurrentFluid();
    }

    public void addContainer(ContainerGasTerminal containerGasTerminal) {
         .containers.add(containerGasTerminal);
         .sendCurrentFluid();
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    public void decreaseFirstSlot() {
        PartFluidTerminal partFluidTerminal;
        ItemStack  2 = partFluidTerminal.inventory.func_70301_a(0);
        -- 2.field_77994_a;
        if ( 2.field_77994_a <= 0) {
            partFluidTerminal.inventory.func_70299_a(0, null);
        }
    }

    public void doWork() {
        PartFluidTerminal partFluidTerminal;
        ItemStack  2 = partFluidTerminal.inventory.func_70301_a(1);
        if ( 2 != null &&  2.field_77994_a >=  2.func_77976_d()) {
            return;
        }
        ItemStack  3 = partFluidTerminal.inventory.func_70301_a(0);
        if (!FluidUtil.isFluidContainer( 3)) {
            return;
        }
         3 =  3.func_77946_l();
         3.field_77994_a = 1;
        ECBaseGridBlock  4 = partFluidTerminal.getGridBlock();
        if ( 4 == null) {
            return;
        }
        IMEMonitor<IAEFluidStack>  5 =  4.getFluidMonitor();
        if ( 5 == null) {
            return;
        }
        if (FluidUtil.isEmpty( 3)) {
            if (partFluidTerminal.currentFluid == null) {
                return;
            }
            int n = FluidUtil.getCapacity( 3);
            IAEFluidStack  6 = (IAEFluidStack) 5.extractItems((IAEStack)FluidUtil.createAEFluidStack(partFluidTerminal.currentFluid, (long)n), Actionable.SIMULATE, (BaseActionSource)partFluidTerminal.machineSource);
              =  6 == null ? 0 : (int)Math.min((long)n,  6.getStackSize());
            MutablePair<Integer, ItemStack>  7 = FluidUtil.fillStack( 3, new FluidStack(partFluidTerminal.currentFluid,  ));
            if ((Integer) 7.getLeft() >  ) {
                return;
            }
            if (partFluidTerminal.fillSecondSlot((ItemStack) 7.getRight())) {
                 5.extractItems((IAEStack)FluidUtil.createAEFluidStack(partFluidTerminal.currentFluid, (long)((Integer) 7.getLeft()).intValue()), Actionable.MODULATE, (BaseActionSource)partFluidTerminal.machineSource);
                partFluidTerminal.decreaseFirstSlot();
            }
        } else {
            FluidStack  8 = FluidUtil.getFluidFromContainer( 3);
            IAEFluidStack  9 = (IAEFluidStack) 5.injectItems((IAEStack)FluidUtil.createAEFluidStack( 8), Actionable.SIMULATE, (BaseActionSource)partFluidTerminal.machineSource);
            if ( 9 != null) {
                return;
            }
            MutablePair<Integer, ItemStack>  10 = FluidUtil.drainStack( 3,  8);
            ItemStack  11 = (ItemStack) 10.getRight();
            if ( 11 == null || partFluidTerminal.fillSecondSlot( 11)) {
                 5.injectItems((IAEStack)FluidUtil.createAEFluidStack( 8), Actionable.MODULATE, (BaseActionSource)partFluidTerminal.machineSource);
                partFluidTerminal.decreaseFirstSlot();
            }
        }
    }

    public boolean fillSecondSlot(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
         \u000a\u000a\u000a
         =  \u000a\u000a\u000a
        .inventory.func_70301_a(1);
        if ( \u000a\u000a\u000a
         == null) {
             \u000a\u000a\u000a
            .inventory.func_70299_a(1, itemStack);
            return true;
        }
        if (! \u000a\u000a\u000a
        .func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack) \u000a\u000a\u000a
        )) {
            return false;
        }
         \u000a\u000a\u000a
        .inventory.incrStackSize(1, itemStack.field_77994_a);
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper iPartCollisionHelper) {
        iPartCollisionHelper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        iPartCollisionHelper.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        iPartCollisionHelper.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer entityPlayer) {
        return new GuiFluidTerminal( , entityPlayer);
    }

    public IInventory getInventory() {
        PartFluidTerminal partFluidTerminal;
        return partFluidTerminal.inventory;
    }

    @Override
    public double getPowerUsage() {
        return 0.5;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer entityPlayer) {
        return new ContainerFluidTerminal( , entityPlayer);
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 20, false, false);
    }

    @Override
    public boolean onActivate(EntityPlayer $, Vec3 $2) {
        PartFluidTerminal $3;
        if ($.field_70170_p.field_72995_K) {
            return true;
        }
        if ($3.isActive() && (PermissionUtil.hasPermission($, SecurityPermissions.INJECT, $3) || PermissionUtil.hasPermission($, SecurityPermissions.EXTRACT, $3))) {
            return super.onActivate($, $2);
        }
        return false;
    }

    @Override
    public void onInventoryChanged() {
        PartFluidTerminal partFluidTerminal;
        partFluidTerminal.saveData();
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
        \u000a\u000a
        .inventory.readFromNBT(nBTTagCompound.func_150295_c(p\u043c\u0440." elh", 10));
    }

    public void removeContainer(ContainerFluidTerminal containerFluidTerminal) {
         .containers.remove(containerFluidTerminal);
    }

    public void removeContainer(ContainerGasTerminal containerGasTerminal) {
         .containers.remove(containerGasTerminal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon  2 = TextureManager.TERMINAL_SIDE.getTexture();
        iPartRenderHelper.setTexture( 2);
        iPartRenderHelper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
        iPartRenderHelper.setTexture( 2,  2,  2, TextureManager.BUS_BORDER.getTexture(),  2,  2);
        iPartRenderHelper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
        tessellator.func_78380_c(0xD000D0);
        iPartRenderHelper.setInvColor(0xFFFFFF);
        iPartRenderHelper.renderInventoryFace(TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        iPartRenderHelper.setInvColor(AEColor.Transparent.blackVariant);
        iPartRenderHelper.renderInventoryFace(TextureManager.TERMINAL_FRONT.getTextures()[0], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setInvColor(AEColor.Transparent.mediumVariant);
        iPartRenderHelper.renderInventoryFace(TextureManager.TERMINAL_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setInvColor(AEColor.Transparent.whiteVariant);
        iPartRenderHelper.renderInventoryFace(TextureManager.TERMINAL_FRONT.getTextures()[2], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
         .renderInventoryBusLights(iPartRenderHelper, renderBlocks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int $, int $2, int $3, IPartRenderHelper $4, RenderBlocks $5) {
        PartFluidTerminal $6;
        Tessellator $7 = Tessellator.field_78398_a;
        IIcon $8 = TextureManager.TERMINAL_SIDE.getTexture();
        $4.setTexture($8);
        $4.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        $4.renderBlock($, $2, $3, $5);
        $4.setTexture($8, $8, $8, TextureManager.BUS_BORDER.getTexture(), $8, $8);
        $4.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        $4.renderBlock($, $2, $3, $5);
        if ($6.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        $7.func_78378_d(0xFFFFFF);
        $4.renderFace($, $2, $3, TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, $5);
        IPartHost $9 = $6.getHost();
        $4.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        $7.func_78378_d($9.getColor().blackVariant);
        $4.renderFace($, $2, $3, TextureManager.TERMINAL_FRONT.getTextures()[0], ForgeDirection.SOUTH, $5);
        $7.func_78378_d($9.getColor().mediumVariant);
        $4.renderFace($, $2, $3, TextureManager.TERMINAL_FRONT.getTextures()[1], ForgeDirection.SOUTH, $5);
        $7.func_78378_d($9.getColor().whiteVariant);
        $4.renderFace($, $2, $3, TextureManager.TERMINAL_FRONT.getTextures()[2], ForgeDirection.SOUTH, $5);
        $4.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        $6.renderStaticBusLights($, $2, $3, $4, $5);
    }

    public void sendCurrentFluid() {
        PartFluidTerminal $;
        for (Object $2 : $.containers) {
            $.sendCurrentFluid($2);
        }
    }

    public void sendCurrentFluid(Object $) {
        PartFluidTerminal $2;
        if ($ instanceof ContainerFluidTerminal) {
            ContainerFluidTerminal $3 = (ContainerFluidTerminal)$;
            new PacketFluidTerminal($3.getPlayer(), $2.currentFluid).sendPacketToPlayer($3.getPlayer());
        } else if ($ instanceof ContainerGasTerminal) {
            ContainerGasTerminal $4 = (ContainerGasTerminal)$;
            new PacketFluidTerminal($4.getPlayer(), $2.currentFluid).sendPacketToPlayer($4.getPlayer());
        }
    }

    public void setCurrentFluid(Fluid fluid) {
         .currentFluid = fluid;
         .sendCurrentFluid();
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int n) {
         .doWork();
        return TickRateModulation.FASTER;
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        nBTTagCompound.func_74782_a(p\u043c\u0440." elh", (NBTBase)$ .inventory.writeToNBT());
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return null;
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        PartFluidTerminal partFluidTerminal;
        ECBaseGridBlock \u000a\u000a\u000a\u000a\u000a2 = partFluidTerminal.getGridBlock();
        return \u000a\u000a\u000a\u000a\u000a2 == null ? null : \u000a\u000a\u000a\u000a\u000a2.getFluidMonitor();
    }

    public IConfigManager getConfigManager() {
        return null;
    }
}

