/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import extracells.api.IFluidStorageCell;
import extracells.inventory.HandlerItemPlayerStorageFluid;
import extracells.inventory.HandlerItemStorageFluid;
import extracells.network.GuiHandler;
import extracells.render.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class FluidCellHandler
implements ICellHandler {
    public FluidCellHandler() {
        FluidCellHandler $;
    }

    public double cellIdleDrain(ItemStack itemStack, IMEInventory iMEInventory) {
        return 0.0;
    }

    public IMEInventoryHandler getCellInventory(ItemStack itemStack, ISaveProvider iSaveProvider, StorageChannel storageChannel) {
        if (storageChannel == StorageChannel.ITEMS || !(itemStack.func_77973_b() instanceof IFluidStorageCell)) {
            return null;
        }
        return new HandlerItemStorageFluid(itemStack, iSaveProvider, ((IFluidStorageCell)itemStack.func_77973_b()).getFilter(itemStack));
    }

    public IMEInventoryHandler getCellInventoryPlayer(ItemStack itemStack, EntityPlayer entityPlayer) {
        return new HandlerItemPlayerStorageFluid(itemStack, null, ((IFluidStorageCell)itemStack.func_77973_b()).getFilter(itemStack), entityPlayer);
    }

    public int getStatusForCell(ItemStack itemStack, IMEInventory iMEInventory) {
        if (iMEInventory == null) {
            return 0;
        }
        HandlerItemStorageFluid handlerItemStorageFluid = (HandlerItemStorageFluid)iMEInventory;
        if (handlerItemStorageFluid.freeBytes() == 0) {
            return 3;
        }
        if (handlerItemStorageFluid.isFormatted() || handlerItemStorageFluid.usedTypes() == handlerItemStorageFluid.totalTypes()) {
            return 2;
        }
        return 1;
    }

    public IIcon getTopTexture_Dark() {
        return TextureManager.TERMINAL_FRONT.getTextures()[0];
    }

    public IIcon getTopTexture_Light() {
        return TextureManager.TERMINAL_FRONT.getTextures()[2];
    }

    public IIcon getTopTexture_Medium() {
        return TextureManager.TERMINAL_FRONT.getTextures()[1];
    }

    public boolean isCell(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof IFluidStorageCell;
    }

    public void openChestGui(EntityPlayer entityPlayer, IChestOrDrive iChestOrDrive, ICellHandler iCellHandler, IMEInventoryHandler iMEInventoryHandler, ItemStack itemStack, StorageChannel storageChannel) {
        if (storageChannel != StorageChannel.FLUIDS) {
            return;
        }
        IStorageMonitorable iStorageMonitorable = null;
        if (iChestOrDrive != null) {
            iStorageMonitorable = ((IMEChest)iChestOrDrive).getMonitorable(ForgeDirection.UNKNOWN, (BaseActionSource)new PlayerSource(entityPlayer, (IActionHost)iChestOrDrive));
        }
        if (iStorageMonitorable != null) {
            GuiHandler.THIS().launchGui(GuiHandler.getGuiId(0), entityPlayer, new Object[]{iStorageMonitorable.getFluidInventory()});
        }
    }
}

