/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import extracells.item.ItemFluidPattern;
import extracells.registries.ItemEnum;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.MutablePair;

public class FluidUtil {
    public FluidUtil() {
        FluidUtil fluidUtil;
    }

    public static IAEFluidStack createAEFluidStack(Fluid $) {
        return FluidUtil.createAEFluidStack(new FluidStack($, 1000));
    }

    public static IAEFluidStack createAEFluidStack(Fluid fluid, long l) {
        return FluidUtil.createAEFluidStack(fluid.getID(), l);
    }

    public static IAEFluidStack createAEFluidStack(FluidStack $) {
        return AEApi.instance().storage().createFluidStack($);
    }

    public static IAEFluidStack createAEFluidStack(int n, long l) {
        return (IAEFluidStack)FluidUtil.createAEFluidStack(new FluidStack(FluidRegistry.getFluid((int)n), 1)).setStackSize(l);
    }

    public static MutablePair<Integer, ItemStack> drainStack(ItemStack itemStack, FluidStack fluidStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack fluidStack2 = ((IFluidContainerItem)item).drain(itemStack, fluidStack.amount, true);
            int  2 = fluidStack2 != null && fluidStack2.getFluid() == fluidStack.getFluid() ? fluidStack2.amount : 0;
            return new MutablePair((Object) 2, (Object)itemStack);
        }
        if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
              = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
            int  3 =   != null &&  .getFluid() == fluidStack.getFluid() ?  .amount : 0;
            return new MutablePair((Object) 3, (Object)itemStack.func_77973_b().getContainerItem(itemStack));
        }
        return null;
    }

    public static MutablePair<Integer, ItemStack> fillStack(ItemStack itemStack2, FluidStack fluidStack) {
        ItemStack itemStack2;
        if (itemStack2 == null) {
            return null;
        }
        Item item = itemStack2.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            int n = ((IFluidContainerItem)item).fill(itemStack2, fluidStack, true);
            return new MutablePair((Object)n, (Object)itemStack2);
        }
        if (FluidContainerRegistry.isContainer((ItemStack)itemStack2)) {
              = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack2);
            FluidStack fluidStack2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack) );
            return new MutablePair((Object)(fluidStack2 != null ? fluidStack2.amount : 0), (Object) );
        }
        if (item == ItemEnum.FLUIDPATTERN.getItem()) {
            return new MutablePair((Object)0, (Object)ItemFluidPattern.getPatternForFluid(fluidStack.getFluid()));
        }
        return null;
    }

    public static int getCapacity(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)item).getCapacity(itemStack);
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
            for (FluidContainerRegistry.FluidContainerData fluidContainerData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (fluidContainerData == null || !fluidContainerData.emptyContainer.func_77969_a(itemStack)) continue;
                FluidStack fluidStack = fluidContainerData.fluid;
                return fluidStack != null ? fluidStack.amount : 0;
            }
        }
        return 0;
    }

    public static FluidStack getFluidFromContainer(ItemStack itemStack) {
        ItemStack itemStack2;
        if (itemStack == null) {
            return null;
        }
        itemStack2 = itemStack.func_77946_l();
        Item item = itemStack2.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)item).getFluid(itemStack2);
        }
        if (item == ItemEnum.FLUIDPATTERN.getItem()) {
            Fluid fluid = ItemFluidPattern.getFluid(itemStack);
            return fluid != null ? new FluidStack(fluid, 0) : null;
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack2);
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack fluidStack = ((IFluidContainerItem)item).getFluid(itemStack);
            return fluidStack == null || fluidStack.amount <= 0;
        }
        return item == ItemEnum.FLUIDPATTERN.getItem() || FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack);
    }

    public static boolean isFilled(ItemStack itemStack2) {
        ItemStack itemStack2;
        if (itemStack2 == null) {
            return false;
        }
        Item item = itemStack2.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack fluidStack = ((IFluidContainerItem)item).getFluid(itemStack2);
            return fluidStack != null && fluidStack.amount > 0;
        }
        return FluidContainerRegistry.isFilledContainer((ItemStack)itemStack2);
    }

    public static boolean isFluidContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof IFluidContainerItem || item == ItemEnum.FLUIDPATTERN.getItem() || FluidContainerRegistry.isContainer((ItemStack)itemStack);
    }
}

