/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import extracells.integration.mekanism.gas.MekanismGas;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public class GasUtil {
    public GasUtil() {
        GasUtil gasUtil;
    }

    public static IAEFluidStack createAEFluidStack(Gas gas) {
        return GasUtil.createAEFluidStack(new FluidStack(MekanismGas.getFluidGasMap().get(gas), 1000));
    }

    public static IAEFluidStack createAEFluidStack(GasStack gasStack) {
        return gasStack == null ? null : GasUtil.createAEFluidStack(new FluidStack(MekanismGas.getFluidGasMap().get(gasStack.getGas()), gasStack.amount));
    }

    public static IAEFluidStack createAEFluidStack(FluidStack fluidStack) {
        return AEApi.instance().storage().createFluidStack(fluidStack);
    }

    public static IAEFluidStack createAEFluidStack(Gas gas, long l) {
        return (IAEFluidStack)GasUtil.createAEFluidStack(new FluidStack(MekanismGas.getFluidGasMap().get(gas), 1)).setStackSize(l);
    }

    public static MutablePair<Integer, ItemStack> drainStack(ItemStack itemStack, GasStack gasStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            GasStack gasStack2 = ((IGasItem)item).removeGas(itemStack, gasStack.amount);
            int  2 = gasStack2 != null && gasStack2.getGas() == gasStack.getGas() ? gasStack2.amount : 0;
            return new MutablePair((Object) 2, (Object)itemStack);
        }
        return null;
    }

    public static MutablePair<Integer, ItemStack> fillStack(ItemStack itemStack, GasStack gasStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            int n = ((IGasItem)item).addGas(itemStack, gasStack);
            return new MutablePair((Object)n, (Object)itemStack);
        }
        return null;
    }

    public static int getCapacity(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            return ((IGasItem)item).getMaxGas(itemStack);
        }
        return 0;
    }

    public static GasStack getGasFromContainer(ItemStack $) {
        if ($ == null) {
            return null;
        }
        ItemStack $2 = $.func_77946_l();
        Item $3 = $2.func_77973_b();
        if ($3 instanceof IGasItem) {
            return ((IGasItem)$3).getGas($);
        }
        return null;
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            GasStack gasStack = ((IGasItem)item).getGas(itemStack);
            return gasStack == null || gasStack.amount <= 0;
        }
        return false;
    }

    public static boolean isFilled(ItemStack itemStack2) {
        ItemStack itemStack2;
        if (itemStack2 == null) {
            return false;
        }
        Item item = itemStack2.func_77973_b();
        if (item instanceof IGasItem) {
            GasStack gasStack = ((IGasItem)item).getGas(itemStack2);
            return gasStack != null && gasStack.amount > 0;
        }
        return FluidContainerRegistry.isFilledContainer((ItemStack)itemStack2);
    }

    public static boolean isGasContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof IGasItem;
    }

    public static GasStack getGasStack(FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid instanceof MekanismGas.GasFluid) {
            return new GasStack(((MekanismGas.GasFluid)fluid).getGas(), fluidStack.amount);
        }
        return null;
    }

    public static GasStack getGasStack(IAEFluidStack iAEFluidStack) {
        if (iAEFluidStack == null) {
            return null;
        }
        Fluid fluid = iAEFluidStack.getFluid();
        if (fluid instanceof MekanismGas.GasFluid) {
            return new GasStack(((MekanismGas.GasFluid)fluid).getGas(), (int)iAEFluidStack.getStackSize());
        }
        return null;
    }

    public static FluidStack getFluidStack(GasStack gasStack) {
        if (gasStack == null) {
            return null;
        }
        Fluid fluid = MekanismGas.getFluidGasMap().get(gasStack.getGas());
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, gasStack.amount);
    }

    public static boolean isGas(FluidStack fluidStack) {
        return fluidStack != null && GasUtil.isGas(fluidStack.getFluid());
    }

    public static boolean isGas(Fluid $) {
        return $ != null && $ instanceof MekanismGas.GasFluid;
    }

    public static Gas getGas(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid instanceof MekanismGas.GasFluid) {
            return ((MekanismGas.GasFluid)fluid).getGas();
        }
        return null;
    }
}

