/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import com.google.common.collect.Lists;
import gravisuite.BlockRelocatorPortal;
import gravisuite.item.ItemRelocator;
import gravisuite.utils.Helpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class TileEntityRelocatorPortal
extends TileEntity {
    private int timerTicks = 0;
    private final int maxTime;
    private final int maxCoolDownTime;
    public ItemRelocator.TeleportPoint parentTeleportPoint = null;
    private final List<EntityInfo> entityList = Lists.newArrayList();

    public TileEntityRelocatorPortal() {
        this.maxTime = 500;
        this.maxCoolDownTime = 60;
    }

    public boolean canUpdate() {
        return Minecraft.func_71410_x().func_71356_B();
    }

    public void func_145845_h() {
        ++this.timerTicks;
        if (!this.field_145850_b.field_72995_K) {
            this.updateEntityCoolDown();
            this.checkParentPortal();
        }
        if (this.timerTicks >= this.maxTime && !this.field_145850_b.field_72995_K) {
            WorldServer targetServer;
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.parentTeleportPoint != null && (targetServer = minecraftserver.func_71218_a(this.parentTeleportPoint.dimID)) != null) {
                targetServer.field_73059_b.func_73158_c((int)this.parentTeleportPoint.x >> 4, (int)this.parentTeleportPoint.z >> 4);
                Block block = targetServer.func_147439_a((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
                if (block == null) {
                    return;
                }
                if (block instanceof BlockRelocatorPortal) {
                    targetServer.func_147468_f((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
                    targetServer.func_147479_m((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
                    targetServer.func_147475_p((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
                }
            }
        }
    }

    public void checkParentPortal() {
        if (this.parentTeleportPoint != null) {
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            WorldServer targetServer = minecraftserver.func_71218_a(this.parentTeleportPoint.dimID);
            targetServer.field_73059_b.func_73158_c((int)this.parentTeleportPoint.x >> 4, (int)this.parentTeleportPoint.z >> 4);
            Block block = targetServer.func_147439_a((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
            if (block == null) {
                return;
            }
            if (!(block instanceof BlockRelocatorPortal)) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void updateEntityCoolDown() {
        if (this.entityList.size() > 0) {
            for (EntityInfo entityInfo : this.entityList) {
                --entityInfo.portalCooldown;
                if (entityInfo.portalCooldown >= 0) continue;
                entityInfo.portalCooldown = 0;
            }
            this.func_70296_d();
        }
    }

    public int getCoolDownTime(Entity entity) {
        if (this.entityList.size() > 0) {
            for (EntityInfo point : this.entityList) {
                if (!point.entityID.equals(entity.getPersistentID().toString())) continue;
                return point.portalCooldown;
            }
        }
        return 0;
    }

    public void addEntityToList(Entity entity) {
        boolean entityFound = Boolean.FALSE;
        if (this.entityList.size() > 0) {
            for (EntityInfo point : this.entityList) {
                if (!point.entityID.equals(entity.getPersistentID().toString())) continue;
                point.portalCooldown = this.maxCoolDownTime;
                point.yaw = entity.field_70177_z - 180.0f;
                entityFound = Boolean.TRUE;
            }
        }
        if (!entityFound) {
            EntityInfo newPoint = new EntityInfo();
            newPoint.entityID = entity.getPersistentID().toString();
            newPoint.yaw = entity.field_70177_z - 180.0f;
            newPoint.portalCooldown = this.maxCoolDownTime;
            this.entityList.add(newPoint);
        }
    }

    public void TeleportEntity(Entity entity) {
        if (this.parentTeleportPoint != null) {
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            WorldServer targetServer = minecraftserver.func_71218_a(this.parentTeleportPoint.dimID);
            if (targetServer == null) {
                return;
            }
            targetServer.field_73059_b.func_73158_c((int)this.parentTeleportPoint.x >> 4, (int)this.parentTeleportPoint.z >> 4);
            TileEntity tileEntity = targetServer.func_147438_o((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
            if (tileEntity instanceof TileEntityRelocatorPortal) {
                ((TileEntityRelocatorPortal)tileEntity).addEntityToList(entity);
            }
            double userYaw = this.parentTeleportPoint.yaw;
            if (this.entityList.size() > 0) {
                for (EntityInfo point : this.entityList) {
                    if (!point.entityID.equals(entity.getPersistentID().toString())) continue;
                    userYaw = point.yaw;
                }
            }
            ItemRelocator.TeleportPoint tmpPoint = new ItemRelocator.TeleportPoint();
            tmpPoint.dimID = this.parentTeleportPoint.dimID;
            tmpPoint.x = this.parentTeleportPoint.x;
            tmpPoint.y = this.parentTeleportPoint.y;
            tmpPoint.z = this.parentTeleportPoint.z;
            tmpPoint.yaw = userYaw;
            tmpPoint.pitch = entity.field_70125_A;
            Helpers.teleportEntity(entity, tmpPoint);
        }
    }

    public void setParentPortal(ItemRelocator.TeleportPoint parentPoint) {
        if (this.parentTeleportPoint != null) {
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            WorldServer targetServer = minecraftserver.func_71218_a(this.parentTeleportPoint.dimID);
            if (targetServer == null) {
                return;
            }
            targetServer.field_73059_b.func_73158_c((int)this.parentTeleportPoint.x >> 4, (int)this.parentTeleportPoint.z >> 4);
            Block block = targetServer.func_147439_a((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
            if (block == null) {
                return;
            }
            if (block instanceof BlockRelocatorPortal) {
                targetServer.func_147468_f((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
                targetServer.func_147479_m((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
                targetServer.func_147475_p((int)this.parentTeleportPoint.x, (int)this.parentTeleportPoint.y, (int)this.parentTeleportPoint.z);
            }
        }
        this.parentTeleportPoint = parentPoint;
        this.resetTimer();
        this.func_70296_d();
    }

    public void resetTimer() {
        this.timerTicks = 0;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        boolean haveParent = nbttagcompound.func_74767_n("parentPortal");
        if (haveParent) {
            if (this.parentTeleportPoint == null) {
                this.parentTeleportPoint = new ItemRelocator.TeleportPoint();
            }
            this.parentTeleportPoint.dimID = nbttagcompound.func_74762_e("parentDimId");
            this.parentTeleportPoint.x = nbttagcompound.func_74769_h("parentPosX");
            this.parentTeleportPoint.y = nbttagcompound.func_74769_h("parentPosY");
            this.parentTeleportPoint.z = nbttagcompound.func_74769_h("parentPosZ");
        }
        this.timerTicks = nbttagcompound.func_74762_e("timerTicks");
        NBTTagList list = nbttagcompound.func_150295_c("entityList", 10);
        ArrayList tpList = Lists.newArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            EntityInfo newPoint = new EntityInfo();
            NBTTagCompound loadedPoint = list.func_150305_b(i);
            newPoint.entityID = loadedPoint.func_74779_i("entityID");
            newPoint.yaw = loadedPoint.func_74769_h("entityYaw");
            newPoint.portalCooldown = loadedPoint.func_74762_e("entityCoolDown");
            tpList.add(newPoint);
        }
        if (tpList.size() > 0) {
            this.entityList.clear();
            this.entityList.addAll(tpList);
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        new NBTTagList();
        if (this.parentTeleportPoint != null) {
            nbttagcompound.func_74757_a("parentPortal", true);
            nbttagcompound.func_74768_a("parentDimId", this.parentTeleportPoint.dimID);
            nbttagcompound.func_74780_a("parentPosX", this.parentTeleportPoint.x);
            nbttagcompound.func_74780_a("parentPosY", this.parentTeleportPoint.y);
            nbttagcompound.func_74780_a("parentPosZ", this.parentTeleportPoint.z);
        } else {
            nbttagcompound.func_74757_a("parentPortal", false);
        }
        nbttagcompound.func_74768_a("timerTicks", this.timerTicks);
        NBTTagList nbtList = new NBTTagList();
        for (EntityInfo point : this.entityList) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("entityID", point.entityID);
            nbt.func_74780_a("entityYaw", point.yaw);
            nbt.func_74780_a("entityCoolDown", (double)point.portalCooldown);
            nbtList.func_74742_a((NBTBase)nbt);
        }
        nbttagcompound.func_74782_a("entityList", (NBTBase)nbtList);
    }

    public static class EntityInfo {
        public String entityID;
        public double yaw;
        public int portalCooldown;
    }
}

