/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.client;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.EntityPlasmaBall;
import gravisuite.utils.RenderHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPlasmaBall
extends Render {
    private static final ResourceLocation plazmaTextloc = new ResourceLocation("gravisuite", "textures/models/plazma.png");
    private static final ResourceLocation particlesTextloc = new ResourceLocation("gravisuite", "textures/models/particles.png");
    private static final Table<String, Integer, Integer> textureSizeCache = HashBasedTable.create();
    public int ticker;

    public RenderPlasmaBall(float p_i1254_1_) {
    }

    public static int getTextureSize(String s, int dv) {
        if (textureSizeCache.get((Object)s, (Object)dv) != null) {
            return (Integer)textureSizeCache.get((Object)s, (Object)dv);
        }
        try {
            InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("advancedsolarpanel", s)).func_110527_b();
            if (inputstream == null) {
                throw new Exception("Image not found: " + s);
            }
            BufferedImage bi = ImageIO.read(inputstream);
            int size = bi.getWidth() / dv;
            textureSizeCache.put((Object)s, (Object)dv, (Object)size);
            return size;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return 16;
        }
    }

    public void renderCore(EntityPlasmaBall entity, double x, double y, double z, float fq, float pticks) {
        int size1 = RenderPlasmaBall.getTextureSize("textures/models/plazma.png", 64);
        int size2 = RenderPlasmaBall.getTextureSize("textures/models/particles.png", 32);
        float f1 = ActiveRenderInfo.field_74588_d;
        float f2 = ActiveRenderInfo.field_74589_e;
        float f3 = ActiveRenderInfo.field_74586_f;
        float f4 = ActiveRenderInfo.field_74587_g;
        float f5 = ActiveRenderInfo.field_74596_h;
        float scaleCore = 1.0f;
        double posY = (float)y;
        double posZ = (float)z;
        Tessellator tessellator = Tessellator.field_78398_a;
        Color color = RenderHelper.convertRGBtoColor(226, 88, 255);
        if (entity.getActionType() == 0) {
            color = RenderHelper.convertRGBtoColor(254, 255, 131);
        }
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(plazmaTextloc);
        int i = entity.field_70173_aa % 16;
        float size4 = size1 * 4;
        float float_sizeMinus0_01 = (float)size1 - 0.01f;
        float x0 = ((float)(i % 4 * size1) + 0.0f) / size4;
        float x1 = ((float)(i % 4 * size1) + float_sizeMinus0_01) / size4;
        float x2 = ((float)(i / 4 * size1) + 0.0f) / size4;
        float x3 = ((float)(i / 4 * size1) + float_sizeMinus0_01) / size4;
        tessellator.func_78382_b();
        tessellator.func_78380_c(240);
        tessellator.func_78369_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        tessellator.func_78374_a(x - (double)(f1 * scaleCore) - (double)(f4 * scaleCore), posY - (double)(f2 * scaleCore), posZ - (double)(f3 * scaleCore) - (double)(f5 * scaleCore), (double)x1, (double)x3);
        tessellator.func_78374_a(x - (double)(f1 * scaleCore) + (double)(f4 * scaleCore), posY + (double)(f2 * scaleCore), posZ - (double)(f3 * scaleCore) + (double)(f5 * scaleCore), (double)x1, (double)x2);
        tessellator.func_78374_a(x + (double)(f1 * scaleCore) + (double)(f4 * scaleCore), posY + (double)(f2 * scaleCore), posZ + (double)(f3 * scaleCore) + (double)(f5 * scaleCore), (double)x0, (double)x2);
        tessellator.func_78374_a(x + (double)(f1 * scaleCore) - (double)(f4 * scaleCore), posY - (double)(f2 * scaleCore), posZ + (double)(f3 * scaleCore) - (double)(f5 * scaleCore), (double)x0, (double)x3);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(particlesTextloc);
        int qq = entity.field_70173_aa % 16;
        i = 24 + qq;
        float size8 = size2 * 8;
        float_sizeMinus0_01 = (float)size2 - 0.01f;
        x0 = ((float)(i % 8 * size2) + 0.0f) / size8;
        x1 = ((float)(i % 8 * size2) + float_sizeMinus0_01) / size8;
        x2 = ((float)(i / 8 * size2) + 0.0f) / size8;
        x3 = ((float)(i / 8 * size2) + float_sizeMinus0_01) / size8;
        float var11 = MathHelper.func_76126_a((float)(((float)entity.field_70173_aa + pticks) / 10.0f)) * 0.1f;
        scaleCore = 0.4f + var11;
        tessellator.func_78382_b();
        tessellator.func_78380_c(240);
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        tessellator.func_78374_a(x - (double)(f1 * scaleCore) - (double)(f4 * scaleCore), posY - (double)(f2 * scaleCore), posZ - (double)(f3 * scaleCore) - (double)(f5 * scaleCore), (double)x1, (double)x3);
        tessellator.func_78374_a(x - (double)(f1 * scaleCore) + (double)(f4 * scaleCore), posY + (double)(f2 * scaleCore), posZ - (double)(f3 * scaleCore) + (double)(f5 * scaleCore), (double)x1, (double)x2);
        tessellator.func_78374_a(x + (double)(f1 * scaleCore) + (double)(f4 * scaleCore), posY + (double)(f2 * scaleCore), posZ + (double)(f3 * scaleCore) + (double)(f5 * scaleCore), (double)x0, (double)x2);
        tessellator.func_78374_a(x + (double)(f1 * scaleCore) - (double)(f4 * scaleCore), posY - (double)(f2 * scaleCore), posZ + (double)(f3 * scaleCore) - (double)(f5 * scaleCore), (double)x0, (double)x3);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float fq, float ticks) {
        this.renderCore((EntityPlasmaBall)entity, x, y, z, fq, ticks);
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return plazmaTextloc;
    }
}

