/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.client.gui;

import gravisuite.BlockLocation;
import gravisuite.client.gui.component.TexturedButton;
import gravisuite.item.ItemAdvDDrill;
import gravisuite.item.ItemAdvIDrill;
import gravisuite.network.PacketGuiOpen;
import gravisuite.network.PacketSaveToolConfig;
import gravisuite.utils.Helpers;
import gravisuite.utils.NBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiToolConfig
extends GuiScreen {
    private static ResourceLocation tex = new ResourceLocation("gravisuite", "textures/gui/ToolConfig.png");
    private int whiteListMode = 0;
    private int itemMode = 0;
    private int expMode = 0;
    private int tpToHomeMode = 0;
    private int fastDespawnMode = 0;
    BlockLocation location;
    private boolean isIridiumDrill = false;
    private ForgeDirection houseSide;

    public GuiToolConfig(EntityPlayer player) {
        if (player.func_70694_bm().func_77973_b() instanceof ItemAdvIDrill) {
            this.whiteListMode = NBTHelper.getWhiteListMode(player.func_70694_bm());
            this.itemMode = NBTHelper.getItemMode(player.func_70694_bm());
            this.expMode = NBTHelper.getExpMode(player.func_70694_bm());
            this.tpToHomeMode = NBTHelper.getTpToHomeMode(player.func_70694_bm());
            this.fastDespawnMode = NBTHelper.getFastDespawnMode(player.func_70694_bm());
            this.location = NBTHelper.getHomeLocation(player.func_70694_bm());
            this.isIridiumDrill = true;
            this.houseSide = ForgeDirection.getOrientation((int)NBTHelper.getOrCreateNbtData(player.func_70694_bm()).func_74775_l("HomeLocation").func_74771_c("Side"));
        } else if (player.func_70694_bm().func_77973_b() instanceof ItemAdvDDrill) {
            this.whiteListMode = NBTHelper.getWhiteListMode(player.func_70694_bm());
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new TexturedButton(this, 0, 20, 20, 0, "BlackList"));
        this.field_146292_n.add(new TexturedButton(this, 1, 91, 20, 1, "WhiteList", 0));
        if (this.isIridiumDrill) {
            this.field_146292_n.add(new TexturedButton(this, 2, 118, 36, 24, 13, 5, "On", 0xFFFFFF));
            this.field_146292_n.add(new TexturedButton(this, 3, 118, 36, 24, 13, 6, "Off", 0xFFFFFF));
            this.field_146292_n.add(new TexturedButton(this, 4, 118, 52, 24, 13, 5, "On", 0xFFFFFF));
            this.field_146292_n.add(new TexturedButton(this, 5, 118, 52, 24, 13, 6, "Off", 0xFFFFFF));
            this.field_146292_n.add(new TexturedButton(this, 6, 118, 68, 24, 13, 5, "On", 0xFFFFFF));
            this.field_146292_n.add(new TexturedButton(this, 7, 118, 68, 24, 13, 6, "Off", 0xFFFFFF));
            this.field_146292_n.add(new TexturedButton(this, 8, 118, 84, 24, 13, 5, "On", 0xFFFFFF));
            this.field_146292_n.add(new TexturedButton(this, 9, 118, 84, 24, 13, 6, "Off", 0xFFFFFF));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.isIridiumDrill) {
            PacketSaveToolConfig.issue(this.whiteListMode, this.itemMode, this.expMode, this.fastDespawnMode, this.tpToHomeMode);
        } else {
            PacketSaveToolConfig.issue(this.whiteListMode);
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char par1, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_146284_a(GuiButton guiButton) {
        switch (guiButton.field_146127_k) {
            case 0: {
                PacketGuiOpen.issue(4);
                break;
            }
            case 1: {
                PacketGuiOpen.issue(5);
                break;
            }
            case 2: 
            case 3: {
                ++this.itemMode;
                if (this.itemMode <= 1) break;
                this.itemMode = 0;
                break;
            }
            case 4: 
            case 5: {
                ++this.fastDespawnMode;
                if (this.fastDespawnMode <= 1) break;
                this.fastDespawnMode = 0;
                break;
            }
            case 6: 
            case 7: {
                ++this.expMode;
                if (this.expMode <= 1) break;
                this.expMode = 0;
                break;
            }
            case 8: 
            case 9: {
                ++this.tpToHomeMode;
                if (this.tpToHomeMode <= 1) break;
                this.tpToHomeMode = 0;
            }
        }
        super.func_146284_a(guiButton);
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        if (this.isPointInRegion(74, 22, 14, 9, x, y)) {
            ++this.whiteListMode;
            if (this.whiteListMode >= 3) {
                this.whiteListMode = 0;
            }
            try {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            catch (Exception var5) {
                var5.printStackTrace();
            }
        }
    }

    private boolean isPointInRegion(int left, int top, int width, int height, int mouseX, int mouseY) {
        int k1 = (this.field_146294_l - 162) / 2;
        int l1 = (this.field_146295_m - 129) / 2;
        return (mouseX -= k1) >= left - 1 && mouseX < left + width + 1 && (mouseY -= l1) >= top - 1 && mouseY < top + height + 1;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        int xStart = (this.field_146294_l - 162) / 2;
        int yStart = (this.field_146295_m - 129) / 2;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_73729_b(xStart, yStart, 0, 0, 162, 129);
        if (this.whiteListMode == 0) {
            if (!this.isPointInRegion(74, 20, 14, 14, mouseX, mouseY)) {
                this.func_73729_b(xStart + 74, yStart + 20, 135, 135, 14, 14);
            } else {
                this.func_73729_b(xStart + 74, yStart + 20, 150, 135, 14, 14);
            }
        } else if (this.whiteListMode == 1) {
            if (!this.isPointInRegion(74, 22, 14, 9, mouseX, mouseY)) {
                this.func_73729_b(xStart + 74, yStart + 22, 105, 135, 14, 9);
            } else {
                this.func_73729_b(xStart + 74, yStart + 22, 120, 135, 14, 9);
            }
        } else if (this.whiteListMode == 2) {
            if (!this.isPointInRegion(74, 22, 14, 9, mouseX, mouseY)) {
                this.func_73729_b(xStart + 74, yStart + 22, 105, 145, 14, 9);
            } else {
                this.func_73729_b(xStart + 74, yStart + 22, 120, 145, 14, 9);
            }
        }
        if (this.isIridiumDrill) {
            if (this.itemMode == 0) {
                ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = true;
            } else {
                ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = true;
            }
            if (this.fastDespawnMode == 0) {
                ((GuiButton)this.field_146292_n.get((int)4)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)5)).field_146125_m = true;
            } else {
                ((GuiButton)this.field_146292_n.get((int)5)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)4)).field_146125_m = true;
            }
            if (this.expMode == 0) {
                ((GuiButton)this.field_146292_n.get((int)6)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)7)).field_146125_m = true;
            } else {
                ((GuiButton)this.field_146292_n.get((int)7)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)6)).field_146125_m = true;
            }
            if (this.tpToHomeMode == 0) {
                ((GuiButton)this.field_146292_n.get((int)8)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)9)).field_146125_m = true;
            } else {
                ((GuiButton)this.field_146292_n.get((int)9)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)8)).field_146125_m = true;
            }
            this.func_73731_b(this.field_146289_q, Helpers.formatMessage("message.advDDrill.itemMode"), xStart + 20, yStart + 38, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, Helpers.formatMessage("message.advDDrill.fastDespawnMode"), xStart + 20, yStart + 54, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, Helpers.formatMessage("message.advDDrill.expMode"), xStart + 20, yStart + 70, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, Helpers.formatMessage("message.advDDrill.tpToHomeMode"), xStart + 20, yStart + 86, 0xFFFFFF);
            if (this.location == null) {
                this.func_73731_b(this.field_146289_q, Helpers.formatMessage("message.advDDrill.home") + ": " + Helpers.formatMessage("message.advDDrill.no"), xStart + 20, yStart + 102, 0xFFFFFF);
            } else {
                this.func_73731_b(this.field_146289_q, Helpers.formatMessage("message.advDDrill.home") + ": X=" + this.location.X + " Y=" + this.location.Y + " Z=" + this.location.Z + (this.houseSide != null && this.houseSide != ForgeDirection.UNKNOWN && !Minecraft.func_71410_x().func_71356_B() ? " " + StatCollector.func_74838_a((String)"message.advDDrill.houseSide") + this.getSide() : ""), xStart + 20, yStart + 102, 0xFFFFFF);
            }
        }
        GL11.glDisable((int)3042);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private String getSide() {
        return StatCollector.func_74838_a((String)("message.advDDrill.side_" + this.houseSide.name()));
    }

    public boolean func_73868_f() {
        return false;
    }
}

