/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.item;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.BlockLocation;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import gravisuite.item.ItemAdvancedDrill;
import gravisuite.keyboard.Keyboard;
import gravisuite.utils.BukkitHelper;
import gravisuite.utils.Helpers;
import gravisuite.utils.NBTHelper;
import ic2.core.IC2;
import ic2.core.util.KeyboardClient;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemAdvIDrill
extends ItemAdvancedDrill {
    private static KeyBinding altKey;

    ItemAdvIDrill(Item.ToolMaterial toolMaterial) {
        super(10.0f, toolMaterial, "gravisuite:itemAdvancedIDrill");
        this.func_77656_e(27);
        this.maxCharge = 500000;
        this.transferLimit = 20000;
        this.tier = 3;
        this.normalPower = 70.0f;
        this.bigHolePower = 32.0f;
        this.lowPower = 32.0f;
        this.ultraLowPower = 20.0f;
        this.energyPerOperation = 280;
        this.energyPerLowOperation = 120;
        this.energyPerUltraLowOperation = 70;
        this.maxWorkRange = 1;
        this.func_77637_a(GraviSuite.graviSuiteCreativeTab);
        this.field_77864_a = this.normalPower;
    }

    @Override
    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return 100;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af() && !Keyboard.isAltKeyDown(player) && !Keyboard.isModeKeyDown(player)) {
            player.openGui((Object)GraviSuite.instance, 6, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return itemStack;
        }
        return super.func_77659_a(itemStack, world, player);
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (player.func_70093_af() && Keyboard.isAltKeyDown(player)) {
            if (!world.field_72995_K && BukkitHelper.canInteract(player, stack, x, y, z, ForgeDirection.getOrientation((int)side))) {
                if (Helpers.isCorrectTileInventory(world, x, y, z)) {
                    NBTHelper.saveHomeLocation(stack, new BlockLocation(x, y, z, world));
                    ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GREEN + "{message.advDDrill.houseSet}");
                } else {
                    ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.advDDrill.incorrectTile}");
                }
            }
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        int toolMode = NBTHelper.readToolMode(itemStack);
        if (toolMode == 0) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.advDDrill.mode.normal"));
        }
        if (toolMode == 1) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.advDDrill.mode.lowPower"));
        }
        if (toolMode == 2) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.advDDrill.mode.fine"));
        }
        if (toolMode == 3) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.advDDrill.mode.bigHoles"));
        }
        if (toolMode == 4) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.advIDrill.mode.superBigHoles"));
        }
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        list.add(StatCollector.func_74837_a((String)"gravisuite.tooltips.drillhome", (Object[])new Object[]{GameSettings.func_74298_c((int)settings.field_74311_E.func_151463_i()), GameSettings.func_74298_c((int)(altKey != null ? altKey.func_151463_i() : 56)), GameSettings.func_74298_c((int)settings.field_74313_G.func_151463_i())}));
        list.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.getTier(itemStack));
    }

    static {
        try {
            altKey = (KeyBinding)ReflectionHelper.getPrivateValue(KeyboardClient.class, (Object)((KeyboardClient)IC2.keyboard), (String[])new String[]{"altKey"});
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

