/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import gravisuite.network.IPacket;
import gravisuite.utils.ReflectionHelper;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

public class PacketHandler {
    public static String channelName = "GraviSuite";
    private static FMLEventChannel channel;
    HashMap<Integer, Class<? extends IPacket>> packets = new HashMap();

    public PacketHandler() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
        channel.register((Object)this);
        Set<Class<? extends IPacket>> classes = ReflectionHelper.getPacketClasses("gravisuite.network");
        for (Class<? extends IPacket> class1 : classes) {
            try {
                this.packets.put(class1.getField("packetID").getInt(null), class1);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e2) {
                e2.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), null);
    }

    public void onPacketData(InputStream is, EntityPlayer player) {
        DataInputStream data = new DataInputStream(is);
        try {
            byte packetId = data.readByte();
            Class<? extends IPacket> packetClass = this.packets.get(packetId);
            IPacket iPacket = packetClass.newInstance();
            iPacket.readData(data);
            iPacket.execute(player);
            data.close();
        }
        catch (Exception var8) {
            var8.printStackTrace();
        }
    }

    private static FMLProxyPacket makePacket(byte[] data) {
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])data), channelName);
    }

    public static void sendPacket(byte[] data) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            channel.sendToServer(PacketHandler.makePacket(data));
        } else {
            channel.sendToAll(PacketHandler.makePacket(data));
        }
    }

    public static void sendPacket(byte[] data, EntityPlayerMP player) {
        channel.sendTo(PacketHandler.makePacket(data), player);
    }
}

