/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.exp;

import ic2.api.crops.CropCard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import speiger.src.crops.IC2NeiPlugin;
import speiger.src.crops.api.CropPluginAPI;
import speiger.src.crops.core.ICropCalculator;

public class ExpCalculator
implements ICropCalculator {
    @Override
    public List<ICropCalculator.BreedMap> getBreedingResults(CropCard ... par1) {
        return this.getBreeds(par1);
    }

    public List<ICropCalculator.BreedMap> getBreeds(CropCard ... par1) {
        ArrayList<ICropCalculator.BreedMap> map = new ArrayList<ICropCalculator.BreedMap>();
        HashMap<CropCard, Integer> cards = new HashMap<CropCard, Integer>();
        ArrayList<CropCard> card = IC2NeiPlugin.allCrops;
        for (int i = 1; i < card.size(); ++i) {
            for (int x = 0; x < par1.length; ++x) {
                int points;
                CropCard key = (CropCard)card.get(i);
                CropCard value = par1[x];
                if (key == null || value == null || key == value || (points = this.getPoints(key, value)) <= 0) continue;
                if (cards.containsKey(key)) {
                    cards.put(key, points + (Integer)cards.get(key));
                    continue;
                }
                cards.put(key, points);
            }
        }
        ICropCalculator.BreedEntry[] entry = new ICropCalculator.BreedEntry[par1.length];
        for (int i = 0; i < entry.length; ++i) {
            entry[i] = new ICropCalculator.BreedEntry(par1[i]);
        }
        for (Map.Entry entries : cards.entrySet()) {
            ItemStack item = IC2NeiPlugin.displayItems.get(entries.getKey());
            if (IC2NeiPlugin.displayOtherItems) {
                item = CropPluginAPI.instance.getDisplayItem((CropCard)entries.getKey());
            }
            map.add(new ICropCalculator.BreedMap((CropCard)entries.getKey(), (Integer)entries.getValue(), item, entry));
        }
        return map;
    }

    public int getPoints(CropCard par1, CropCard par2) {
        if (par1 == par2) {
            return 500;
        }
        int value = 0;
        for (int i = 0; i < 5; ++i) {
            int delta = Math.abs(par1.stat(i) - par2.stat(i));
            value += -delta + 2;
        }
        for (int x = 0; x < par1.attributes().length; ++x) {
            String one = par1.attributes()[x];
            for (int y = 0; y < par2.attributes().length; ++y) {
                String two = par2.attributes()[y];
                if (!one.equalsIgnoreCase(two)) continue;
                value += 5;
            }
        }
        int diff = par1.tier() - par2.tier();
        if (diff > 1) {
            value -= 2 * diff;
        }
        if (diff < -3) {
            value -= -diff;
        }
        if (value < 0) {
            value = 0;
        }
        return value;
    }
}

