/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardBase;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.utils.LangHelper;
import shedar.mods.ic2.nuclearcontrol.utils.LiquidStorageHelper;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;

public class ItemCardLiquidArrayLocation
extends ItemCardBase {
    public static final int DISPLAY_NAME = 1;
    public static final int DISPLAY_AMOUNT = 2;
    public static final int DISPLAY_FREE = 4;
    public static final int DISPLAY_CAPACITY = 8;
    public static final int DISPLAY_PERCENTAGE = 16;
    public static final int DISPLAY_EACH = 32;
    public static final int DISPLAY_TOTAL = 64;
    private static final int STATUS_NOT_FOUND = Integer.MIN_VALUE;
    private static final int STATUS_OUT_OF_RANGE = -2147483647;
    public static final UUID CARD_TYPE = new UUID(0L, 3L);

    public ItemCardLiquidArrayLocation() {
        super("cardLiquidArray");
    }

    private int[] getCoordinates(ICardWrapper card, int cardNumber) {
        int cardCount = card.getInt("cardCount");
        if (cardNumber >= cardCount) {
            return null;
        }
        int[] coordinates = new int[]{card.getInt(String.format("_%dx", cardNumber)), card.getInt(String.format("_%dy", cardNumber)), card.getInt(String.format("_%dz", cardNumber))};
        return coordinates;
    }

    public static int getCardCount(ICardWrapper card) {
        return card.getInt("cardCount");
    }

    public static void initArray(CardWrapperImpl card, Vector<ItemStack> cards) {
        int cardCount = ItemCardLiquidArrayLocation.getCardCount(card);
        for (ItemStack subCard : cards) {
            CardWrapperImpl wrapper = new CardWrapperImpl(subCard, -1);
            ChunkCoordinates target = wrapper.getTarget();
            if (target == null) continue;
            card.setInt(String.format("_%dx", cardCount), target.field_71574_a);
            card.setInt(String.format("_%dy", cardCount), target.field_71572_b);
            card.setInt(String.format("_%dz", cardCount), target.field_71573_c);
            card.setInt(String.format("_%dtargetType", cardCount), wrapper.getInt("targetType"));
            ++cardCount;
        }
        card.setInt("cardCount", cardCount);
    }

    @Override
    public CardState update(TileEntity panel, ICardWrapper card, int range) {
        int cardCount = ItemCardLiquidArrayLocation.getCardCount(card);
        double totalAmount = 0.0;
        if (cardCount == 0) {
            return CardState.INVALID_CARD;
        }
        boolean foundAny = false;
        boolean outOfRange = false;
        int liquidId = 0;
        for (int i = 0; i < cardCount; ++i) {
            int[] coordinates = this.getCoordinates(card, i);
            int dx = coordinates[0] - panel.field_145851_c;
            int dy = coordinates[1] - panel.field_145848_d;
            int dz = coordinates[2] - panel.field_145849_e;
            if (Math.abs(dx) <= range && Math.abs(dy) <= range && Math.abs(dz) <= range) {
                FluidTankInfo storage = LiquidStorageHelper.getStorageAt(panel.func_145831_w(), coordinates[0], coordinates[1], coordinates[2]);
                if (storage != null) {
                    if (storage.fluid != null) {
                        totalAmount += (double)storage.fluid.amount;
                        card.setInt(String.format("_%damount", i), storage.fluid.amount);
                        if (storage.fluid.getFluidID() != 0 && storage.fluid.amount > 0) {
                            liquidId = storage.fluid.getFluidID();
                        }
                        if (liquidId == 0) {
                            card.setString(String.format("_%dname", i), LangHelper.translate("msg.nc.None"));
                        } else {
                            card.setString(String.format("_%dname", i), FluidRegistry.getFluidName((FluidStack)storage.fluid));
                        }
                    }
                    card.setInt(String.format("_%dcapacity", i), storage.capacity);
                    foundAny = true;
                    continue;
                }
                card.setInt(String.format("_%damount", i), Integer.MIN_VALUE);
                continue;
            }
            card.setInt(String.format("_%damount", i), -2147483647);
            outOfRange = true;
        }
        card.setDouble("energyL", totalAmount);
        if (!foundAny) {
            if (outOfRange) {
                return CardState.OUT_OF_RANGE;
            }
            return CardState.NO_TARGET;
        }
        return CardState.OK;
    }

    @Override
    public CardState update(World world, ICardWrapper card, int range) {
        return CardState.CUSTOM_ERROR;
    }

    @Override
    public UUID getCardType() {
        return CARD_TYPE;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        PanelString line;
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        double totalAmount = 0.0;
        double totalCapacity = 0.0;
        boolean showEach = (displaySettings & 0x20) > 0;
        boolean showSummary = (displaySettings & 0x40) > 0;
        boolean showName = (displaySettings & 1) > 0;
        boolean showAmount = true;
        boolean showFree = (displaySettings & 4) > 0;
        boolean showCapacity = (displaySettings & 8) > 0;
        boolean showPercentage = (displaySettings & 0x10) > 0;
        int cardCount = ItemCardLiquidArrayLocation.getCardCount(card);
        for (int i = 0; i < cardCount; ++i) {
            boolean isNotFound;
            int amount = card.getInt(String.format("_%damount", i));
            int capacity = card.getInt(String.format("_%dcapacity", i));
            boolean isOutOfRange = amount == -2147483647;
            boolean bl = isNotFound = amount == Integer.MIN_VALUE;
            if (showSummary && !isOutOfRange && !isNotFound) {
                totalAmount += (double)amount;
                totalCapacity += (double)capacity;
            }
            if (!showEach) continue;
            if (isOutOfRange) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormattedKey("msg.nc.InfoPanelOutOfRangeN", i + 1);
                result.add(line);
                continue;
            }
            if (isNotFound) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormattedKey("msg.nc.InfoPanelNotFoundN", i + 1);
                result.add(line);
                continue;
            }
            if (showName) {
                line = new PanelString();
                line.textLeft = showLabels ? StringUtils.getFormattedKey("msg.nc.InfoPanelLiquidNameN", i + 1, card.getString(String.format("_%dname", i))) : StringUtils.getFormatted("", amount, false);
                result.add(line);
            }
            if (showAmount) {
                line = new PanelString();
                line.textLeft = showLabels ? StringUtils.getFormattedKey("msg.nc.InfoPanelLiquidN", i + 1, StringUtils.getFormatted("", amount, false)) : StringUtils.getFormatted("", amount, false);
                result.add(line);
            }
            if (showFree) {
                line = new PanelString();
                line.textLeft = showLabels ? StringUtils.getFormattedKey("msg.nc.InfoPanelLiquidFreeN", i + 1, StringUtils.getFormatted("", capacity - amount, false)) : StringUtils.getFormatted("", capacity - amount, false);
                result.add(line);
            }
            if (showCapacity) {
                line = new PanelString();
                line.textLeft = showLabels ? StringUtils.getFormattedKey("msg.nc.InfoPanelLiquidCapacityN", i + 1, StringUtils.getFormatted("", capacity, false)) : StringUtils.getFormatted("", capacity, false);
                result.add(line);
            }
            if (!showPercentage) continue;
            line = new PanelString();
            line.textLeft = showLabels ? StringUtils.getFormattedKey("msg.nc.InfoPanelLiquidPercentageN", i + 1, StringUtils.getFormatted("", capacity == 0 ? 100.0 : (double)amount / (double)capacity * 100.0, false)) : StringUtils.getFormatted("", capacity == 0 ? 100.0 : (double)amount / (double)capacity * 100.0, false);
            result.add(line);
        }
        if (showSummary) {
            if (showAmount) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelLiquidAmount", totalAmount, showLabels);
                result.add(line);
            }
            if (showFree) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelLiquidFree", totalCapacity - totalAmount, showLabels);
                result.add(line);
            }
            if (showName) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelLiquidCapacity", totalCapacity, showLabels);
                result.add(line);
            }
            if (showPercentage) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelLiquidPercentage", totalCapacity == 0.0 ? 100.0 : totalAmount / totalCapacity * 100.0, showLabels);
                result.add(line);
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(3);
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelLiquidName"), 1, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelLiquidFree"), 4, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelLiquidCapacity"), 8, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelLiquidPercentage"), 16, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelLiquidEach"), 32, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelLiquidTotal"), 64, CARD_TYPE));
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean advanced) {
        CardWrapperImpl card = new CardWrapperImpl(itemStack, -1);
        int cardCount = ItemCardLiquidArrayLocation.getCardCount(card);
        if (cardCount > 0) {
            String title = card.getTitle();
            if (title != null && !title.isEmpty()) {
                info.add(title);
            }
            String hint = String.format(LangHelper.translate("msg.nc.LiquidCardQuantity"), cardCount);
            info.add(hint);
        }
    }
}

