/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.messages;

import neresources.api.messages.ModifyMessage;
import neresources.api.messages.utils.MessageHelper;
import neresources.api.utils.Priority;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ModifyOreMessage
extends ModifyMessage {
    private ItemStack ore;
    private ItemStack[] addDrops = new ItemStack[0];
    private ItemStack[] removeDrops = new ItemStack[0];

    public ModifyOreMessage(ItemStack ore, ItemStack ... drops) {
        this(ore, true, drops);
    }

    public ModifyOreMessage(ItemStack ore, Priority priority, ItemStack ... drops) {
        this(ore, true, priority, drops);
    }

    public ModifyOreMessage(ItemStack ore, boolean add, ItemStack ... drops) {
        this(ore, add, Priority.SECOND, drops);
    }

    public ModifyOreMessage(ItemStack ore, boolean add, Priority priority, ItemStack ... drops) {
        super(priority, add);
        this.ore = ore;
        if (add) {
            this.addDrops = drops;
        } else {
            this.removeDrops = drops;
        }
    }

    public ModifyOreMessage(ItemStack ore, ItemStack[] removeDrops, ItemStack[] addDrops) {
        this(ore, removeDrops, addDrops, Priority.SECOND, Priority.FIRST);
    }

    public ModifyOreMessage(ItemStack ore, ItemStack[] removeDrops, ItemStack[] addDrops, Priority removePriority, Priority addPriority) {
        super(addPriority, removePriority);
        this.ore = ore;
        this.removeDrops = removeDrops;
        this.addDrops = addDrops;
    }

    public ModifyOreMessage(NBTTagCompound tagCompound) {
        super(tagCompound);
        this.ore = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("stack"));
        this.addDrops = MessageHelper.getItemStacks(tagCompound, "addDrops");
        this.removeDrops = MessageHelper.getItemStacks(tagCompound, "removeDrops");
    }

    public ItemStack getOre() {
        return this.ore;
    }

    public ItemStack[] getRemoveDrops() {
        return this.removeDrops;
    }

    public ItemStack[] getAddDrops() {
        return this.addDrops;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74782_a("stack", (NBTBase)this.ore.func_77955_b(new NBTTagCompound()));
        tagCompound.func_74782_a("addDrops", (NBTBase)MessageHelper.getItemStackList(this.addDrops));
        tagCompound.func_74782_a("removeDrops", (NBTBase)MessageHelper.getItemStackList(this.removeDrops));
        return tagCompound;
    }

    @Override
    public boolean hasAdd() {
        return this.addDrops.length > 0;
    }

    @Override
    public boolean hasRemove() {
        return this.removeDrops.length > 0;
    }

    @Override
    public boolean isValid() {
        return this.ore != null && (this.hasAdd() || this.hasRemove());
    }
}

