/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.utils;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PlantDrop {
    private ItemStack drop;
    private int itemWeight;
    private int minDrop;
    private int maxDrop;
    private float chance;
    private DropKind dropKind;

    public PlantDrop(ItemStack drop, int itemWeight) {
        this.drop = drop;
        this.itemWeight = itemWeight;
        this.dropKind = DropKind.weight;
    }

    public PlantDrop(ItemStack drop, float chance) {
        this.drop = drop;
        this.chance = chance;
        this.dropKind = DropKind.chance;
    }

    public PlantDrop(ItemStack drop, int minDrop, int maxDrop) {
        this.drop = drop;
        this.minDrop = minDrop;
        this.maxDrop = maxDrop;
        this.dropKind = DropKind.minMax;
    }

    public ItemStack getDrop() {
        return this.drop;
    }

    public int getWeight() {
        return this.itemWeight;
    }

    public int getMinDrop() {
        return this.minDrop;
    }

    public int getMaxDrop() {
        return this.maxDrop;
    }

    public float getChance() {
        return this.chance;
    }

    public DropKind getDropKind() {
        return this.dropKind;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("drop", (NBTBase)this.drop.func_77955_b(new NBTTagCompound()));
        compound.func_74768_a("dropKind", this.dropKind.ordinal());
        switch (this.dropKind) {
            case chance: {
                compound.func_74776_a("chance", this.chance);
                break;
            }
            case weight: {
                compound.func_74768_a("weight", this.itemWeight);
                break;
            }
            case minMax: {
                compound.func_74768_a("min", this.minDrop);
                compound.func_74768_a("max", this.maxDrop);
                break;
            }
        }
        return compound;
    }

    public static PlantDrop readFromNBT(NBTTagCompound tagCompound) {
        NBTTagCompound drop = tagCompound.func_74775_l("drop");
        if (drop.func_82582_d()) {
            return null;
        }
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)drop);
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        DropKind kind = DropKind.values()[tagCompound.func_74762_e("dropKind")];
        switch (kind) {
            case chance: {
                float chance = tagCompound.func_74760_g("chance");
                return new PlantDrop(stack, chance);
            }
            case weight: {
                int weight = tagCompound.func_74762_e("weight");
                return new PlantDrop(stack, weight);
            }
            case minMax: {
                int min = tagCompound.func_74762_e("min");
                int max = tagCompound.func_74762_e("max");
                return new PlantDrop(stack, min, max);
            }
        }
        return null;
    }

    public static enum DropKind {
        chance,
        weight,
        minMax;

    }
}

