/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.PositionalNotationPrinter;
import org.apache.commons.lang3.tuple.Pair;

public class DoublePrinter
extends PositionalNotationPrinter<Double> {
    public DoublePrinter(int maxDigits) {
        super(maxDigits);
    }

    @Override
    protected Pair<Double, Double> splitNumber(Double value) {
        double integer = value.intValue();
        double fractional = value - integer;
        return Pair.of((Object)integer, (Object)fractional);
    }

    @Override
    protected PositionalNotationPrinter.IDigitProvider createIntegerDigitProvider(final Double value, final int radix) {
        return new PositionalNotationPrinter.IDigitProvider(){
            private int remainder;
            {
                this.remainder = value.intValue();
            }

            @Override
            public int getNextDigit() {
                int digit = this.remainder % radix;
                this.remainder /= radix;
                return digit;
            }

            @Override
            public boolean hasNextDigit() {
                return this.remainder > 0;
            }
        };
    }

    @Override
    protected PositionalNotationPrinter.IDigitProvider createFractionalDigitProvider(final Double value, int radix) {
        final double doubleRadix = radix;
        return new PositionalNotationPrinter.IDigitProvider(){
            private double remainder;
            {
                this.remainder = value;
            }

            @Override
            public int getNextDigit() {
                this.remainder *= doubleRadix;
                int result = (int)this.remainder;
                this.remainder %= 1.0;
                return result;
            }

            @Override
            public boolean hasNextDigit() {
                return this.remainder > 0.0;
            }
        };
    }

    @Override
    protected boolean isNegative(Double value) {
        return value < 0.0;
    }

    @Override
    protected Double negate(Double value) {
        return -value.doubleValue();
    }

    @Override
    protected boolean isZero(Double value) {
        return value == 0.0;
    }
}

