/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import openmods.utils.BlockUtils;
import openmods.utils.CollectionUtils;
import openmods.utils.Coord;

public class GenericTank
extends FluidTank {
    private List<ForgeDirection> surroundingTanks = Lists.newArrayList();
    private final IFluidFilter filter;
    private static final IFluidFilter NO_RESTRICTIONS = new IFluidFilter(){

        @Override
        public boolean canAcceptFluid(FluidStack stack) {
            return true;
        }
    };
    private static final Function<Fluid, FluidStack> FLUID_CONVERTER = new Function<Fluid, FluidStack>(){

        @Nullable
        public FluidStack apply(@Nullable Fluid input) {
            return new FluidStack(input, 0);
        }
    };

    private static IFluidFilter filter(final FluidStack ... acceptableFluids) {
        if (acceptableFluids.length == 0) {
            return NO_RESTRICTIONS;
        }
        return new IFluidFilter(){

            @Override
            public boolean canAcceptFluid(FluidStack stack) {
                for (FluidStack acceptableFluid : acceptableFluids) {
                    if (!acceptableFluid.isFluidEqual(stack)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public GenericTank(int capacity) {
        super(capacity);
        this.filter = NO_RESTRICTIONS;
    }

    public GenericTank(int capacity, FluidStack ... acceptableFluids) {
        super(capacity);
        this.filter = GenericTank.filter(acceptableFluids);
    }

    public GenericTank(int capacity, Fluid ... acceptableFluids) {
        super(capacity);
        this.filter = GenericTank.filter(CollectionUtils.transform(acceptableFluids, FLUID_CONVERTER));
    }

    private static boolean isNeighbourTank(World world, Coord coord, ForgeDirection dir) {
        TileEntity tile = BlockUtils.getTileInDirectionSafe(world, coord, dir);
        return tile instanceof IFluidHandler;
    }

    private static Set<ForgeDirection> getSurroundingTanks(World world, Coord coord) {
        EnumSet<ForgeDirection> result = EnumSet.noneOf(ForgeDirection.class);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!GenericTank.isNeighbourTank(world, coord, dir)) continue;
            result.add(dir);
        }
        return result;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || this.fluid == null || this.fluid.isFluidEqual(resource)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public int getSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || !this.filter.canAcceptFluid(resource)) {
            return 0;
        }
        return super.fill(resource, doFill);
    }

    public void updateNeighbours(World world, Coord coord, Set<ForgeDirection> sides) {
        this.surroundingTanks = Lists.newArrayList((Iterable)Sets.difference(GenericTank.getSurroundingTanks(world, coord), sides));
    }

    public void updateNeighbours(World world, Coord coord) {
        this.surroundingTanks = Lists.newArrayList(GenericTank.getSurroundingTanks(world, coord));
    }

    private static int tryFillNeighbour(FluidStack drainedFluid, ForgeDirection side, TileEntity otherTank) {
        FluidStack toFill = drainedFluid.copy();
        ForgeDirection fillSide = side.getOpposite();
        if (otherTank instanceof IFluidHandler) {
            return ((IFluidHandler)otherTank).fill(fillSide, toFill, true);
        }
        return 0;
    }

    public void distributeToSides(int amountPerTick, World world, Coord coord, Set<ForgeDirection> allowedSides) {
        FluidStack drainedFluid;
        if (world == null) {
            return;
        }
        if (this.getFluidAmount() <= 0) {
            return;
        }
        if (this.surroundingTanks.isEmpty()) {
            return;
        }
        ArrayList sides = Lists.newArrayList(this.surroundingTanks);
        if (allowedSides != null) {
            sides.retainAll(allowedSides);
            if (sides.isEmpty()) {
                return;
            }
        }
        if ((drainedFluid = this.drain(amountPerTick, false)) != null && drainedFluid.amount > 0) {
            int distributed;
            int startingAmount = drainedFluid.amount;
            Collections.shuffle(sides);
            for (ForgeDirection side : sides) {
                if (drainedFluid.amount <= 0) break;
                TileEntity otherTank = BlockUtils.getTileInDirection(world, coord, side);
                if (otherTank == null) continue;
                drainedFluid.amount -= GenericTank.tryFillNeighbour(drainedFluid, side, otherTank);
            }
            if ((distributed = startingAmount - drainedFluid.amount) > 0) {
                this.drain(distributed, true);
            }
        }
    }

    public void fillFromSides(int maxAmount, World world, Coord coord) {
        this.fillFromSides(maxAmount, world, coord, null);
    }

    public void fillFromSides(int maxAmount, World world, Coord coord, Set<ForgeDirection> allowedSides) {
        if (world == null) {
            return;
        }
        int toDrain = Math.min(maxAmount, this.getSpace());
        if (toDrain <= 0) {
            return;
        }
        if (this.surroundingTanks.isEmpty()) {
            return;
        }
        ArrayList sides = Lists.newArrayList(this.surroundingTanks);
        if (allowedSides != null) {
            sides.retainAll(allowedSides);
            if (sides.isEmpty()) {
                return;
            }
        }
        Collections.shuffle(sides);
        for (ForgeDirection side : sides) {
            if (toDrain <= 0) break;
            toDrain -= this.fillInternal(world, coord, side, toDrain);
        }
    }

    public int fillFromSide(World world, Coord coord, ForgeDirection side) {
        int maxDrain = this.getSpace();
        if (maxDrain <= 0) {
            return 0;
        }
        return this.fillInternal(world, coord, side, maxDrain);
    }

    public int fillFromSide(int maxDrain, World world, Coord coord, ForgeDirection side) {
        if ((maxDrain = Math.max(maxDrain, this.getSpace())) <= 0) {
            return 0;
        }
        return this.fillInternal(world, coord, side, maxDrain);
    }

    private int fillInternal(World world, Coord coord, ForgeDirection side, int maxDrain) {
        int drain = 0;
        TileEntity otherTank = BlockUtils.getTileInDirection(world, coord, side);
        if (otherTank instanceof IFluidHandler) {
            IFluidHandler handler = (IFluidHandler)otherTank;
            ForgeDirection drainSide = side.getOpposite();
            FluidTankInfo[] infos = handler.getTankInfo(drainSide);
            if (infos == null) {
                return 0;
            }
            for (FluidTankInfo info : infos) {
                FluidStack drained;
                if (!this.filter.canAcceptFluid(info.fluid) || (drained = handler.drain(drainSide, maxDrain, true)) == null) continue;
                this.fill(drained, true);
                drain += drained.amount;
                if ((maxDrain -= drained.amount) <= 0) break;
            }
        }
        return drain;
    }

    public static interface IFluidFilter {
        public boolean canAcceptFluid(FluidStack var1);
    }
}

