/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.nio.FloatBuffer;
import java.util.Set;
import openmods.Log;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Util;
import org.lwjgl.util.vector.Matrix4f;

public class OpenGLUtils {
    public static final Function<Integer, String> CONVERT_GL_ERROR = new Function<Integer, String>(){

        public String apply(Integer input) {
            return Util.translateGLErrorString((int)input);
        }
    };
    private static FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);

    public static synchronized void loadMatrix(Matrix4f transform) {
        transform.store(matrixBuffer);
        matrixBuffer.flip();
        GL11.glMultMatrix((FloatBuffer)matrixBuffer);
    }

    public static Set<Integer> getGlErrors() {
        int glError = GL11.glGetError();
        if (glError == 0) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        do {
            result.add((Object)glError);
        } while ((glError = GL11.glGetError()) != 0);
        return result.build();
    }

    public static void flushGlErrors(String location) {
        Set<Integer> errors = OpenGLUtils.getGlErrors();
        if (!errors.isEmpty()) {
            Log.warn("OpenGl errors detected in '%s': [%s]", location, OpenGLUtils.errorsToString(errors));
        }
    }

    public static String errorsToString(Iterable<Integer> errors) {
        return Joiner.on((char)',').join(Iterables.transform(errors, CONVERT_GL_ERROR));
    }
}

