/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.forgottennature;

import cpw.mods.fml.common.Loader;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.api.biome.forgottennature.config.BiomeConfigFN;
import rtg.util.Logger;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.forgottennature.RealisticBiomeFNCherryBlossomWoodland;
import rtg.world.biome.realistic.forgottennature.RealisticBiomeFNCrystalForest;
import rtg.world.biome.realistic.forgottennature.RealisticBiomeFNEucalyptusForest;
import rtg.world.biome.realistic.forgottennature.RealisticBiomeFNGreatwoodForest;
import rtg.world.biome.realistic.forgottennature.RealisticBiomeFNMapleForest;
import rtg.world.biome.realistic.forgottennature.RealisticBiomeFNRedwoodForest;
import rtg.world.biome.realistic.forgottennature.RealisticBiomeFNRedwoodForestHills;
import rtg.world.biome.realistic.forgottennature.RealisticBiomeFNTropicalForest;
import rtg.world.biome.realistic.forgottennature.RealisticBiomeFNTropicalForestHills;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.terrain.TerrainBase;

public class RealisticBiomeFNBase
extends RealisticBiomeBase {
    public static RealisticBiomeBase fnCherryBlossomWoodland;
    public static RealisticBiomeBase fnCrystalForest;
    public static RealisticBiomeBase fnEucalyptusForest;
    public static RealisticBiomeBase fnGreatwoodForest;
    public static RealisticBiomeBase fnMapleForest;
    public static RealisticBiomeBase fnRedwoodForest;
    public static RealisticBiomeBase fnRedwoodForestHills;
    public static RealisticBiomeBase fnTropicalForest;
    public static RealisticBiomeBase fnTropicalForestHills;

    public RealisticBiomeFNBase(BiomeConfig config, BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s) {
        super(config, b, riverbiome, t, s);
        this.waterSurfaceLakeChance = 0;
        this.lavaSurfaceLakeChance = 0;
    }

    public static void addBiomes() {
        if (Loader.isModLoaded((String)"ForgottenNature")) {
            BiomeGenBase[] b = BiomeGenBase.func_150565_n();
            for (int i = 0; i < 256; ++i) {
                if (b[i] == null) continue;
                if (b[i].field_76791_y == null) {
                    Logger.warn("Biome ID %d has no name.", b[i].field_76756_M);
                    continue;
                }
                BiomeGenBase fnBiome = b[i];
                String biomeName = b[i].field_76791_y;
                String biomeClass = b[i].func_150562_l().getName();
                if (biomeName == "Cherry Blossom Woodland" && biomeClass == "ForgottenNature.Biomes.BiomeGenCherryBlossomWoodland") {
                    fnCherryBlossomWoodland = new RealisticBiomeFNCherryBlossomWoodland(fnBiome, BiomeConfigFN.biomeConfigFNCherryBlossomWoodland);
                    continue;
                }
                if (biomeName == "Crystal Forest" && biomeClass == "ForgottenNature.Biomes.BiomeGenCrystalForest") {
                    fnCrystalForest = new RealisticBiomeFNCrystalForest(fnBiome, BiomeConfigFN.biomeConfigFNCrystalForest);
                    continue;
                }
                if (biomeName == "Eucalyptus Forest" && biomeClass == "ForgottenNature.Biomes.BiomeGenEucalyptusForest") {
                    fnEucalyptusForest = new RealisticBiomeFNEucalyptusForest(fnBiome, BiomeConfigFN.biomeConfigFNEucalyptusForest);
                    continue;
                }
                if (biomeName == "Greatwood Forest" && biomeClass == "ForgottenNature.Biomes.BiomeGenGreatwoodForest") {
                    fnGreatwoodForest = new RealisticBiomeFNGreatwoodForest(fnBiome, BiomeConfigFN.biomeConfigFNGreatwoodForest);
                    continue;
                }
                if (biomeName == "Maple Forest" && biomeClass == "ForgottenNature.Biomes.BiomeGenMapleForest") {
                    fnMapleForest = new RealisticBiomeFNMapleForest(fnBiome, BiomeConfigFN.biomeConfigFNMapleForest);
                    continue;
                }
                if (biomeName == "Redwood Forest" && biomeClass == "ForgottenNature.Biomes.BiomeGenRedwoodForest") {
                    fnRedwoodForest = new RealisticBiomeFNRedwoodForest(fnBiome, BiomeConfigFN.biomeConfigFNRedwoodForest);
                    continue;
                }
                if (biomeName == "Redwood Forest Hills" && biomeClass == "ForgottenNature.Biomes.BiomeGenRedwoodForestHills") {
                    fnRedwoodForestHills = new RealisticBiomeFNRedwoodForestHills(fnBiome, BiomeConfigFN.biomeConfigFNRedwoodForestHills);
                    continue;
                }
                if (biomeName == "Tropical Forest" && biomeClass == "ForgottenNature.Biomes.BiomeGenTropicalForest") {
                    fnTropicalForest = new RealisticBiomeFNTropicalForest(fnBiome, BiomeConfigFN.biomeConfigFNTropicalForest);
                    continue;
                }
                if (biomeName != "Tropical Forest Hills" || biomeClass != "ForgottenNature.Biomes.BiomeGenTropicalForestHills") continue;
                fnTropicalForestHills = new RealisticBiomeFNTropicalForestHills(fnBiome, BiomeConfigFN.biomeConfigFNTropicalForestHills);
            }
        }
    }
}

